/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.dispatch.DefaultDispatch;
import org.apache.knox.gateway.ha.dispatch.i18n.HaDispatchMessages;
import org.apache.knox.gateway.ha.provider.HaProvider;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class DefaultHaDispatch
extends DefaultDispatch {
    protected static final String FAILOVER_COUNTER_ATTRIBUTE = "dispatch.ha.failover.counter";
    protected static final HaDispatchMessages LOG = (HaDispatchMessages)MessagesFactory.get(HaDispatchMessages.class);
    private static final Map<String, String> urlToHashLookup = new HashMap<String, String>();
    private static final Map<String, String> hashToUrlLookup = new HashMap<String, String>();
    private int maxFailoverAttempts = 3;
    private int failoverSleep = 1000;
    private boolean stickySessionsEnabled = false;
    private boolean loadBalancingEnabled = false;
    private boolean noFallbackEnabled = false;
    private String stickySessionCookieName = "KNOX_BACKEND";
    private HaProvider haProvider;

    public void init() {
        super.init();
        LOG.initializingForResourceRole(this.getServiceRole());
        if (this.haProvider != null) {
            HaServiceConfig serviceConfig = this.haProvider.getHaDescriptor().getServiceConfig(this.getServiceRole());
            this.maxFailoverAttempts = serviceConfig.getMaxFailoverAttempts();
            this.failoverSleep = serviceConfig.getFailoverSleep();
            this.stickySessionsEnabled = serviceConfig.isStickySessionEnabled();
            this.loadBalancingEnabled = serviceConfig.isLoadBalancingEnabled();
            this.noFallbackEnabled = serviceConfig.isNoFallbackEnabled();
            this.stickySessionCookieName = serviceConfig.getStickySessionCookieName();
            this.setupUrlHashLookup();
        }
        this.stickySessionCookieName = this.stickySessionCookieName + '-' + this.getServiceRole();
    }

    private void setupUrlHashLookup() {
        for (String url : this.haProvider.getURLs(this.getServiceRole())) {
            String urlHash = this.hash(url);
            urlToHashLookup.put(url, urlHash);
            hashToUrlLookup.put(urlHash, url);
        }
    }

    public HaProvider getHaProvider() {
        return this.haProvider;
    }

    @Configure
    public void setHaProvider(HaProvider haProvider) {
        this.haProvider = haProvider;
    }

    protected void executeRequestWrapper(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        Optional<URI> opt = this.setBackendfromHaCookie(outboundRequest, inboundRequest);
        if (opt.isPresent()) {
            ((HttpRequestBase)outboundRequest).setURI(opt.get());
        }
        this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
        if (!opt.isPresent() && this.stickySessionsEnabled || this.loadBalancingEnabled) {
            this.haProvider.makeNextActiveURLAvailable(this.getServiceRole());
        }
    }

    protected void outboundResponseWrapper(HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) {
        this.setKnoxHaCookie(inboundRequest, outboundResponse);
    }

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (IOException e) {
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    private Optional<URI> setBackendfromHaCookie(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
        if (this.stickySessionsEnabled && inboundRequest.getCookies() != null) {
            for (Cookie cookie : inboundRequest.getCookies()) {
                if (!this.stickySessionCookieName.equals(cookie.getName())) continue;
                String backendURLHash = cookie.getValue();
                String backendURL = hashToUrlLookup.get(backendURLHash);
                if (!this.haProvider.getURLs(this.getServiceRole()).contains(backendURL)) continue;
                try {
                    URI cookieUri = new URI(backendURL);
                    URIBuilder uriBuilder = new URIBuilder(outboundRequest.getURI());
                    uriBuilder.setScheme(cookieUri.getScheme());
                    uriBuilder.setHost(cookieUri.getHost());
                    uriBuilder.setPort(cookieUri.getPort());
                    URI uri = uriBuilder.build();
                    return Optional.of(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }

    private void setKnoxHaCookie(HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) {
        if (this.stickySessionsEnabled) {
            List serviceHaCookies = Collections.emptyList();
            if (inboundRequest.getCookies() != null) {
                serviceHaCookies = Arrays.stream(inboundRequest.getCookies()).filter(cookie -> this.stickySessionCookieName.equals(cookie.getName())).collect(Collectors.toList());
            }
            if (serviceHaCookies != null && !serviceHaCookies.isEmpty() && hashToUrlLookup.containsKey(((Cookie)serviceHaCookies.get(0)).getValue())) {
                return;
            }
            String url = this.haProvider.getActiveURL(this.getServiceRole());
            String cookieValue = urlToHashLookup.get(url);
            Cookie stickySessionCookie = new Cookie(this.stickySessionCookieName, cookieValue);
            stickySessionCookie.setPath(inboundRequest.getContextPath());
            stickySessionCookie.setMaxAge(-1);
            stickySessionCookie.setHttpOnly(true);
            GatewayConfig config = (GatewayConfig)inboundRequest.getServletContext().getAttribute("org.apache.knox.gateway.config");
            if (config != null) {
                stickySessionCookie.setSecure(config.isSSLEnabled());
            }
            outboundResponse.addCookie(stickySessionCookie);
        }
    }

    protected void failoverRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse, Exception exception) throws IOException {
        if (this.noFallbackEnabled && this.stickySessionsEnabled) {
            LOG.noFallbackError();
            outboundResponse.sendError(502, "Service connection error, HA failover disabled");
            return;
        }
        LOG.failingOverRequest(outboundRequest.getURI().toString());
        AtomicInteger counter = (AtomicInteger)inboundRequest.getAttribute(FAILOVER_COUNTER_ATTRIBUTE);
        if (counter == null) {
            counter = new AtomicInteger(0);
        }
        inboundRequest.setAttribute(FAILOVER_COUNTER_ATTRIBUTE, (Object)counter);
        if (counter.incrementAndGet() <= this.maxFailoverAttempts) {
            this.haProvider.markFailedURL(this.getServiceRole(), outboundRequest.getURI().toString());
            this.setupUrlHashLookup();
            inboundRequest.setAttribute("targetRequestUrl", null);
            inboundRequest = new StickySessionCookieRemovedRequest(this.stickySessionCookieName, (HttpServletRequest)inboundRequest);
            URI uri = this.getDispatchUrl((HttpServletRequest)inboundRequest);
            ((HttpRequestBase)outboundRequest).setURI(uri);
            if (this.failoverSleep > 0) {
                try {
                    Thread.sleep(this.failoverSleep);
                }
                catch (InterruptedException e) {
                    LOG.failoverSleepFailed(this.getServiceRole(), e);
                    Thread.currentThread().interrupt();
                }
            }
            this.executeRequest(outboundRequest, (HttpServletRequest)inboundRequest, outboundResponse);
        } else {
            LOG.maxFailoverAttemptsReached(this.maxFailoverAttempts, this.getServiceRole());
            if (inboundResponse != null) {
                this.writeOutboundResponse(outboundRequest, (HttpServletRequest)inboundRequest, outboundResponse, inboundResponse);
            } else {
                throw new IOException(exception);
            }
        }
    }

    private String hash(String url) {
        return DigestUtils.sha256Hex((String)url);
    }

    private static class StickySessionCookieRemovedRequest
    extends HttpServletRequestWrapper {
        private final Cookie[] cookies;

        StickySessionCookieRemovedRequest(String cookieName, HttpServletRequest request) {
            super(request);
            this.cookies = this.filterCookies(cookieName, request.getCookies());
        }

        private Cookie[] filterCookies(String cookieName, Cookie[] cookies) {
            if (super.getCookies() == null) {
                return null;
            }
            ArrayList<Cookie> cookiesInternal = new ArrayList<Cookie>();
            for (Cookie cookie : cookies) {
                if (cookieName.equals(cookie.getName())) continue;
                cookiesInternal.add(cookie);
            }
            return cookiesInternal.toArray(new Cookie[0]);
        }

        public Cookie[] getCookies() {
            return this.cookies;
        }
    }
}

