/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.token;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.security.token.impl.JWT;

public class TokenUtils {
    public static String getTokenId(JWT token) {
        return token.getClaim("knox.id");
    }

    public static boolean isServerManagedTokenStateEnabled(FilterConfig filterConfig) {
        boolean isServerManaged = false;
        String providerParamValue = filterConfig.getInitParameter("knox.token.exp.server-managed");
        if (providerParamValue == null || providerParamValue.isEmpty()) {
            ServletContext context = filterConfig.getServletContext();
            if (context != null) {
                GatewayConfig config = (GatewayConfig)context.getAttribute("org.apache.knox.gateway.config");
                isServerManaged = config != null && config.isServerManagedTokenStateEnabled();
            }
        } else {
            isServerManaged = Boolean.valueOf(providerParamValue);
        }
        return isServerManaged;
    }
}

