/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.Iterator;
import java.util.List;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.SubCache;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;

final class Cache {
    public final Source source;
    private final SubCache allTagTypesSubCache;
    private final SubCache[] subCaches;
    static final Cache STREAMED_SOURCE_MARKER = new Cache();

    public Cache(Source source) {
        this.source = source;
        this.allTagTypesSubCache = new SubCache(this, null);
        TagType[] tagTypeArray = Cache.getSeparatelyCachedTagTypes();
        this.subCaches = new SubCache[tagTypeArray.length + 1];
        this.subCaches[0] = this.allTagTypesSubCache;
        for (int i = 0; i < tagTypeArray.length; ++i) {
            this.subCaches[i + 1] = new SubCache(this, tagTypeArray[i]);
        }
    }

    private Cache() {
        this.source = null;
        this.allTagTypesSubCache = null;
        this.subCaches = null;
    }

    public void clear() {
        Iterator<Tag> iterator = this.allTagTypesSubCache.getTagIterator();
        while (iterator.hasNext()) {
            iterator.next().orphan();
        }
        for (int i = 0; i < this.subCaches.length; ++i) {
            this.subCaches[i].clear();
        }
    }

    public Tag getTagAt(int n, boolean bl) {
        return this.source.useAllTypesCache ? this.allTagTypesSubCache.getTagAt(n, bl) : Tag.getTagAtUncached(this.source, n, bl);
    }

    public Tag getPreviousTag(int n) {
        return this.allTagTypesSubCache.getPreviousTag(n);
    }

    public Tag getNextTag(int n) {
        return this.allTagTypesSubCache.getNextTag(n);
    }

    public Tag getPreviousTag(int n, TagType tagType) {
        int n2;
        int n3 = n2 = this.source.useAllTypesCache ? 0 : 1;
        while (n2 < this.subCaches.length) {
            if (tagType == this.subCaches[n2].tagType) {
                return this.subCaches[n2].getPreviousTag(n);
            }
            ++n2;
        }
        return Tag.getPreviousTagUncached(this.source, n, tagType, -1);
    }

    public Tag getNextTag(int n, TagType tagType) {
        int n2;
        int n3 = n2 = this.source.useAllTypesCache ? 0 : 1;
        while (n2 < this.subCaches.length) {
            if (tagType == this.subCaches[n2].tagType) {
                return this.subCaches[n2].getNextTag(n);
            }
            ++n2;
        }
        return Tag.getNextTagUncached(this.source, n, tagType, -1);
    }

    public Tag addTagAt(int n, boolean bl) {
        Tag tag = Tag.getTagAtUncached(this.source, n, bl);
        if (bl && tag == null) {
            return null;
        }
        this.allTagTypesSubCache.addTagAt(n, tag);
        if (tag == null) {
            return null;
        }
        TagType tagType = tag.getTagType();
        for (int i = 1; i < this.subCaches.length; ++i) {
            if (tagType != this.subCaches[i].tagType) continue;
            this.subCaches[i].addTagAt(n, tag);
            return tag;
        }
        return tag;
    }

    public int getTagCount() {
        return this.allTagTypesSubCache.size() - 2;
    }

    public Iterator<Tag> getTagIterator() {
        return this.allTagTypesSubCache.getTagIterator();
    }

    public void loadAllTags(List<Tag> list, Tag[] tagArray, StartTag[] startTagArray) {
        int n;
        int n2 = list.size();
        this.allTagTypesSubCache.bulkLoad_Init(n2);
        int n3 = 0;
        int n4 = 0;
        block0: for (n = 0; n < n2; ++n) {
            Tag tag = list.get(n);
            if (!tag.isUnregistered()) {
                tagArray[n3++] = tag;
                if (tag instanceof StartTag) {
                    startTagArray[n4++] = (StartTag)tag;
                }
            }
            this.allTagTypesSubCache.bulkLoad_Set(n, tag);
            for (int i = 1; i < this.subCaches.length; ++i) {
                if (tag.getTagType() != this.subCaches[i].tagType) continue;
                this.subCaches[i].bulkLoad_AddToTypeSpecificCache(tag);
                continue block0;
            }
        }
        for (n = 1; n < this.subCaches.length; ++n) {
            this.subCaches[n].bulkLoad_FinaliseTypeSpecificCache();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.subCaches.length; ++i) {
            this.subCaches[i].appendTo(stringBuilder);
        }
        return stringBuilder.toString();
    }

    protected int getSourceLength() {
        return this.source.end;
    }

    private static TagType[] getSeparatelyCachedTagTypes() {
        return TagType.getTagTypesIgnoringEnclosedMarkup();
    }
}

