/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.validation;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.knox.gateway.topology.Topology;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TopologyValidator {
    private Collection<String> errors;
    private final String filePath;

    public TopologyValidator(Topology t) {
        this.filePath = t.getUri().getPath();
    }

    public TopologyValidator(String path) {
        this.filePath = path;
    }

    public TopologyValidator(URL file) {
        this.filePath = file.getPath();
    }

    public boolean validateTopology() {
        this.errors = new LinkedList<String>();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaUrl = this.getClass().getResource("/conf/topology-v1.xsd");
            Schema s = schemaFactory.newSchema(schemaUrl);
            Validator validator = s.newValidator();
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            final LinkedList exceptions = new LinkedList();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) {
                    exceptions.add(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) {
                    exceptions.add(exception);
                }

                @Override
                public void error(SAXParseException exception) {
                    exceptions.add(exception);
                }
            });
            File xml = new File(this.filePath);
            validator.validate(new StreamSource(xml));
            if (!exceptions.isEmpty()) {
                for (SAXParseException e : exceptions) {
                    this.errors.add("Line: " + e.getLineNumber() + " -- " + e.getMessage());
                }
                return false;
            }
            return true;
        }
        catch (IOException e) {
            this.errors.add("Error reading topology file");
            this.errors.add(e.getMessage());
            return false;
        }
        catch (SAXException e) {
            this.errors.add("There was a fatal error in parsing the xml file.");
            this.errors.add(e.getMessage());
            return false;
        }
        catch (NullPointerException n) {
            this.errors.add("Error retrieving schema from ClassLoader");
            return false;
        }
    }

    public Collection<String> getTopologyErrors() {
        if (this.errors != null) {
            return this.errors;
        }
        this.validateTopology();
        return this.errors;
    }

    public String getErrorString() {
        StringBuilder out = new StringBuilder();
        for (String s : this.getTopologyErrors()) {
            out.append(s).append('\n');
        }
        return out.toString();
    }
}

