/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.AsmUtils;
import de.thetaphi.forbiddenapis.ClassSignature;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.ForbiddenViolation;
import de.thetaphi.forbiddenapis.RelatedClassLookup;
import de.thetaphi.forbiddenapis.Signatures;
import de.thetaphi.forbiddenapis.asm.AnnotationVisitor;
import de.thetaphi.forbiddenapis.asm.ClassVisitor;
import de.thetaphi.forbiddenapis.asm.FieldVisitor;
import de.thetaphi.forbiddenapis.asm.Handle;
import de.thetaphi.forbiddenapis.asm.Label;
import de.thetaphi.forbiddenapis.asm.MethodVisitor;
import de.thetaphi.forbiddenapis.asm.RecordComponentVisitor;
import de.thetaphi.forbiddenapis.asm.Type;
import de.thetaphi.forbiddenapis.asm.TypePath;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public final class ClassScanner
extends ClassVisitor
implements Constants {
    private final boolean forbidNonPortableRuntime;
    final RelatedClassLookup lookup;
    final List<ForbiddenViolation> violations = new ArrayList<ForbiddenViolation>();
    final Signatures forbiddenSignatures;
    final Pattern suppressAnnotations;
    private String source = null;
    private boolean isDeprecated = false;
    private boolean done = false;
    String internalMainClassName = null;
    int currentGroupId = 0;
    final Map<Method, Integer> lambdas = new HashMap<Method, Integer>();
    final BitSet suppressedGroups = new BitSet();
    boolean classSuppressed = false;

    public ClassScanner(RelatedClassLookup lookup, Signatures forbiddenSignatures, Pattern suppressAnnotations) {
        super(589824);
        this.lookup = lookup;
        this.forbiddenSignatures = forbiddenSignatures;
        this.suppressAnnotations = suppressAnnotations;
        this.forbidNonPortableRuntime = forbiddenSignatures.isNonPortableRuntimeForbidden();
    }

    private void checkDone() {
        if (this.done) {
            return;
        }
        throw new IllegalStateException("Class not fully scanned.");
    }

    public List<ForbiddenViolation> getSortedViolations() {
        this.checkDone();
        return this.classSuppressed ? Collections.emptyList() : Collections.unmodifiableList(this.violations);
    }

    public String getSourceFile() {
        return this.source;
    }

    String checkClassUse(Type type, String what, boolean deep, String origInternalName) {
        while (type.getSort() == 9) {
            type = type.getElementType();
        }
        if (type.getSort() != 10) {
            return null;
        }
        String printout = this.forbiddenSignatures.checkType(type);
        if (printout != null) {
            return String.format(Locale.ENGLISH, "Forbidden %s use: %s", what, printout);
        }
        if (deep && this.forbidNonPortableRuntime) {
            String binaryClassName = type.getClassName();
            ClassSignature c = this.lookup.lookupRelatedClass(type.getInternalName(), origInternalName);
            if (c != null && c.isRuntimeClass && !AsmUtils.isPortableRuntimeClass(binaryClassName)) {
                return String.format(Locale.ENGLISH, "Forbidden %s use: %s [non-portable or internal runtime class]", what, binaryClassName);
            }
        }
        return null;
    }

    String checkClassUse(String internalName, String what, String origInternalName) {
        return this.checkClassUse(Type.getObjectType(internalName), what, true, origInternalName);
    }

    private String checkClassDefinition(String origName, String superName, String[] interfaces) {
        if (superName != null) {
            String violation = this.checkClassUse(superName, "class", origName);
            if (violation != null) {
                return violation;
            }
            ClassSignature c = this.lookup.lookupRelatedClass(superName, origName);
            if (c != null && (violation = this.checkClassDefinition(origName, c.superName, c.interfaces)) != null) {
                return violation;
            }
        }
        if (interfaces != null) {
            for (String intf : interfaces) {
                String violation = this.checkClassUse(intf, "interface", origName);
                if (violation != null) {
                    return violation;
                }
                ClassSignature c = this.lookup.lookupRelatedClass(intf, origName);
                if (c == null || (violation = this.checkClassDefinition(origName, c.superName, c.interfaces)) == null) continue;
                return violation;
            }
        }
        return null;
    }

    String checkType(Type type) {
        block5: while (type != null) {
            switch (type.getSort()) {
                case 10: {
                    String internalName = type.getInternalName();
                    String violation = this.checkClassUse(type, "class/interface", true, internalName);
                    if (violation != null) {
                        return violation;
                    }
                    ClassSignature c = this.lookup.lookupRelatedClass(internalName, internalName);
                    if (c == null) {
                        return null;
                    }
                    return this.checkClassDefinition(internalName, c.superName, c.interfaces);
                }
                case 9: {
                    type = type.getElementType();
                    continue block5;
                }
                case 11: {
                    ArrayList<String> violations = new ArrayList<String>();
                    String violation = this.checkType(type.getReturnType());
                    if (violation != null) {
                        violations.add(violation);
                    }
                    for (Type t : type.getArgumentTypes()) {
                        violation = this.checkType(t);
                        if (violation == null) continue;
                        violations.add(violation);
                    }
                    if (violations.isEmpty()) {
                        return null;
                    }
                    if (violations.size() == 1) {
                        return (String)violations.get(0);
                    }
                    StringBuilder sb = new StringBuilder();
                    boolean nl = false;
                    for (String v : violations) {
                        if (nl) {
                            sb.append("\n");
                        }
                        sb.append(v);
                        nl = true;
                    }
                    return sb.toString();
                }
            }
            return null;
        }
        return null;
    }

    String checkDescriptor(String desc) {
        return this.checkType(Type.getType(desc));
    }

    String checkAnnotationDescriptor(Type type, boolean visible) {
        return this.checkClassUse(type, "annotation", visible, type.getInternalName());
    }

    void maybeSuppressCurrentGroup(Type annotation) {
        if (this.suppressAnnotations.matcher(annotation.getClassName()).matches()) {
            this.suppressedGroups.set(this.currentGroupId);
        }
    }

    private void reportClassViolation(String violation, String where) {
        if (violation != null) {
            this.violations.add(new ForbiddenViolation(this.currentGroupId, violation, where, -1));
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.internalMainClassName = name;
        this.isDeprecated = (access & 0x20000) != 0;
        this.reportClassViolation(this.checkClassDefinition(name, superName, interfaces), "class declaration");
        if (this.isDeprecated) {
            this.classSuppressed |= this.suppressAnnotations.matcher(DEPRECATED_TYPE.getClassName()).matches();
            this.reportClassViolation(this.checkType(DEPRECATED_TYPE), "deprecation on class declaration");
        }
    }

    @Override
    public void visitSource(String source, String debug) {
        this.source = source;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isDeprecated && DEPRECATED_DESCRIPTOR.equals(desc)) {
            return null;
        }
        Type type = Type.getType(desc);
        this.classSuppressed |= this.suppressAnnotations.matcher(type.getClassName()).matches();
        this.reportClassViolation(this.checkAnnotationDescriptor(type, visible), "annotation on class declaration");
        return null;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.reportClassViolation(this.checkAnnotationDescriptor(Type.getType(desc), visible), "type annotation on class declaration");
        return null;
    }

    @Override
    public FieldVisitor visitField(final int access, final String name, final String desc, String signature, Object value) {
        ++this.currentGroupId;
        if (this.classSuppressed) {
            return null;
        }
        return new FieldVisitor(589824){
            final boolean isDeprecated;
            {
                super(x0);
                boolean bl = this.isDeprecated = (access & 0x20000) != 0;
                if ((access & 0x1000) == 0) {
                    this.reportFieldViolation(ClassScanner.this.checkDescriptor(desc), "field declaration");
                }
                if (this.isDeprecated) {
                    ClassScanner.this.maybeSuppressCurrentGroup(Constants.DEPRECATED_TYPE);
                    this.reportFieldViolation(ClassScanner.this.checkType(Constants.DEPRECATED_TYPE), "deprecation on field declaration");
                }
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                if (this.isDeprecated && Constants.DEPRECATED_DESCRIPTOR.equals(desc2)) {
                    return null;
                }
                Type type = Type.getType(desc2);
                ClassScanner.this.maybeSuppressCurrentGroup(type);
                this.reportFieldViolation(ClassScanner.this.checkAnnotationDescriptor(type, visible), "annotation on field declaration");
                return null;
            }

            @Override
            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                this.reportFieldViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "type annotation on field declaration");
                return null;
            }

            private void reportFieldViolation(String violation, String where) {
                if (violation != null) {
                    ClassScanner.this.violations.add(new ForbiddenViolation(ClassScanner.this.currentGroupId, violation, String.format(Locale.ENGLISH, "%s of '%s'", where, name), -1));
                }
            }
        };
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
        ++this.currentGroupId;
        if (this.classSuppressed) {
            return null;
        }
        return new MethodVisitor(589824){
            private final Method myself;
            private final boolean isDeprecated;
            private int lineNo;
            {
                super(x0);
                this.myself = new Method(name, desc);
                this.isDeprecated = (access & 0x20000) != 0;
                this.lineNo = -1;
                if ((access & 0x1000) == 0) {
                    this.reportMethodViolation(ClassScanner.this.checkDescriptor(desc), "method declaration");
                }
                if (this.isDeprecated) {
                    ClassScanner.this.maybeSuppressCurrentGroup(Constants.DEPRECATED_TYPE);
                    this.reportMethodViolation(ClassScanner.this.checkType(Constants.DEPRECATED_TYPE), "deprecation on method declaration");
                }
            }

            private String checkMethodAccess(String owner, Method method) {
                String violation = ClassScanner.this.checkClassUse(owner, "class/interface", owner);
                if (violation != null) {
                    return violation;
                }
                if ("<clinit>".equals(method.getName())) {
                    return null;
                }
                return this.checkMethodAccessRecursion(owner, method, true, owner);
            }

            private String checkMethodAccessRecursion(String owner, Method method, boolean checkClassUse, String origOwner) {
                String printout = ClassScanner.this.forbiddenSignatures.checkMethod(owner, method);
                if (printout != null) {
                    return "Forbidden method invocation: " + printout;
                }
                ClassSignature c = ClassScanner.this.lookup.lookupRelatedClass(owner, origOwner);
                if (c != null) {
                    String violation;
                    Method lookupMethod;
                    if (c.signaturePolymorphicMethods.contains(method.getName()) && (printout = ClassScanner.this.forbiddenSignatures.checkMethod(owner, lookupMethod = new Method(method.getName(), Constants.SIGNATURE_POLYMORPHIC_DESCRIPTOR))) != null) {
                        return "Forbidden method invocation: " + printout;
                    }
                    if (checkClassUse && c.methods.contains(method) && (violation = ClassScanner.this.checkClassUse(owner, "class/interface", origOwner)) != null) {
                        return violation;
                    }
                    if ("<init>".equals(method.getName())) {
                        return null;
                    }
                    if (c.superName != null && (violation = this.checkMethodAccessRecursion(c.superName, method, true, origOwner)) != null) {
                        return violation;
                    }
                    if (c.interfaces != null) {
                        for (String intf : c.interfaces) {
                            if (intf == null || (violation = this.checkMethodAccessRecursion(intf, method, false, origOwner)) == null) continue;
                            return violation;
                        }
                    }
                }
                return null;
            }

            private String checkFieldAccess(String owner, String field) {
                return this.checkFieldAccessRecursion(owner, field, owner);
            }

            private String checkFieldAccessRecursion(String owner, String field, String origOwner) {
                String violation = ClassScanner.this.checkClassUse(owner, "class/interface", origOwner);
                if (violation != null) {
                    return violation;
                }
                String printout = ClassScanner.this.forbiddenSignatures.checkField(owner, field);
                if (printout != null) {
                    return "Forbidden field access: " + printout;
                }
                ClassSignature c = ClassScanner.this.lookup.lookupRelatedClass(owner, origOwner);
                if (c != null && !c.fields.contains(field)) {
                    if (c.interfaces != null) {
                        for (String intf : c.interfaces) {
                            if (intf == null || (violation = this.checkFieldAccessRecursion(intf, field, origOwner)) == null) continue;
                            return violation;
                        }
                    }
                    if (c.superName != null && (violation = this.checkFieldAccessRecursion(c.superName, field, origOwner)) != null) {
                        return violation;
                    }
                }
                return null;
            }

            private String checkHandle(Handle handle, boolean checkLambdaHandle) {
                switch (handle.getTag()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return this.checkFieldAccess(handle.getOwner(), handle.getName());
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        Method m = new Method(handle.getName(), handle.getDesc());
                        if (checkLambdaHandle && handle.getOwner().equals(ClassScanner.this.internalMainClassName) && handle.getName().startsWith("lambda$")) {
                            ClassScanner.this.lambdas.put(m, ClassScanner.this.currentGroupId);
                        }
                        return this.checkMethodAccess(handle.getOwner(), m);
                    }
                }
                return null;
            }

            private String checkConstant(Object cst, boolean checkLambdaHandle) {
                if (cst instanceof Type) {
                    return ClassScanner.this.checkType((Type)cst);
                }
                if (cst instanceof Handle) {
                    return this.checkHandle((Handle)cst, checkLambdaHandle);
                }
                return null;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                if (this.isDeprecated && Constants.DEPRECATED_DESCRIPTOR.equals(desc2)) {
                    return null;
                }
                Type type = Type.getType(desc2);
                ClassScanner.this.maybeSuppressCurrentGroup(type);
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(type, visible), "annotation on method declaration");
                return null;
            }

            @Override
            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc2, boolean visible) {
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "parameter annotation on method declaration");
                return null;
            }

            @Override
            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "type annotation on method declaration");
                return null;
            }

            @Override
            public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "annotation in method body");
                return null;
            }

            @Override
            public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc2, boolean visible) {
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "annotation in method body");
                return null;
            }

            @Override
            public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                this.reportMethodViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "annotation in method body");
                return null;
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name2, String desc2, boolean itf) {
                this.reportMethodViolation(this.checkMethodAccess(owner, new Method(name2, desc2)), "method body");
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name2, String desc2) {
                this.reportMethodViolation(this.checkFieldAccess(owner, name2), "method body");
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                if (opcode == 189) {
                    this.reportMethodViolation(ClassScanner.this.checkType(Type.getObjectType(type)), "method body");
                }
            }

            @Override
            public void visitMultiANewArrayInsn(String desc2, int dims) {
                this.reportMethodViolation(ClassScanner.this.checkDescriptor(desc2), "method body");
            }

            @Override
            public void visitLdcInsn(Object cst) {
                this.reportMethodViolation(this.checkConstant(cst, false), "method body");
            }

            @Override
            public void visitInvokeDynamicInsn(String name2, String desc2, Handle bsm, Object ... bsmArgs) {
                boolean isLambdaMetaFactory = "java/lang/invoke/LambdaMetafactory".equals(bsm.getOwner());
                this.reportMethodViolation(this.checkHandle(bsm, false), "method body");
                for (Object cst : bsmArgs) {
                    this.reportMethodViolation(this.checkConstant(cst, isLambdaMetaFactory), "method body");
                }
            }

            private String getHumanReadableMethodSignature() {
                Type[] args = Type.getType(this.myself.getDescriptor()).getArgumentTypes();
                StringBuilder sb = new StringBuilder(this.myself.getName()).append('(');
                boolean comma = false;
                for (Type t : args) {
                    if (comma) {
                        sb.append(',');
                    }
                    sb.append(t.getClassName());
                    comma = true;
                }
                sb.append(')');
                return sb.toString();
            }

            private void reportMethodViolation(String violation, String where) {
                if (violation != null) {
                    ClassScanner.this.violations.add(new ForbiddenViolation(ClassScanner.this.currentGroupId, this.myself, violation, String.format(Locale.ENGLISH, "%s of '%s'", where, this.getHumanReadableMethodSignature()), this.lineNo));
                }
            }

            @Override
            public void visitLineNumber(int lineNo, Label start) {
                this.lineNo = lineNo;
            }
        };
    }

    @Override
    public RecordComponentVisitor visitRecordComponent(final String name, final String desc, String signature) {
        ++this.currentGroupId;
        if (this.classSuppressed) {
            return null;
        }
        return new RecordComponentVisitor(589824){
            {
                super(x0);
                this.reportRecordComponentViolation(ClassScanner.this.checkDescriptor(desc), "record component declaration");
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                Type type = Type.getType(desc2);
                ClassScanner.this.maybeSuppressCurrentGroup(type);
                this.reportRecordComponentViolation(ClassScanner.this.checkAnnotationDescriptor(type, visible), "annotation on record component declaration");
                return null;
            }

            @Override
            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc2, boolean visible) {
                this.reportRecordComponentViolation(ClassScanner.this.checkAnnotationDescriptor(Type.getType(desc2), visible), "type annotation on record component declaration");
                return null;
            }

            private void reportRecordComponentViolation(String violation, String where) {
                if (violation != null) {
                    ClassScanner.this.violations.add(new ForbiddenViolation(ClassScanner.this.currentGroupId, violation, String.format(Locale.ENGLISH, "%s of '%s'", where, name), -1));
                }
            }
        };
    }

    @Override
    public void visitEnd() {
        for (ForbiddenViolation v : this.violations) {
            Integer newGroupId;
            if (v.targetMethod == null || (newGroupId = this.lambdas.get(v.targetMethod)) == null) continue;
            v.setGroupId(newGroupId);
        }
        if (!this.suppressedGroups.isEmpty()) {
            Iterator<ForbiddenViolation> it = this.violations.iterator();
            while (it.hasNext()) {
                ForbiddenViolation v;
                v = it.next();
                if (!this.suppressedGroups.get(v.getGroupId())) continue;
                it.remove();
            }
        }
        Collections.sort(this.violations);
        this.done = true;
    }
}

