/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Rolling upgrade arguments used in the CDH Upgrade Command. Part of ApiCdhUpgradeArgs.")
public class ApiRollingUpgradeClusterArgs {
    @SerializedName(value="slaveBatchSize")
    private BigDecimal slaveBatchSize = null;
    @SerializedName(value="sleepSeconds")
    private BigDecimal sleepSeconds = null;
    @SerializedName(value="slaveFailCountThreshold")
    private BigDecimal slaveFailCountThreshold = null;

    public ApiRollingUpgradeClusterArgs slaveBatchSize(BigDecimal slaveBatchSize) {
        this.slaveBatchSize = slaveBatchSize;
        return this;
    }

    @ApiModelProperty(value="Number of slave roles to restart at a time. Must be greater than zero. Default is 1.  Please note that for HDFS, this number should be less than the replication factor (default 3) to ensure data availability during rolling restart.")
    public BigDecimal getSlaveBatchSize() {
        return this.slaveBatchSize;
    }

    public void setSlaveBatchSize(BigDecimal slaveBatchSize) {
        this.slaveBatchSize = slaveBatchSize;
    }

    public ApiRollingUpgradeClusterArgs sleepSeconds(BigDecimal sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
        return this;
    }

    @ApiModelProperty(value="Number of seconds to sleep between restarts of slave role batches.  Must be greater than or equal to 0. Default is 0.")
    public BigDecimal getSleepSeconds() {
        return this.sleepSeconds;
    }

    public void setSleepSeconds(BigDecimal sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
    }

    public ApiRollingUpgradeClusterArgs slaveFailCountThreshold(BigDecimal slaveFailCountThreshold) {
        this.slaveFailCountThreshold = slaveFailCountThreshold;
        return this;
    }

    @ApiModelProperty(value="The threshold for number of slave batches that are allowed to fail to restart before the entire command is considered failed.  Must be greather than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>")
    public BigDecimal getSlaveFailCountThreshold() {
        return this.slaveFailCountThreshold;
    }

    public void setSlaveFailCountThreshold(BigDecimal slaveFailCountThreshold) {
        this.slaveFailCountThreshold = slaveFailCountThreshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRollingUpgradeClusterArgs apiRollingUpgradeClusterArgs = (ApiRollingUpgradeClusterArgs)o;
        return Objects.equals(this.slaveBatchSize, apiRollingUpgradeClusterArgs.slaveBatchSize) && Objects.equals(this.sleepSeconds, apiRollingUpgradeClusterArgs.sleepSeconds) && Objects.equals(this.slaveFailCountThreshold, apiRollingUpgradeClusterArgs.slaveFailCountThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.slaveBatchSize, this.sleepSeconds, this.slaveFailCountThreshold);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRollingUpgradeClusterArgs {\n");
        sb.append("    slaveBatchSize: ").append(this.toIndentedString(this.slaveBatchSize)).append("\n");
        sb.append("    sleepSeconds: ").append(this.toIndentedString(this.sleepSeconds)).append("\n");
        sb.append("    slaveFailCountThreshold: ").append(this.toIndentedString(this.slaveFailCountThreshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

