/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;

public class TruststoreSSLContextUtils {
    private static final GatewaySpiMessages LOGGER = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);

    private TruststoreSSLContextUtils() {
    }

    public static SSLContext getTruststoreSSLContext(KeystoreService keystoreService) {
        SSLContext sslContext = null;
        try {
            KeyStore truststore;
            if (keystoreService != null && (truststore = keystoreService.getTruststoreForHttpClient()) != null) {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                sslContextBuilder.loadTrustMaterial(truststore, null);
                sslContext = sslContextBuilder.build();
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | KeystoreServiceException e) {
            LOGGER.failedToLoadTruststore(e.getMessage(), e);
        }
        return sslContext;
    }
}

