/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.session;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.knox.gateway.service.session.SessionInformation;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

@Provider
@Produces(value={"application/xml", "application/json"})
public class SessionInformationMarshaller
implements MessageBodyWriter<SessionInformation> {
    private static Marshaller xmlMarshaller;
    private static Marshaller jsonMarshaller;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return SessionInformation.class == type;
    }

    public long getSize(SessionInformation t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(SessionInformation instance, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            this.getMarshaller(mediaType).marshal((Object)instance, entityStream);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private Marshaller getMarshaller(MediaType mediaType) throws JAXBException {
        return MediaType.APPLICATION_JSON_TYPE.getSubtype().equals(mediaType.getSubtype()) ? this.getJsonMarshaller() : this.getXmlMarshaller();
    }

    private synchronized Marshaller getXmlMarshaller() throws JAXBException {
        if (xmlMarshaller == null) {
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("eclipselink.media-type", "application/xml");
            xmlMarshaller = JAXBContextFactory.createContext((Class[])new Class[]{SessionInformation.class}, properties).createMarshaller();
            xmlMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        return xmlMarshaller;
    }

    private synchronized Marshaller getJsonMarshaller() throws JAXBException {
        if (jsonMarshaller == null) {
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("eclipselink.media-type", "application/json");
            jsonMarshaller = JAXBContextFactory.createContext((Class[])new Class[]{SessionInformation.class}, properties).createMarshaller();
            jsonMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        return jsonMarshaller;
    }
}

