/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.env;

import javax.servlet.ServletContext;
import org.apache.shiro.env.DefaultEnvironment;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.web.env.MutableWebEnvironment;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;

public class DefaultWebEnvironment
extends DefaultEnvironment
implements MutableWebEnvironment {
    private static final String DEFAULT_FILTER_CHAIN_RESOLVER_NAME = "filterChainResolver";
    private ServletContext servletContext;

    @Override
    public FilterChainResolver getFilterChainResolver() {
        return (FilterChainResolver)this.getObject(DEFAULT_FILTER_CHAIN_RESOLVER_NAME, FilterChainResolver.class);
    }

    @Override
    public void setFilterChainResolver(FilterChainResolver filterChainResolver) {
        this.setObject(DEFAULT_FILTER_CHAIN_RESOLVER_NAME, filterChainResolver);
    }

    public SecurityManager getSecurityManager() throws IllegalStateException {
        return this.getWebSecurityManager();
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.assertWebSecurityManager(securityManager);
        super.setSecurityManager(securityManager);
    }

    @Override
    public WebSecurityManager getWebSecurityManager() {
        SecurityManager sm = super.getSecurityManager();
        this.assertWebSecurityManager(sm);
        return (WebSecurityManager)sm;
    }

    @Override
    public void setWebSecurityManager(WebSecurityManager wsm) {
        super.setSecurityManager((SecurityManager)wsm);
    }

    private void assertWebSecurityManager(SecurityManager sm) {
        if (!(sm instanceof WebSecurityManager)) {
            String msg = "SecurityManager instance must be a " + WebSecurityManager.class.getName() + " instance.";
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

