/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxtoken;

import java.text.ParseException;
import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway.service.knoxtoken")
public interface TokenServiceMessages {
    @Message(level=MessageLevel.INFO, text="Knox Token service ({0}) issued token {1} ({2})")
    public void issuedToken(String var1, String var2, String var3);

    @Message(level=MessageLevel.INFO, text="Knox Token service ({0}) renewed the expiration for token {1} ({2}) (renewer={3})")
    public void renewedToken(String var1, String var2, String var3, String var4);

    @Message(level=MessageLevel.INFO, text="Knox Token service ({0}) revoked token {1} ({2}) (renewer={3})")
    public void revokedToken(String var1, String var2, String var3, String var4);

    @Message(level=MessageLevel.ERROR, text="Unable to issue token.")
    public void unableToIssueToken(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.WARN, text="The SSO token time to live - ttl is invalid: {0} - using default.")
    public void invalidTokenTTLEncountered(String var1);

    @Message(level=MessageLevel.WARN, text="Unable to acquire cert for endpoint clients - assume trust will be provisioned separately: {0}.")
    public void unableToAcquireCertForEndpointClients(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="The specified value for the {1} configuration property is not valid for the \"{0}\" topology: {2}")
    public void invalidConfigValue(String var1, String var2, String var3, @StackTrace(level=MessageLevel.DEBUG) Exception var4);

    @Message(level=MessageLevel.INFO, text="Server management of token state is enabled for the \"{0}\" topology.")
    public void serverManagedTokenStateEnabled(String var1);

    @Message(level=MessageLevel.ERROR, text="Knox Token service ({0}) could not parse token {1}: {2}")
    public void invalidToken(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) ParseException var3);

    @Message(level=MessageLevel.WARN, text="There are no token renewers white-listed in the \"{0}\" topology.")
    public void noRenewersConfigured(String var1);

    @Message(level=MessageLevel.ERROR, text="Knox Token service ({0}) rejected a bad renewal request for token {1}: {2}")
    public void badRenewalRequest(String var1, String var2, String var3);

    @Message(level=MessageLevel.ERROR, text="Knox Token service ({0}) rejected a bad revocation request for token {1}: {2}")
    public void badRevocationRequest(String var1, String var2, String var3);

    @Message(level=MessageLevel.ERROR, text="Knox Token service ({0}) rejected a bad set enabled flag request for token {1}: {2}")
    public void badSetEnabledFlagRequest(String var1, String var2, String var3);

    @Message(level=MessageLevel.DEBUG, text="Knox Token service ({0}) stored state for token {1} ({2})")
    public void storedToken(String var1, String var2, String var3);

    @Message(level=MessageLevel.WARN, text="Renewal is disabled for the Knox Token service ({0}). Responding with the expiration from the token {1} ({2})")
    public void renewalDisabled(String var1, String var2, String var3);

    @Message(level=MessageLevel.WARN, text="Invalid duration used for JWT token lifespan ({0}) using the configured TTL for KnoxToken service")
    public void invalidLifetimeValue(String var1);

    @Message(level=MessageLevel.ERROR, text="Unable to get token for user {0}: token limit exceeded")
    public void tokenLimitExceeded(String var1);

    @Message(level=MessageLevel.INFO, text="{0}")
    public void generalInfoMessage(String var1);

    @Message(level=MessageLevel.DEBUG, text="Token impersonation successful: {0}/{1}")
    public void tokenImpersonationSuccess(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Token impersonation failed: {0}")
    public void tokenImpersonationFailed(@StackTrace Throwable var1);
}

