/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHdfsReplicationArguments;
import com.cloudera.api.swagger.model.ApiHiveTable;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.cloudera.api.swagger.model.ReplicationOption;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Replication arguments for Hive services.")
public class ApiHiveCloudReplicationArguments {
    @SerializedName(value="sourceService")
    private ApiServiceRef sourceService = null;
    @SerializedName(value="tableFilters")
    private List<ApiHiveTable> tableFilters = null;
    @SerializedName(value="exportDir")
    private String exportDir = null;
    @SerializedName(value="force")
    private Boolean force = null;
    @SerializedName(value="replicateData")
    private Boolean replicateData = null;
    @SerializedName(value="hdfsArguments")
    private ApiHdfsReplicationArguments hdfsArguments = null;
    @SerializedName(value="replicateImpalaMetadata")
    private Boolean replicateImpalaMetadata = null;
    @SerializedName(value="runInvalidateMetadata")
    private Boolean runInvalidateMetadata = null;
    @SerializedName(value="dryRun")
    private Boolean dryRun = null;
    @SerializedName(value="numThreads")
    private BigDecimal numThreads = null;
    @SerializedName(value="sentryMigration")
    private Boolean sentryMigration = null;
    @SerializedName(value="skipUrlPermissions")
    private Boolean skipUrlPermissions = null;
    @SerializedName(value="sourceAccount")
    private String sourceAccount = null;
    @SerializedName(value="destinationAccount")
    private String destinationAccount = null;
    @SerializedName(value="cloudRootPath")
    private String cloudRootPath = null;
    @SerializedName(value="replicationOption")
    private ReplicationOption replicationOption = null;

    public ApiHiveCloudReplicationArguments sourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
        return this;
    }

    @ApiModelProperty(value="The service to replicate from.")
    public ApiServiceRef getSourceService() {
        return this.sourceService;
    }

    public void setSourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
    }

    public ApiHiveCloudReplicationArguments tableFilters(List<ApiHiveTable> tableFilters) {
        this.tableFilters = tableFilters;
        return this;
    }

    public ApiHiveCloudReplicationArguments addTableFiltersItem(ApiHiveTable tableFiltersItem) {
        if (this.tableFilters == null) {
            this.tableFilters = new ArrayList<ApiHiveTable>();
        }
        this.tableFilters.add(tableFiltersItem);
        return this;
    }

    @ApiModelProperty(value="Filters for tables to include in the replication. Optional. If not provided, include all tables in all databases.")
    public List<ApiHiveTable> getTableFilters() {
        return this.tableFilters;
    }

    public void setTableFilters(List<ApiHiveTable> tableFilters) {
        this.tableFilters = tableFilters;
    }

    public ApiHiveCloudReplicationArguments exportDir(String exportDir) {
        this.exportDir = exportDir;
        return this;
    }

    @ApiModelProperty(value="Directory, in the HDFS service where the target Hive service's data is stored, where the export file will be saved. Optional. If not provided, Cloudera Manager will pick a directory for storing the data.")
    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public ApiHiveCloudReplicationArguments force(Boolean force) {
        this.force = force;
        return this;
    }

    @ApiModelProperty(value="Whether to force overwriting of mismatched tables. Defaults to false.")
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public ApiHiveCloudReplicationArguments replicateData(Boolean replicateData) {
        this.replicateData = replicateData;
        return this;
    }

    @ApiModelProperty(value="Whether to replicate table data stored in HDFS. Defaults to false. <p/> If set, the \"hdfsArguments\" property must be set to configure the HDFS replication job.")
    public Boolean getReplicateData() {
        return this.replicateData;
    }

    public void setReplicateData(Boolean replicateData) {
        this.replicateData = replicateData;
    }

    public ApiHiveCloudReplicationArguments hdfsArguments(ApiHdfsReplicationArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
        return this;
    }

    @ApiModelProperty(value="Arguments for the HDFS replication job. <p/> This must be provided when choosing to replicate table data stored in HDFS. The \"sourceService\", \"sourcePath\" and \"dryRun\" properties of the HDFS arguments are ignored; their values are derived from the Hive replication's information. <p/> The \"destinationPath\" property is used slightly differently from the usual HDFS replication jobs. It is used to map the root path of the source service into the target service. It may be omitted, in which case the source and target paths will match. <p/> Example: if the destination path is set to \"/new_root\", a \"/foo/bar\" path in the source will be stored in \"/new_root/foo/bar\" in the target.")
    public ApiHdfsReplicationArguments getHdfsArguments() {
        return this.hdfsArguments;
    }

    public void setHdfsArguments(ApiHdfsReplicationArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
    }

    public ApiHiveCloudReplicationArguments replicateImpalaMetadata(Boolean replicateImpalaMetadata) {
        this.replicateImpalaMetadata = replicateImpalaMetadata;
        return this;
    }

    @ApiModelProperty(value="Whether to replicate the impala metadata. (i.e. the metadata for impala UDFs and their corresponding binaries in HDFS).")
    public Boolean getReplicateImpalaMetadata() {
        return this.replicateImpalaMetadata;
    }

    public void setReplicateImpalaMetadata(Boolean replicateImpalaMetadata) {
        this.replicateImpalaMetadata = replicateImpalaMetadata;
    }

    public ApiHiveCloudReplicationArguments runInvalidateMetadata(Boolean runInvalidateMetadata) {
        this.runInvalidateMetadata = runInvalidateMetadata;
        return this;
    }

    @ApiModelProperty(value="Whether to run invalidate metadata query or not")
    public Boolean getRunInvalidateMetadata() {
        return this.runInvalidateMetadata;
    }

    public void setRunInvalidateMetadata(Boolean runInvalidateMetadata) {
        this.runInvalidateMetadata = runInvalidateMetadata;
    }

    public ApiHiveCloudReplicationArguments dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @ApiModelProperty(value="Whether to perform a dry run. Defaults to false")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ApiHiveCloudReplicationArguments numThreads(BigDecimal numThreads) {
        this.numThreads = numThreads;
        return this;
    }

    @ApiModelProperty(value="Number of threads to use in multi-threaded export/import phase")
    public BigDecimal getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(BigDecimal numThreads) {
        this.numThreads = numThreads;
    }

    public ApiHiveCloudReplicationArguments sentryMigration(Boolean sentryMigration) {
        this.sentryMigration = sentryMigration;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Boolean getSentryMigration() {
        return this.sentryMigration;
    }

    public void setSentryMigration(Boolean sentryMigration) {
        this.sentryMigration = sentryMigration;
    }

    public ApiHiveCloudReplicationArguments skipUrlPermissions(Boolean skipUrlPermissions) {
        this.skipUrlPermissions = skipUrlPermissions;
        return this;
    }

    @ApiModelProperty(required=true, value="Is skipUrlPermissions on.")
    public Boolean getSkipUrlPermissions() {
        return this.skipUrlPermissions;
    }

    public void setSkipUrlPermissions(Boolean skipUrlPermissions) {
        this.skipUrlPermissions = skipUrlPermissions;
    }

    public ApiHiveCloudReplicationArguments sourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public ApiHiveCloudReplicationArguments destinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDestinationAccount() {
        return this.destinationAccount;
    }

    public void setDestinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
    }

    public ApiHiveCloudReplicationArguments cloudRootPath(String cloudRootPath) {
        this.cloudRootPath = cloudRootPath;
        return this;
    }

    @ApiModelProperty(value="")
    public String getCloudRootPath() {
        return this.cloudRootPath;
    }

    public void setCloudRootPath(String cloudRootPath) {
        this.cloudRootPath = cloudRootPath;
    }

    public ApiHiveCloudReplicationArguments replicationOption(ReplicationOption replicationOption) {
        this.replicationOption = replicationOption;
        return this;
    }

    @ApiModelProperty(value="")
    public ReplicationOption getReplicationOption() {
        return this.replicationOption;
    }

    public void setReplicationOption(ReplicationOption replicationOption) {
        this.replicationOption = replicationOption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHiveCloudReplicationArguments apiHiveCloudReplicationArguments = (ApiHiveCloudReplicationArguments)o;
        return Objects.equals(this.sourceService, apiHiveCloudReplicationArguments.sourceService) && Objects.equals(this.tableFilters, apiHiveCloudReplicationArguments.tableFilters) && Objects.equals(this.exportDir, apiHiveCloudReplicationArguments.exportDir) && Objects.equals(this.force, apiHiveCloudReplicationArguments.force) && Objects.equals(this.replicateData, apiHiveCloudReplicationArguments.replicateData) && Objects.equals(this.hdfsArguments, apiHiveCloudReplicationArguments.hdfsArguments) && Objects.equals(this.replicateImpalaMetadata, apiHiveCloudReplicationArguments.replicateImpalaMetadata) && Objects.equals(this.runInvalidateMetadata, apiHiveCloudReplicationArguments.runInvalidateMetadata) && Objects.equals(this.dryRun, apiHiveCloudReplicationArguments.dryRun) && Objects.equals(this.numThreads, apiHiveCloudReplicationArguments.numThreads) && Objects.equals(this.sentryMigration, apiHiveCloudReplicationArguments.sentryMigration) && Objects.equals(this.skipUrlPermissions, apiHiveCloudReplicationArguments.skipUrlPermissions) && Objects.equals(this.sourceAccount, apiHiveCloudReplicationArguments.sourceAccount) && Objects.equals(this.destinationAccount, apiHiveCloudReplicationArguments.destinationAccount) && Objects.equals(this.cloudRootPath, apiHiveCloudReplicationArguments.cloudRootPath) && Objects.equals((Object)this.replicationOption, (Object)apiHiveCloudReplicationArguments.replicationOption);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceService, this.tableFilters, this.exportDir, this.force, this.replicateData, this.hdfsArguments, this.replicateImpalaMetadata, this.runInvalidateMetadata, this.dryRun, this.numThreads, this.sentryMigration, this.skipUrlPermissions, this.sourceAccount, this.destinationAccount, this.cloudRootPath, this.replicationOption});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHiveCloudReplicationArguments {\n");
        sb.append("    sourceService: ").append(this.toIndentedString(this.sourceService)).append("\n");
        sb.append("    tableFilters: ").append(this.toIndentedString(this.tableFilters)).append("\n");
        sb.append("    exportDir: ").append(this.toIndentedString(this.exportDir)).append("\n");
        sb.append("    force: ").append(this.toIndentedString(this.force)).append("\n");
        sb.append("    replicateData: ").append(this.toIndentedString(this.replicateData)).append("\n");
        sb.append("    hdfsArguments: ").append(this.toIndentedString(this.hdfsArguments)).append("\n");
        sb.append("    replicateImpalaMetadata: ").append(this.toIndentedString(this.replicateImpalaMetadata)).append("\n");
        sb.append("    runInvalidateMetadata: ").append(this.toIndentedString(this.runInvalidateMetadata)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    numThreads: ").append(this.toIndentedString(this.numThreads)).append("\n");
        sb.append("    sentryMigration: ").append(this.toIndentedString(this.sentryMigration)).append("\n");
        sb.append("    skipUrlPermissions: ").append(this.toIndentedString(this.skipUrlPermissions)).append("\n");
        sb.append("    sourceAccount: ").append(this.toIndentedString(this.sourceAccount)).append("\n");
        sb.append("    destinationAccount: ").append(this.toIndentedString(this.destinationAccount)).append("\n");
        sb.append("    cloudRootPath: ").append(this.toIndentedString(this.cloudRootPath)).append("\n");
        sb.append("    replicationOption: ").append(this.toIndentedString((Object)this.replicationOption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

