/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.service.auth.AuthMessages;

@Path(value="auth/api/v1/pre")
public class PreAuthResource {
    static final String RESOURCE_PATH = "auth/api/v1/pre";
    private static final AuthMessages LOG = (AuthMessages)MessagesFactory.get(AuthMessages.class);
    static final String AUTH_ACTOR_ID_HEADER_NAME = "preauth.auth.header.actor.id.name";
    static final String AUTH_ACTOR_GROUPS_HEADER_PREFIX = "preauth.auth.header.actor.groups.prefix";
    static final String GROUP_FILTER_PATTERN = "preauth.group.filter.pattern";
    static final String DEFAULT_AUTH_ACTOR_ID_HEADER_NAME = "X-Knox-Actor-ID";
    static final String DEFAULT_AUTH_ACTOR_GROUPS_HEADER_PREFIX = "X-Knox-Actor-Groups";
    private static final Pattern DEFAULT_GROUP_FILTER_PATTERN = Pattern.compile(".*");
    private static final int MAX_HEADER_LENGTH = 1000;
    private static final String ACTOR_GROUPS_HEADER_FORMAT = "%s-%d";
    @Context
    HttpServletResponse response;
    @Context
    ServletContext context;
    private String authHeaderActorIDName;
    private String authHeaderActorGroupsPrefix;
    private Pattern groupFilterPattern;

    @PostConstruct
    public void init() {
        this.authHeaderActorIDName = this.getInitParameter(AUTH_ACTOR_ID_HEADER_NAME, DEFAULT_AUTH_ACTOR_ID_HEADER_NAME);
        this.authHeaderActorGroupsPrefix = this.getInitParameter(AUTH_ACTOR_GROUPS_HEADER_PREFIX, DEFAULT_AUTH_ACTOR_GROUPS_HEADER_PREFIX);
        String groupFilterPatternString = this.context.getInitParameter(GROUP_FILTER_PATTERN);
        this.groupFilterPattern = groupFilterPatternString == null ? DEFAULT_GROUP_FILTER_PATTERN : Pattern.compile(groupFilterPatternString);
    }

    private String getInitParameter(String paramName, String defaultValue) {
        String initParam = this.context.getInitParameter(paramName);
        return initParam == null ? defaultValue : initParam;
    }

    @GET
    public Response doGet() {
        Set<String> matchingGroupNames;
        String primaryPrincipalName;
        Subject subject = SubjectUtils.getCurrentSubject();
        String string = primaryPrincipalName = subject == null ? null : SubjectUtils.getPrimaryPrincipalName((Subject)subject);
        if (primaryPrincipalName == null) {
            LOG.noPrincipalFound();
            return Response.status((int)401).build();
        }
        this.response.setHeader(this.authHeaderActorIDName, primaryPrincipalName);
        Set<String> set = matchingGroupNames = subject == null ? Collections.emptySet() : SubjectUtils.getGroupPrincipals((Subject)subject).stream().filter(group -> this.groupFilterPattern.matcher(group.getName()).matches()).map(group -> group.getName()).collect(Collectors.toSet());
        if (!matchingGroupNames.isEmpty()) {
            List<String> groupStrings = this.getGroupStrings(matchingGroupNames);
            for (int i = 0; i < groupStrings.size(); ++i) {
                this.response.addHeader(String.format(Locale.ROOT, ACTOR_GROUPS_HEADER_FORMAT, this.authHeaderActorGroupsPrefix, i + 1), groupStrings.get(i));
            }
        }
        return Response.ok().build();
    }

    private List<String> getGroupStrings(Collection<String> groupNames) {
        if (groupNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> groupStrings = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String groupName : groupNames) {
            if (sb.length() + groupName.length() > 1000) {
                groupStrings.add(sb.toString());
                sb = new StringBuilder();
            }
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(groupName);
        }
        if (sb.length() > 0) {
            groupStrings.add(sb.toString());
        }
        return groupStrings;
    }
}

