/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.token.impl;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.knox.gateway.services.ServiceLifecycleException;

public class TokenMAC {
    public static final String KNOX_TOKEN_HASH_KEY_ALIAS_NAME = "knox.token.hash.key";
    private final Mac mac;
    private final Lock hashLock = new ReentrantLock(true);

    public TokenMAC(String algorithm, char[] knoxTokenHashKey) throws ServiceLifecycleException {
        try {
            if (knoxTokenHashKey == null) {
                throw new ServiceLifecycleException("Missing knox.token.hash.key alias from Gateway's credential store");
            }
            SecretKeySpec key = new SecretKeySpec(new String(knoxTokenHashKey).getBytes(StandardCharsets.UTF_8), algorithm);
            this.mac = Mac.getInstance(algorithm);
            this.mac.init(key);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new ServiceLifecycleException("Error while initiating Knox Token MAC: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hash(String tokenId, long issueTime, String userName, String toBeHashed) {
        this.hashLock.lock();
        try {
            this.mac.update(this.getSalt(tokenId, issueTime, userName));
            String string = new String(this.mac.doFinal(toBeHashed.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            return string;
        }
        finally {
            this.hashLock.unlock();
        }
    }

    private byte[] getSalt(String tokenId, long issueTime, String userName) {
        return (tokenId + issueTime + userName).getBytes(StandardCharsets.UTF_8);
    }
}

