/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.session;

import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.service.session.SessionInformation;
import org.apache.knox.gateway.service.session.SessionServiceMessages;

@Singleton
@Path(value="session/api/v1/")
public class SessionResource {
    private static final SessionServiceMessages LOG = (SessionServiceMessages)MessagesFactory.get(SessionServiceMessages.class);
    @Context
    HttpServletRequest request;
    @Context
    ServletContext context;
    private String baseLogoutPageUrl;

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="sessioninfo")
    public SessionInformation getSessionInformation(@QueryParam(value="logoutPageProfile") @DefaultValue(value="") String logoutPageProfile, @QueryParam(value="logoutPageTopologies") @DefaultValue(value="") String logoutPageTopologies) {
        SessionInformation sessionInfo = new SessionInformation();
        String user = SubjectUtils.getCurrentEffectivePrincipalName();
        sessionInfo.setUser(user);
        GatewayConfig config = (GatewayConfig)this.context.getAttribute("org.apache.knox.gateway.config");
        if (config != null && config.homePageLogoutEnabled()) {
            String logoutUrl = this.getBaseGatewayUrl(config) + "/homepage/knoxssout/api/v1/webssout";
            LOG.homePageLogoutEnabled(logoutUrl);
            sessionInfo.setLogoutUrl(logoutUrl);
            sessionInfo.setLogoutPageUrl(this.getLogoutPageUrl(config, logoutPageProfile, logoutPageTopologies));
            sessionInfo.setGlobalLogoutPageUrl(this.getGlobalLogoutPageUrl(config));
        }
        sessionInfo.setCanSeeAllTokens(config != null ? config.canSeeAllTokens(user) : false);
        sessionInfo.setCurrentKnoxSsoCookieTokenId((String)this.request.getAttribute("currentKnoxSsoCookieTokenId"));
        sessionInfo.setBannerText(config != null ? config.getBannerText() : "");
        return sessionInfo;
    }

    private String getBaseGatewayUrl(GatewayConfig config) {
        return this.request.getRequestURL().substring(0, this.request.getRequestURL().length() - this.request.getRequestURI().length()) + "/" + config.getGatewayPath();
    }

    private String getLogoutPageUrl(GatewayConfig config, String logoutPageProfile, String logoutPageTopologies) {
        if (this.baseLogoutPageUrl == null) {
            this.baseLogoutPageUrl = this.getBaseGatewayUrl(config) + "/knoxsso/knoxauth/logout.jsp?originalUrl=" + this.getBaseGatewayUrl(config) + "/homepage/home";
        }
        StringBuilder logoutPageUrlBuilder = new StringBuilder(this.baseLogoutPageUrl);
        String delimiter = "%3F";
        if (StringUtils.isNotBlank((CharSequence)logoutPageProfile)) {
            logoutPageUrlBuilder.append(delimiter).append("profile=").append(logoutPageProfile);
            delimiter = "%26";
        }
        if (StringUtils.isNotBlank((CharSequence)logoutPageTopologies)) {
            logoutPageUrlBuilder.append(delimiter).append("topologies=").append(logoutPageTopologies);
        }
        return logoutPageUrlBuilder.toString();
    }

    private String getGlobalLogoutPageUrl(GatewayConfig config) {
        return config.getGlobalLogoutPageUrl();
    }
}

