/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.filter.AbstractGatewayFilter;

public class RedirectToUrlFilter
extends AbstractGatewayFilter {
    public static final String REDIRECT_TO_URL = "redirectToUrl";
    private static final String GATEWAY_PATH_PLACEHOLDER = "${GATEWAY_PATH}";
    private String redirectUrl;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.redirectUrl = filterConfig.getInitParameter(REDIRECT_TO_URL);
        if (this.redirectUrl != null && this.redirectUrl.contains(GATEWAY_PATH_PLACEHOLDER)) {
            GatewayConfig gatewayConfig = (GatewayConfig)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config");
            this.redirectUrl = this.redirectUrl.replaceAll(Pattern.quote(GATEWAY_PATH_PLACEHOLDER), gatewayConfig.getGatewayPath());
        }
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.redirectUrl != null && request.getHeader("Authorization") == null) {
            response.sendRedirect(this.redirectUrl + this.getOriginalQueryString(request));
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getOriginalQueryString(HttpServletRequest request) {
        String originalQueryString = request.getQueryString();
        return originalQueryString == null ? "" : "?" + originalQueryString;
    }

    String getRedirectUrl() {
        return this.redirectUrl;
    }
}

