/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.protocol.shared.store.LdifLoadFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifFileLoader {
    private static final Logger LOG = LoggerFactory.getLogger(LdifFileLoader.class);
    protected CoreSession coreSession;
    protected File ldif;
    protected final List<LdifLoadFilter> filters;
    protected final ClassLoader loader;
    private int count;

    public LdifFileLoader(CoreSession coreSession, String ldif) {
        this(coreSession, new File(ldif), null);
    }

    public LdifFileLoader(CoreSession coreSession, File ldif, List<? extends LdifLoadFilter> filters) {
        this(coreSession, ldif, filters, null);
    }

    public LdifFileLoader(CoreSession coreSession, File ldif, List<? extends LdifLoadFilter> filters, ClassLoader loader) {
        this.coreSession = coreSession;
        this.ldif = ldif;
        this.loader = loader;
        this.filters = filters == null ? Collections.emptyList() : Collections.unmodifiableList(filters);
    }

    private boolean applyFilters(Dn dn, Entry entry) {
        boolean accept = true;
        int limit = this.filters.size();
        if (limit == 0) {
            return true;
        }
        for (int ii = 0; ii < limit; ++ii) {
            try {
                accept &= this.filters.get(ii).filter(this.ldif, dn, entry, this.coreSession);
            }
            catch (LdapException e) {
                LOG.warn("filter " + this.filters.get(ii) + " was bypassed due to failures", (Throwable)e);
            }
            if (accept) continue;
            return false;
        }
        return true;
    }

    public int execute() {
        try (InputStream in = this.getLdifStream();){
            for (LdifEntry ldifEntry : new LdifReader(in)) {
                Dn dn = ldifEntry.getDn();
                if (ldifEntry.isEntry()) {
                    Entry entry = ldifEntry.getEntry();
                    boolean filterAccepted = this.applyFilters(dn, entry);
                    if (!filterAccepted) continue;
                    try {
                        this.coreSession.lookup(dn, new String[0]);
                        LOG.info("Found {}, will not create.", (Object)dn);
                    }
                    catch (Exception e) {
                        try {
                            this.coreSession.add((Entry)new DefaultEntry(this.coreSession.getDirectoryService().getSchemaManager(), entry));
                            ++this.count;
                            LOG.info("Created {}.", (Object)dn);
                        }
                        catch (LdapException e1) {
                            LOG.info("Could not create entry " + entry, (Throwable)e1);
                        }
                    }
                    continue;
                }
                List items = ldifEntry.getModifications();
                try {
                    this.coreSession.modify(dn, items);
                    LOG.info("Modified: {} with modificationItems: {}", (Object)dn, (Object)items);
                }
                catch (LdapException e) {
                    LOG.info("Could not modify: {} with modificationItems: {}", new Object[]{dn, items, e});
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.error(I18n.err((I18n)I18n.ERR_173, (Object[])new Object[0]));
        }
        catch (Exception ioe) {
            LOG.error(I18n.err((I18n)I18n.ERR_174, (Object[])new Object[0]), (Throwable)ioe);
        }
        return this.count;
    }

    private InputStream getLdifStream() throws IOException {
        InputStream in;
        if (this.ldif.exists()) {
            return Files.newInputStream(this.ldif.toPath(), new OpenOption[0]);
        }
        if (this.loader != null && (in = this.loader.getResourceAsStream(this.ldif.getPath())) != null) {
            return in;
        }
        in = this.getClass().getResourceAsStream(this.ldif.getPath());
        if (in != null) {
            return in;
        }
        in = ClassLoader.getSystemResourceAsStream(this.ldif.getPath());
        if (in != null) {
            return in;
        }
        throw new FileNotFoundException(I18n.err((I18n)I18n.ERR_173, (Object[])new Object[0]));
    }
}

