// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#include <ostream>

#include <glog/logging.h>

#include "kudu/tablet/delta_key.h"
#include "kudu/util/logging.h"

namespace kudu {
namespace tablet {

const char* DeltaType_Name(DeltaType t) {
  switch (t) {
    case UNDO:
      return "UNDO";
    case REDO:
      return "REDO";
    default:
      LOG(DFATAL) << "Unknown delta type: " << t;
  }
  return "UNKNOWN";
}

Status DeltaKey::DeltaKeyError(const Slice& orig, const char* err) {
  return Status::Corruption(strings::Substitute("Bad delta key: $0", err),
                            KUDU_REDACT(orig.ToDebugString(20)));
}

} // namespace tablet
} // namespace kudu
