/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.memcached;

public class CacheStats {
    private final long numHits;
    private final long numMisses;
    private final long getBytes;
    private final long getTime;
    private final long numPut;
    private final long putBytes;
    private final long numEvictions;
    private final long numTimeouts;
    private final long numErrors;

    public CacheStats(long getBytes, long getTime, long numPut, long putBytes, long numHits, long numMisses, long numEvictions, long numTimeouts, long numErrors) {
        this.getBytes = getBytes;
        this.getTime = getTime;
        this.numPut = numPut;
        this.putBytes = putBytes;
        this.numHits = numHits;
        this.numMisses = numMisses;
        this.numEvictions = numEvictions;
        this.numTimeouts = numTimeouts;
        this.numErrors = numErrors;
    }

    public long getNumHits() {
        return this.numHits;
    }

    public long getNumMisses() {
        return this.numMisses;
    }

    public long getNumGet() {
        return this.numHits + this.numMisses;
    }

    public long getNumGetBytes() {
        return this.getBytes;
    }

    public long getNumPutBytes() {
        return this.putBytes;
    }

    public long getNumPut() {
        return this.numPut;
    }

    public long getNumEvictions() {
        return this.numEvictions;
    }

    public long getNumTimeouts() {
        return this.numTimeouts;
    }

    public long getNumErrors() {
        return this.numErrors;
    }

    public long numLookups() {
        return this.numHits + this.numMisses;
    }

    public double hitRate() {
        long lookups = this.numLookups();
        return lookups == 0L ? 0.0 : (double)this.numHits / (double)lookups;
    }

    public long avgGetBytes() {
        return this.getBytes == 0L ? 0L : this.getBytes / this.numLookups();
    }

    public long getAvgGetTime() {
        return this.getTime / this.numLookups();
    }
}

