/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.utils;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class ConsistentHash<T> {
    private final int numberOfVirtualNodeReplicas;
    private final SortedMap<Integer, T> circle = new ConcurrentSkipListMap<Integer, T>();
    private final HashFunction nodeHash = Hashing.murmur3_32();
    private final HashFunction keyHash = Hashing.murmur3_32();

    public ConsistentHash(int numberOfVirtualNodeReplicas, List<T> nodes) {
        this.numberOfVirtualNodeReplicas = numberOfVirtualNodeReplicas;
        this.addNode((T)nodes);
    }

    public ConsistentHash(int numberOfVirtualNodeReplicas) {
        this.numberOfVirtualNodeReplicas = numberOfVirtualNodeReplicas;
    }

    public void addNode(List<T> nodes) {
        for (T node : nodes) {
            this.addNode(node);
        }
    }

    public void addNode(T node) {
        for (int i = 0; i < this.numberOfVirtualNodeReplicas; ++i) {
            this.circle.put(this.getKetamaHash(i + "" + node), node);
        }
    }

    public void remove(List<T> nodes) {
        for (T node : nodes) {
            this.remove(node);
        }
    }

    public void remove(T node) {
        for (int i = 0; i < this.numberOfVirtualNodeReplicas; ++i) {
            this.circle.remove(this.getKetamaHash(i + "" + node));
        }
    }

    public T get(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hash = this.getKeyHash(key.toString());
        if (!this.circle.containsKey(hash)) {
            SortedMap<Integer, T> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey().intValue() : tailMap.firstKey().intValue();
        }
        return (T)this.circle.get(hash);
    }

    private int getKeyHash(String k) {
        return this.keyHash.hashBytes(k.getBytes(Charset.defaultCharset())).asInt();
    }

    private int getKetamaHash(String k) {
        return this.nodeHash.hashBytes(k.getBytes(Charset.defaultCharset())).asInt();
    }
}

