/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Map;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplementationSwitch<I> {
    private static final Logger logger = LoggerFactory.getLogger(ImplementationSwitch.class);
    private final Object[] instances;
    private Class<I> interfaceClz;
    private Map<Integer, String> impls = Maps.newHashMap();

    public ImplementationSwitch(Map<Integer, String> impls, Class<I> interfaceClz) {
        this.impls.putAll(impls);
        this.interfaceClz = interfaceClz;
        this.instances = this.initInstances(this.impls);
    }

    private Object[] initInstances(Map<Integer, String> impls) {
        int maxId = 0;
        for (Integer id : impls.keySet()) {
            maxId = Math.max(maxId, id);
        }
        if (maxId > 100) {
            throw new IllegalArgumentException("you have more than 100 implementations?");
        }
        Object[] result = new Object[maxId + 1];
        return result;
    }

    public synchronized I get(int id) {
        String clzName = this.impls.get(id);
        if (clzName == null) {
            throw new IllegalArgumentException("Implementation class missing, ID " + id + ", interface " + this.interfaceClz.getName());
        }
        Object result = this.instances[id];
        if (result == null) {
            try {
                this.instances[id] = result = ClassUtil.newInstance(clzName);
            }
            catch (Exception ex) {
                logger.warn("Implementation missing " + clzName + " - " + ex);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Implementations missing, ID " + id + ", interface " + this.interfaceClz.getName());
        }
        return (I)result;
    }
}

