/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class OptionsHelper {
    private CommandLine commandLine;

    public void parseOptions(Options options, String[] args) throws ParseException {
        GnuParser parser = new GnuParser();
        this.commandLine = parser.parse(options, args);
    }

    public Option[] getOptions() {
        return this.commandLine.getOptions();
    }

    public String getOptionsAsString() {
        StringBuilder buf = new StringBuilder();
        for (Option option : this.commandLine.getOptions()) {
            buf.append(" ");
            buf.append(option.getOpt());
            if (!option.hasArg()) continue;
            buf.append("=");
            buf.append(option.getValue());
        }
        return buf.toString();
    }

    public String getOptionValue(Option option) {
        return this.commandLine.getOptionValue(option.getOpt());
    }

    public boolean hasOption(Option option) {
        return this.commandLine.hasOption(option.getOpt());
    }

    public void printUsage(String programName, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(programName, options);
    }

    public boolean isHelpOption() throws ParseException {
        return this.commandLine.hasOption("help");
    }

    public static String convertToFileURL(String path) {
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }
}

