/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    private static TimeZone gmt = TimeZone.getTimeZone("GMT");
    public static final long ONE_MINUTE_TS = 60000L;
    public static final long ONE_HOUR_TS = 3600000L;
    public static final long ONE_DAY_TS = 86400000L;

    private TimeUtil() {
        throw new IllegalStateException("Class TimeUtil is an utility class !");
    }

    public static long getMinuteStart(long ts) {
        return ts / 60000L * 60000L;
    }

    public static long getHourStart(long ts) {
        return ts / 3600000L * 3600000L;
    }

    public static long getDayStart(long ts) {
        return TimeUtil.getDayStartWithTimeZone(gmt, ts);
    }

    public static long getDayStartWithTimeZone(TimeZone timeZone, long ts) {
        Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int date = calendar.get(5);
        calendar.clear();
        calendar.set(year, month, date);
        return calendar.getTimeInMillis();
    }

    public static long getWeekStart(long ts) {
        return TimeUtil.getWeekStartWithTimeZone(gmt, ts);
    }

    public static long getWeekStartWithTimeZone(TimeZone timeZone, long ts) {
        Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
        calendar.setTimeInMillis(TimeUtil.getDayStartWithTimeZone(timeZone, ts));
        calendar.add(7, calendar.getFirstDayOfWeek() - calendar.get(7));
        return calendar.getTimeInMillis();
    }

    public static long getMonthStart(long ts) {
        return TimeUtil.getMonthStartWithTimeZone(gmt, ts);
    }

    public static long getMonthStartWithTimeZone(TimeZone timeZone, long ts) {
        Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.clear();
        calendar.set(year, month, 1);
        return calendar.getTimeInMillis();
    }

    public static long getQuarterStart(long ts) {
        return TimeUtil.getQuarterStartWithTimeZone(gmt, ts);
    }

    public static long getQuarterStartWithTimeZone(TimeZone timeZone, long ts) {
        Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.clear();
        calendar.set(year, month / 3 * 3, 1);
        return calendar.getTimeInMillis();
    }

    public static long getYearStart(long ts) {
        return TimeUtil.getYearStartWithTimeZone(gmt, ts);
    }

    public static long getYearStartWithTimeZone(TimeZone timeZone, long ts) {
        Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(year, 0, 1);
        return calendar.getTimeInMillis();
    }

    public static long getWeekEnd(long ts) {
        return TimeUtil.getWeekEndWithTimeZone(gmt, ts);
    }

    public static long getWeekEndWithTimeZone(TimeZone timeZone, long ts) {
        Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
        calendar.setTimeInMillis(TimeUtil.getWeekStartWithTimeZone(timeZone, ts));
        calendar.add(7, 7);
        return calendar.getTimeInMillis();
    }

    public static long getMonthEnd(long ts) {
        return TimeUtil.getMonthEndWithTimeZone(gmt, ts);
    }

    public static long getMonthEndWithTimeZone(TimeZone timeZone, long ts) {
        Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
        calendar.setTimeInMillis(ts);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 24);
        return calendar.getTimeInMillis();
    }

    public static long getQuarterEnd(long ts) {
        return TimeUtil.getQuarterEndWithTimeZone(gmt, ts);
    }

    public static long getQuarterEndWithTimeZone(TimeZone timeZone, long ts) {
        Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
        calendar.setTimeInMillis(TimeUtil.getQuarterStartWithTimeZone(timeZone, ts));
        calendar.add(2, 3);
        return calendar.getTimeInMillis();
    }

    public static long getYearEnd(long ts) {
        return TimeUtil.getYearEndWithTimeZone(gmt, ts);
    }

    public static long getYearEndWithTimeZone(TimeZone timeZone, long ts) {
        Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
        calendar.setTimeInMillis(TimeUtil.getYearStartWithTimeZone(timeZone, ts));
        calendar.add(1, 1);
        return calendar.getTimeInMillis();
    }
}

