/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.io.IOException;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTScanRequestBuilder;
import org.apache.kylin.gridtable.GridTable;
import org.apache.kylin.gridtable.IGTScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ICuboidGTTableWriter
implements ICuboidWriter {
    private static Logger logger = LoggerFactory.getLogger(ICuboidGTTableWriter.class);

    @Override
    public void write(long cuboidId, GridTable gridTable) throws IOException {
        long startTime = System.currentTimeMillis();
        GTScanRequest req = new GTScanRequestBuilder().setInfo(gridTable.getInfo()).setRanges(null).setDimensions(null).setFilterPushDown(null).createGTScanRequest();
        try (IGTScanner scanner = gridTable.scan(req);){
            for (GTRecord record : scanner) {
                this.write(cuboidId, record);
            }
        }
        logger.info("Cuboid " + cuboidId + " output takes " + (System.currentTimeMillis() - startTime) + "ms");
    }
}

