/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.upgrade.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataVersionRefresher {
    private static final Logger logger = LoggerFactory.getLogger(MetadataVersionRefresher.class);
    private ResourceStore store;
    private String version;

    public MetadataVersionRefresher(ResourceStore resourceStore, String version) {
        this.store = resourceStore;
        this.version = version;
    }

    public void refresh() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        ArrayList<String> all = Lists.newArrayList();
        MetadataVersionRefresher.collectFiles(this.store, "/", all);
        for (String path : all) {
            if (!path.endsWith(".json") || path.startsWith("/dict") || path.startsWith("/table_snapshot")) continue;
            logger.info("Updating metadata version of path {}", (Object)path);
            ObjectNode objectNode = (ObjectNode)mapper.readTree(this.store.getResource(path).content());
            objectNode.put("version", this.version);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mapper.writeValue(baos, (Object)objectNode);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            this.store.putResource(path, bais, System.currentTimeMillis());
        }
    }

    public static void collectFiles(ResourceStore src, String path, List<String> ret) throws IOException {
        NavigableSet<String> children = src.listResources(path);
        if (children == null) {
            ret.add(path);
        } else {
            for (String child : children) {
                MetadataVersionRefresher.collectFiles(src, child, ret);
            }
        }
    }
}

