/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.mr.DFSFileTable;
import org.apache.kylin.engine.mr.DFSFileTableReader;
import org.apache.kylin.engine.mr.SortedColumnDFSFileReader;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.source.IReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedColumnDFSFile
implements IReadableTable {
    private static final Logger logger = LoggerFactory.getLogger(SortedColumnDFSFile.class);
    private String dfsPath;
    private DFSFileTable dfsFileTable;
    private DataType dataType;

    public SortedColumnDFSFile(String path, DataType dataType) {
        this.dfsPath = path;
        this.dfsFileTable = new DFSFileTable(path, -1);
        this.dataType = dataType;
    }

    @Override
    public IReadableTable.TableReader getReader() throws IOException {
        Comparator<String> comparator = this.getComparatorByType(this.dataType);
        ArrayList<IReadableTable.TableReader> readers = new ArrayList<IReadableTable.TableReader>();
        String filePath = HadoopUtil.fixWindowsPath(this.dfsPath);
        FileSystem fs = HadoopUtil.getFileSystem(filePath);
        ArrayList<FileStatus> allFiles = new ArrayList<FileStatus>();
        FileStatus status = fs.getFileStatus(new Path(filePath));
        if (status.isFile()) {
            allFiles.add(status);
        } else {
            FileStatus[] listStatus;
            for (FileStatus f : listStatus = fs.listStatus(new Path(filePath))) {
                if (!f.isFile()) continue;
                allFiles.add(f);
            }
        }
        for (FileStatus f : allFiles) {
            DFSFileTableReader reader = new DFSFileTableReader(f.getPath().toString(), -1);
            readers.add(reader);
        }
        return new SortedColumnDFSFileReader(readers, comparator);
    }

    @Override
    public IReadableTable.TableSignature getSignature() throws IOException {
        return this.dfsFileTable.getSignature();
    }

    @Override
    public boolean exists() throws IOException {
        return this.dfsFileTable.exists();
    }

    private Comparator<String> getComparatorByType(DataType type) {
        return null;
    }

    public String toString() {
        return this.dfsPath;
    }
}

