/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.engine.spark.builder.CubeBuilderHelper$;
import org.apache.kylin.engine.spark.builder.CubeDictionaryBuilder$;
import org.apache.kylin.engine.spark.builder.DictHelper$;
import org.apache.kylin.engine.spark.builder.DictionaryBuilderHelper;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.dict.NGlobalDictBuilderAssist$;
import org.apache.spark.dict.NGlobalDictionary;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.utils.SparkVersionUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u000b\u0017\u0001\rB\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005m!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!b\u0001\n\u0003Q\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011=\u0003!Q1A\u0005\u0002AC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006;\u0002!\tA\u0018\u0005\bK\u0002\u0011\r\u0011\"\u0001g\u0011\u0019q\u0007\u0001)A\u0005O\")1\u000f\u0001C\u0001i\"A\u0011\u0011\u000b\u0001\u0005\u0002Y\t\u0019\u0006\u0003\u0005\u0002f\u0001!\tAFA4\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f;q!!$\u0017\u0011\u0003\tyI\u0002\u0004\u0016-!\u0005\u0011\u0011\u0013\u0005\u0007;F!\t!a%\t\u000f\u0005U\u0015\u0003\"\u0001\u0002\u0018\"I\u0011\u0011U\t\u0002\u0002\u0013%\u00111\u0015\u0002\u0016\u0007V\u0014W\rR5di&|g.\u0019:z\u0005VLG\u000eZ3s\u0015\t9\u0002$A\u0004ck&dG-\u001a:\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003\u0019)gnZ5oK*\u0011QDH\u0001\u0006Wfd\u0017N\u001c\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!#&\r\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-zS\"\u0001\u0017\u000b\u00055r\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005eq\u0012B\u0001\u0019-\u0005\u001daunZ4j]\u001e\u0004\"!\n\u001a\n\u0005M2#\u0001D*fe&\fG.\u001b>bE2,\u0017a\u00023bi\u0006\u001cX\r^\u000b\u0002mA\u0019qG\u000f\u001f\u000e\u0003aR!!\u000f\u0018\u0002\u0007M\fH.\u0003\u0002<q\t9A)\u0019;bg\u0016$\bCA\u001c>\u0013\tq\u0004HA\u0002S_^\f\u0001\u0002Z1uCN,G\u000fI\u0001\u0004g\u0016<W#\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015C\u0012\u0001C7fi\u0006$\u0017\r^1\n\u0005\u001d#%aC*fO6,g\u000e^%oM>\fAa]3hA\u0005\u00111o]\u000b\u0002\u0017B\u0011q\u0007T\u0005\u0003\u001bb\u0012Ab\u00159be.\u001cVm]:j_:\f1a]:!\u0003%\u0019w\u000e\u001c*fMN+G/F\u0001R!\r\u0011v+W\u0007\u0002'*\u0011A+V\u0001\u0005kRLGNC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&aA*fiB\u00111IW\u0005\u00037\u0012\u0013!bQ8mk6tG)Z:d\u0003)\u0019w\u000e\u001c*fMN+G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b}\u000b'm\u00193\u0011\u0005\u0001\u0004Q\"\u0001\f\t\u000bQJ\u0001\u0019\u0001\u001c\t\u000b\u0001K\u0001\u0019\u0001\"\t\u000b%K\u0001\u0019A&\t\u000b=K\u0001\u0019A)\u0002\t1|7m[\u000b\u0002OB\u0011\u0001\u000e\\\u0007\u0002S*\u0011QM\u001b\u0006\u0003Wr\taaY8n[>t\u0017BA7j\u0005=!\u0015n\u001d;sS\n,H/\u001a3M_\u000e\\\u0017!\u00027pG.\u0004\u0003FA\u0006q!\t)\u0013/\u0003\u0002sM\tIAO]1og&,g\u000e^\u0001\rEVLG\u000e\u001a#jGR\u001cV\r\u001e\u000b\u0002kB\u0011QE^\u0005\u0003o\u001a\u0012A!\u00168ji\"\"A\"_A\u0003!\r)#\u0010`\u0005\u0003w\u001a\u0012a\u0001\u001e5s_^\u001c\bcA?\u0002\u00025\taP\u0003\u0002\u0000+\u0006\u0011\u0011n\\\u0005\u0004\u0003\u0007q(aC%P\u000bb\u001cW\r\u001d;j_:\ftAHA\u0004\u0003;\ty\u0005\u0005\u0003\u0002\n\u0005]a\u0002BA\u0006\u0003'\u00012!!\u0004'\u001b\t\tyAC\u0002\u0002\u0012\t\na\u0001\u0010:p_Rt\u0014bAA\u000bM\u00051\u0001K]3eK\u001aLA!!\u0007\u0002\u001c\t11\u000b\u001e:j]\u001eT1!!\u0006'c%\u0019\u0013qDA\u0014\u0003\u000b\nI#\u0006\u0003\u0002\"\u0005\rRCAA\u0004\t\u001d\t)C\tb\u0001\u0003_\u0011\u0011\u0001V\u0005\u0005\u0003S\tY#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003[1\u0013A\u0002;ie><8/\u0005\u0003\u00022\u0005]\u0002cA\u0013\u00024%\u0019\u0011Q\u0007\u0014\u0003\u000f9{G\u000f[5oOB!\u0011\u0011HA \u001d\r)\u00131H\u0005\u0004\u0003{1\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\n\u0019EA\u0005UQJ|w/\u00192mK*\u0019\u0011Q\b\u00142\u0013\r\n9%!\u0013\u0002L\u00055bbA\u0013\u0002J%\u0019\u0011Q\u0006\u00142\u000b\t*c%!\u0014\u0003\u000bM\u001c\u0017\r\\12\u0005\u0019b\u0018!C:bM\u0016\u0014U/\u001b7e)\r)\u0018Q\u000b\u0005\u0007\u0003/j\u0001\u0019A-\u0002\u0007I,g\r\u000b\u0003\u000es\u0006m\u0013g\u0002\u0010\u0002\b\u0005u\u00131M\u0019\nG\u0005}\u0011qEA0\u0003S\t\u0014bIA$\u0003\u0013\n\t'!\f2\u000b\t*c%!\u00142\u0005\u0019b\u0018!\u00022vS2$GcB;\u0002j\u0005-\u0014Q\u000f\u0005\u0007\u0003/r\u0001\u0019A-\t\u000f\u00055d\u00021\u0001\u0002p\u0005\u0019\"-^2lKR\u0004\u0016M\u001d;ji&|gnU5{KB\u0019Q%!\u001d\n\u0007\u0005MdEA\u0002J]RDa!a\u001e\u000f\u0001\u00041\u0014!D1gi\u0016\u0014H)[:uS:\u001cG\u000f\u000b\u0003\u000fs\u0006m\u0014g\u0002\u0010\u0002\b\u0005u\u00141Q\u0019\nG\u0005}\u0011qEA@\u0003S\t\u0014bIA$\u0003\u0013\n\t)!\f2\u000b\t*c%!\u00142\u0005\u0019b\u0018aC4fi2{7m\u001b)bi\"$B!a\u0002\u0002\n\"9\u00111R\bA\u0002\u0005\u001d\u0011\u0001\u00039bi\"t\u0015-\\3\u0002+\r+(-\u001a#jGRLwN\\1ss\n+\u0018\u000e\u001c3feB\u0011\u0001-E\n\u0004#\u0011\nDCAAH\u0003\u001d9(/\u00199D_2$B!!'\u0002 B\u0019q'a'\n\u0007\u0005u\u0005H\u0001\u0004D_2,XN\u001c\u0005\u0007\u0003/\u001a\u0002\u0019A-\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003K\u0003B!a*\u0002.6\u0011\u0011\u0011\u0016\u0006\u0004\u0003W+\u0016\u0001\u00027b]\u001eLA!a,\u0002*\n1qJ\u00196fGR\u0004")
public class CubeDictionaryBuilder
implements Logging,
scala.Serializable {
    private final Dataset<Row> dataset;
    private final SegmentInfo seg;
    private final SparkSession ss;
    private final Set<ColumnDesc> colRefSet;
    private final transient DistributedLock lock;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Column wrapCol(ColumnDesc columnDesc) {
        return CubeDictionaryBuilder$.MODULE$.wrapCol(columnDesc);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> dataset() {
        return this.dataset;
    }

    public SegmentInfo seg() {
        return this.seg;
    }

    public SparkSession ss() {
        return this.ss;
    }

    public Set<ColumnDesc> colRefSet() {
        return this.colRefSet;
    }

    public DistributedLock lock() {
        return this.lock;
    }

    public void buildDictSet() throws IOException {
        if (SparkVersionUtils$.MODULE$.isLessThanSparkVersion("2.4", true)) {
            Predef$.MODULE$.assert(!new StringOps(Predef$.MODULE$.augmentString(this.ss().conf().get("spark.sql.adaptive.enabled", "false"))).toBoolean(), (Function0 & Serializable & scala.Serializable)() -> "Parameter 'spark.sql.adaptive.enabled' must be false when building global dictionary.");
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Start building global dictionaries V2 for seg ").append(this.seg()).toString());
        String m = new StringBuilder(47).append("Build global dictionaries V2 for seg ").append(this.seg()).append(" succeeded").toString();
        CubeBuilderHelper$.MODULE$.time(m, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.colRefSet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)col -> {
            this.safeBuild(col);
            return BoxedUnit.UNIT;
        }));
    }

    public void safeBuild(ColumnDesc ref) throws IOException {
        String sourceColumn = ref.identity();
        this.lock().lock(this.getLockPath(sourceColumn), Long.MAX_VALUE);
        try {
            if (this.lock().lock(this.getLockPath(sourceColumn))) {
                Dataset dictColDistinct = this.dataset().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{CubeDictionaryBuilder$.MODULE$.wrapCol(ref)})).distinct();
                this.ss().sparkContext().setJobDescription(new StringBuilder(22).append("Calculate bucket size ").append(ref.identity()).toString());
                int bucketPartitionSize = DictionaryBuilderHelper.calculateBucketSize(this.seg(), ref, (Dataset<Row>)dictColDistinct);
                String m = new StringBuilder(50).append("Build global dictionaries V2 for column ").append(sourceColumn).append(" succeeded").toString();
                CubeBuilderHelper$.MODULE$.time(m, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.build(ref, bucketPartitionSize, (Dataset<Row>)dictColDistinct));
            }
        }
        finally {
            this.lock().unlock(this.getLockPath(sourceColumn));
        }
    }

    public void build(ColumnDesc ref, int bucketPartitionSize, Dataset<Row> afterDistinct) throws IOException {
        String columnName = ref.identity();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Start building global dictionaries V2 for column ").append(columnName).append(".").toString());
        NGlobalDictionary globalDict = new NGlobalDictionary(this.seg().project(), ref.tableAliasName(), ref.columnName(), this.seg().kylinconf().getHdfsWorkingDirectory());
        globalDict.prepareWrite();
        Broadcast broadcastDict = this.ss().sparkContext().broadcast((Object)globalDict, ClassTag$.MODULE$.apply(NGlobalDictionary.class));
        this.ss().sparkContext().setJobDescription(new StringBuilder(11).append("Build dict ").append(columnName).toString());
        Column dictCol = functions$.MODULE$.col(((StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])afterDistinct.schema().fields())).head()).name());
        afterDistinct.filter(dictCol.isNotNull()).repartition(bucketPartitionSize, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dictCol})).foreachPartition((Function1 & Serializable & scala.Serializable)iter -> {
            DictHelper$.MODULE$.genDict(columnName, (Broadcast<NGlobalDictionary>)broadcastDict, (Iterator<Row>)iter);
            return BoxedUnit.UNIT;
        });
        globalDict.writeMetaDict(bucketPartitionSize, this.seg().kylinconf().getGlobalDictV2MaxVersions(), this.seg().kylinconf().getGlobalDictV2VersionTTL());
        NGlobalDictBuilderAssist$.MODULE$.checkGlobalDict(ref, this.seg(), bucketPartitionSize, this.ss());
    }

    private String getLockPath(String pathName) {
        return new StringBuilder(24).append("/").append(this.seg().project()).append("/dict/global_dict").append("/").append(pathName).append("/lock").toString();
    }

    public CubeDictionaryBuilder(Dataset<Row> dataset, SegmentInfo seg, SparkSession ss, Set<ColumnDesc> colRefSet) {
        this.dataset = dataset;
        this.seg = seg;
        this.ss = ss;
        this.colRefSet = colRefSet;
        Logging.$init$((Logging)this);
        this.lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentThread();
    }
}

