/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkCleanupHdfsStorageStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkCleanupHdfsStorageStep.class);
    private FileSystem fs = HadoopUtil.getWorkingFileSystem();

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeManager cubeManager = CubeManager.getInstance(context.getConfig());
        CubeInstance cube = cubeManager.getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        List segments = cube.getSegments().stream().map(segment -> segment.getName() + "_" + segment.getStorageLocationIdentifier()).collect(Collectors.toList());
        String project = cube.getProject();
        Path cubePath = new Path(context.getConfig().getHdfsWorkingDirectory(project) + "/parquet/" + cube.getName());
        try {
            if (this.fs.exists(cubePath)) {
                FileStatus[] segmentStatus = this.fs.listStatus(cubePath);
                if (segmentStatus != null) {
                    for (FileStatus status : segmentStatus) {
                        String segment2 = status.getPath().getName();
                        if (segments.contains(segment2)) continue;
                        logger.info("Deleting old segment storage {}", (Object)status.getPath());
                        this.fs.delete(status.getPath(), true);
                    }
                }
            } else {
                logger.warn("Cube path doesn't exist! The path is " + cubePath);
            }
            return new ExecuteResult();
        }
        catch (IOException e) {
            logger.error("Failed to clean old segment storage", e);
            return ExecuteResult.createError(e);
        }
    }

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        AbstractExecutable parent = this.getParentExecutable();
        return ((DefaultChainedExecutable)parent).getMetadataDumpList(config);
    }
}

