/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.metadata.model.DatabaseDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.query.schema.OLAPSchema;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLAPSchemaFactory
implements SchemaFactory {
    public static final Logger logger = LoggerFactory.getLogger(OLAPSchemaFactory.class);
    private static final String SCHEMA_PROJECT = "project";
    private static Map<String, File> cachedJsons = Maps.newConcurrentMap();

    public Schema create(SchemaPlus parentSchema, String schemaName, Map<String, Object> operand) {
        String project = (String)operand.get(SCHEMA_PROJECT);
        OLAPSchema newSchema = new OLAPSchema(project, schemaName, OLAPSchemaFactory.exposeMore(project));
        return newSchema;
    }

    public static boolean exposeMore(String project) {
        return ProjectManager.getInstance(KylinConfig.getInstanceFromEnv()).getProject(project).getConfig().isPushDownEnabled();
    }

    public static File createTempOLAPJson(String project, KylinConfig config) {
        ProjectManager projectManager = ProjectManager.getInstance(config);
        KylinConfig projConfig = projectManager.getProject(project).getConfig();
        Collection<TableDesc> tables = projectManager.listExposedTables(project, OLAPSchemaFactory.exposeMore(project));
        HashMap<String, Integer> schemaCounts = DatabaseDesc.extractDatabaseOccurenceCounts(tables);
        String majoritySchemaName = "";
        int majoritySchemaCount = 0;
        for (Map.Entry<String, Integer> e : schemaCounts.entrySet()) {
            if (e.getKey().equalsIgnoreCase("default")) {
                majoritySchemaCount = Integer.MAX_VALUE;
                majoritySchemaName = e.getKey();
            }
            if (e.getValue() < majoritySchemaCount) continue;
            majoritySchemaCount = e.getValue();
            majoritySchemaName = e.getKey();
        }
        try {
            StringBuilder out = new StringBuilder();
            out.append("{\n");
            out.append("    \"version\": \"1.0\",\n");
            out.append("    \"defaultSchema\": \"" + majoritySchemaName + "\",\n");
            out.append("    \"schemas\": [\n");
            int counter = 0;
            String schemaFactory = projConfig.getSchemaFactory();
            for (String schemaName : schemaCounts.keySet()) {
                out.append("        {\n");
                out.append("            \"type\": \"custom\",\n");
                out.append("            \"name\": \"" + schemaName + "\",\n");
                out.append("            \"factory\": \"" + schemaFactory + "\",\n");
                out.append("            \"operand\": {\n");
                out.append("                \"project\": \"" + project + "\"\n");
                out.append("            },\n");
                OLAPSchemaFactory.createOLAPSchemaFunctions(projConfig.getUDFs(), out);
                out.append("        }\n");
                if (++counter == schemaCounts.size()) continue;
                out.append(",\n");
            }
            out.append("    ]\n");
            out.append("}\n");
            String jsonContent = out.toString();
            File file = cachedJsons.get(jsonContent);
            if (file == null) {
                file = Files.createTempFile("olap_model_", ".json", new FileAttribute[0]).toFile();
                file.deleteOnExit();
                FileUtils.writeStringToFile(file, jsonContent);
                logger.debug("Adding new schema file {} to cache", (Object)file.getName());
                logger.debug("Schema json: " + jsonContent);
                cachedJsons.put(jsonContent, file);
            }
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createOLAPSchemaFunctions(Map<String, String> definedUdfs, StringBuilder out) throws IOException {
        HashMap udfs = Maps.newHashMap();
        if (definedUdfs != null) {
            udfs.putAll(definedUdfs);
        }
        for (Map.Entry<String, Class<?>> entry : MeasureTypeFactory.getUDAFs().entrySet()) {
            udfs.put(entry.getKey(), entry.getValue().getName());
        }
        int index = 0;
        out.append("            \"functions\": [\n");
        for (Map.Entry udf : udfs.entrySet()) {
            String udfName = ((String)udf.getKey()).trim().toUpperCase(Locale.ROOT);
            String udfClassName = ((String)udf.getValue()).trim();
            out.append("               {\n");
            out.append("                   name: '" + udfName + "',\n");
            out.append("                   className: '" + udfClassName + "'\n");
            if (index < udfs.size() - 1) {
                out.append("               },\n");
            } else {
                out.append("               }\n");
            }
            ++index;
        }
        out.append("            ]\n");
    }
}

