/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.kylin.metadata.filter.CompareTupleFilter;

public class RexUtil {
    private RexUtil() {
        throw new IllegalStateException("Class RexUtil is an utility class !");
    }

    public static CompareTupleFilter.CompareResultType getCompareResultType(RexCall whenCall) {
        List operands = whenCall.getOperands();
        if (SqlKind.EQUALS == whenCall.getKind() && operands != null && operands.size() == 2) {
            if (((RexNode)operands.get(0)).equals(operands.get(1))) {
                return CompareTupleFilter.CompareResultType.AlwaysTrue;
            }
            if (RexUtil.isConstant((RexNode)operands.get(0)) && RexUtil.isConstant((RexNode)operands.get(1))) {
                return CompareTupleFilter.CompareResultType.AlwaysFalse;
            }
        }
        return CompareTupleFilter.CompareResultType.Unknown;
    }

    public static boolean isConstant(RexNode rexNode) {
        if (rexNode instanceof RexLiteral) {
            return true;
        }
        return rexNode instanceof RexCall && SqlKind.CAST.equals((Object)rexNode.getKind()) && ((RexCall)rexNode).getOperands().get(0) instanceof RexLiteral;
    }
}

