/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.exception.NotFoundException;
import org.apache.kylin.rest.request.ProjectRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.ValidateUtil;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/projects"})
public class ProjectController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(ProjectController.class);
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="cubeMgmtService")
    private CubeService cubeService;
    @Autowired
    @Qualifier(value="validateUtil")
    private ValidateUtil validateUtil;
    @Autowired
    private AclEvaluate aclEvaluate;

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ProjectInstance> getProjects(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="offset", required=false) Integer offset) {
        return this.projectService.listProjects(limit, offset);
    }

    @RequestMapping(value={"/mdx"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse getProjectsForMdx(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="offset", required=false) Integer offset) {
        List<ProjectInstance> projects = this.projectService.listProjects(limit, offset);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("projects", projects);
        data.put("size", projects.size());
        return new EnvelopeResponse("000", data, "");
    }

    @RequestMapping(value={"/readable"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ProjectInstance> getReadableProjects(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="offset", required=false) Integer offset) {
        int projectOffset;
        ArrayList<ProjectInstance> readableProjects = new ArrayList<ProjectInstance>();
        List<ProjectInstance> projectInstances = this.projectService.listAllProjects(null, null);
        for (ProjectInstance projectInstance : projectInstances) {
            boolean hasProjectPermission;
            if (projectInstance == null || !(hasProjectPermission = this.aclEvaluate.hasProjectReadPermission(projectInstance))) continue;
            readableProjects.add(projectInstance);
        }
        int projectLimit = null == limit ? Integer.MAX_VALUE : limit;
        int n = projectOffset = null == offset ? 0 : offset;
        if (readableProjects.size() <= projectOffset) {
            return Collections.emptyList();
        }
        if (readableProjects.size() - projectOffset < projectLimit) {
            return readableProjects.subList(projectOffset, readableProjects.size());
        }
        return readableProjects.subList(projectOffset, projectOffset + projectLimit);
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ProjectInstance saveProject(@RequestBody ProjectRequest projectRequest) {
        ProjectInstance projectDesc = this.deserializeProjectDesc(projectRequest);
        if (StringUtils.isEmpty(projectDesc.getName())) {
            throw new InternalErrorException("A project name must be given to create a project");
        }
        if (!ValidateUtil.isAlphanumericUnderscore(projectDesc.getName())) {
            throw new BadRequestException(String.format(Locale.ROOT, "Invalid Project name %s, only letters, numbers and underscore supported.", projectDesc.getName()));
        }
        ProjectInstance createdProj = null;
        try {
            createdProj = this.projectService.createProject(projectDesc);
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
        return createdProj;
    }

    @RequestMapping(value={""}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public ProjectInstance updateProject(@RequestBody ProjectRequest projectRequest) {
        String formerProjectName = projectRequest.getFormerProjectName();
        if (StringUtils.isEmpty(formerProjectName)) {
            throw new InternalErrorException("A project name must be given to update a project");
        }
        ProjectInstance projectDesc = this.deserializeProjectDesc(projectRequest);
        ProjectInstance updatedProj = null;
        try {
            ProjectInstance currentProject = this.projectService.getProjectManager().getProject(formerProjectName);
            if (currentProject == null) {
                throw new NotFoundException("The project named " + formerProjectName + " does not exists");
            }
            if (!projectDesc.getName().equals(currentProject.getName())) {
                throw new IllegalStateException("Rename project is not supported yet, from " + formerProjectName + " to " + projectDesc.getName());
            }
            updatedProj = this.projectService.updateProject(projectDesc, currentProject);
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request.", e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
        return updatedProj;
    }

    private ProjectInstance deserializeProjectDesc(ProjectRequest projectRequest) {
        ProjectInstance projectDesc = null;
        try {
            logger.debug("Saving project " + projectRequest.getProjectDescData());
            projectDesc = JsonUtil.readValue(projectRequest.getProjectDescData(), ProjectInstance.class);
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request.", e);
            throw new InternalErrorException("Failed to deal with the request:" + e.getMessage(), e);
        }
        return projectDesc;
    }

    @RequestMapping(value={"/{projectName}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public void deleteProject(@PathVariable String projectName) {
        try {
            ProjectInstance project = this.projectService.getProjectManager().getProject(projectName);
            if (project != null) {
                this.projectService.deleteProject(projectName, project);
            } else {
                logger.info("Project {} not exists", (Object)projectName);
            }
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException("Failed to delete project.  Caused by: " + e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/{projectName}/owner"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public ProjectInstance updateProjectOwner(@PathVariable String projectName, @RequestBody String owner) {
        ProjectInstance currentProject = null;
        String oldOwner = null;
        boolean updateOwnerSuccess = false;
        boolean updateAccessSuccess = false;
        try {
            this.validateUtil.checkIdentifiersExists(owner, true);
            currentProject = this.projectService.getProjectManager().getProject(projectName);
            if (currentProject == null) {
                throw new NotFoundException("The project named " + projectName + " does not exists");
            }
            oldOwner = currentProject.getOwner();
            ProjectInstance updatedProj = this.projectService.updateProjectOwner(currentProject, owner);
            updateOwnerSuccess = true;
            RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", currentProject.getUuid());
            Sid sid = this.accessService.getSid(owner, true);
            this.accessService.grant(ae, AclPermission.ADMINISTRATION, sid);
            return updatedProj;
        }
        catch (AccessDeniedException accessDeniedException) {
            try {
                throw new ForbiddenException("You don't have right to update this project's owner.");
                catch (Exception e) {
                    logger.error("Failed to deal with the request.", e);
                    throw new InternalErrorException(e.getLocalizedMessage(), e);
                }
            }
            catch (Throwable throwable) {
                if (updateAccessSuccess) throw throwable;
                if (currentProject == null) throw throwable;
                if (!updateOwnerSuccess) throw throwable;
                try {
                    this.projectService.updateProjectOwner(currentProject, oldOwner);
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Failed to roll back the request.", e);
                }
                throw throwable;
            }
        }
    }

    public void setProjectService(ProjectService projectService) {
        this.projectService = projectService;
    }

    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    public void setCubeService(CubeService cubeService) {
        this.cubeService = cubeService;
    }

    public void setValidateUtil(ValidateUtil validateUtil) {
        this.validateUtil = validateUtil;
    }
}

