/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.apache.kylin.metadata.acl.UserGroup;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.UserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class KylinUserGroupService
extends UserGroupService {
    public static final Logger logger = LoggerFactory.getLogger(KylinUserGroupService.class);
    private ResourceStore store = ResourceStore.getStore(KylinConfig.getInstanceFromEnv());
    private static final String PATH = "/user_group/";
    private static final Serializer<UserGroup> USER_GROUP_SERIALIZER = new JsonSerializer<UserGroup>(UserGroup.class);
    @Autowired
    @Qualifier(value="userService")
    private UserService userService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;

    @Override
    public boolean exists(String name) throws IOException {
        return this.getUserGroup().getAllGroups().contains(name);
    }

    @PostConstruct
    public void init() throws IOException, InterruptedException {
        for (int retry = 100; retry > 0; --retry) {
            UserGroup userGroup = this.getUserGroup();
            if (!userGroup.exists("ALL_USERS")) {
                userGroup.add("ALL_USERS");
            }
            if (!userGroup.exists("ROLE_ADMIN")) {
                userGroup.add("ROLE_ADMIN");
            }
            if (!userGroup.exists("ROLE_MODELER")) {
                userGroup.add("ROLE_MODELER");
            }
            if (!userGroup.exists("ROLE_ANALYST")) {
                userGroup.add("ROLE_ANALYST");
            }
            try {
                this.store.checkAndPutResource(PATH, userGroup, USER_GROUP_SERIALIZER);
                return;
            }
            catch (WriteConflictException e) {
                logger.info("Find WriteConflictException, sleep 100 ms.", e);
                Thread.sleep(100L);
                continue;
            }
        }
        logger.error("Failed to update user group's metadata.");
    }

    private UserGroup getUserGroup() throws IOException {
        UserGroup userGroup = this.store.getResource(PATH, USER_GROUP_SERIALIZER);
        if (userGroup == null) {
            userGroup = new UserGroup();
        }
        return userGroup;
    }

    @Override
    protected List<String> getAllUserGroups() throws IOException {
        return this.getUserGroup().getAllGroups();
    }

    @Override
    public Map<String, List<String>> getGroupMembersMap() throws IOException {
        HashMap<String, List<String>> result = Maps.newHashMap();
        List<ManagedUser> users = this.userService.listUsers();
        for (ManagedUser user : users) {
            for (SimpleGrantedAuthority authority : user.getAuthorities()) {
                String role = authority.getAuthority();
                List usersInGroup = (List)result.get(role);
                if (usersInGroup == null) {
                    result.put(role, Lists.newArrayList(user.getUsername()));
                    continue;
                }
                usersInGroup.add(user.getUsername());
            }
        }
        return result;
    }

    @Override
    public List<ManagedUser> getGroupMembersByName(String name) throws IOException {
        List<ManagedUser> users = this.userService.listUsers();
        Iterator<ManagedUser> it = users.iterator();
        while (it.hasNext()) {
            ManagedUser user = it.next();
            if (user.getAuthorities().contains(new SimpleGrantedAuthority(name))) continue;
            it.remove();
        }
        return users;
    }

    @Override
    public void addGroup(String name) throws IOException {
        this.aclEvaluate.checkIsGlobalAdmin();
        UserGroup userGroup = this.getUserGroup();
        this.store.checkAndPutResource(PATH, userGroup.add(name), USER_GROUP_SERIALIZER);
    }

    @Override
    public void deleteGroup(String name) throws IOException {
        this.aclEvaluate.checkIsGlobalAdmin();
        List<ManagedUser> managedUsers = this.userService.listUsers();
        for (ManagedUser managedUser : managedUsers) {
            if (!managedUser.getAuthorities().contains(new SimpleGrantedAuthority(name))) continue;
            managedUser.removeAuthorities(name);
            this.userService.updateUser(managedUser);
        }
        this.accessService.revokeProjectPermission(name, "group");
        this.store.checkAndPutResource(PATH, this.getUserGroup().delete(name), USER_GROUP_SERIALIZER);
    }

    @Override
    public void modifyGroupUsers(String groupName, List<String> users) throws IOException {
        ManagedUser managedUser;
        this.aclEvaluate.checkIsGlobalAdmin();
        ArrayList<String> groupUsers = new ArrayList<String>();
        for (ManagedUser user : this.getGroupMembersByName(groupName)) {
            groupUsers.add(user.getUsername());
        }
        ArrayList<String> moveInUsers = Lists.newArrayList(users);
        ArrayList<String> moveOutUsers = Lists.newArrayList(groupUsers);
        moveInUsers.removeAll(groupUsers);
        moveOutUsers.removeAll(users);
        for (String in : moveInUsers) {
            managedUser = (ManagedUser)this.userService.loadUserByUsername(in);
            managedUser.addAuthorities(groupName);
            this.userService.updateUser(managedUser);
        }
        for (String out : moveOutUsers) {
            managedUser = (ManagedUser)this.userService.loadUserByUsername(out);
            managedUser.removeAuthorities(groupName);
            this.userService.updateUser(managedUser);
        }
    }
}

