/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hybrid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationProvider;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridManager
implements IRealizationProvider {
    private static final Logger logger = LoggerFactory.getLogger(HybridManager.class);
    public static final Serializer<HybridInstance> HYBRID_SERIALIZER = new JsonSerializer<HybridInstance>(HybridInstance.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<HybridInstance> hybridMap;
    private CachedCrudAssist<HybridInstance> crud;
    private AutoReadWriteLock lock = new AutoReadWriteLock();

    public static HybridManager getInstance(KylinConfig config) {
        return config.getManager(HybridManager.class);
    }

    static HybridManager newInstance(KylinConfig config) throws IOException {
        return new HybridManager(config);
    }

    private HybridManager(KylinConfig cfg) throws IOException {
        logger.info("Initializing HybridManager with config " + cfg);
        this.config = cfg;
        this.hybridMap = new CaseInsensitiveStringCache(this.config, "hybrid");
        this.crud = new CachedCrudAssist<HybridInstance>(this.getStore(), "/hybrid", HybridInstance.class, this.hybridMap){

            @Override
            protected HybridInstance initEntityAfterReload(HybridInstance hybridInstance, String resourceName) {
                hybridInstance.setConfig(HybridManager.this.config);
                return hybridInstance;
            }
        };
        this.crud.reloadAll();
        Broadcaster.getInstance(this.config).registerListener(new HybridSyncListener(), "hybrid", "cube");
    }

    public List<HybridInstance> getHybridInstancesByChild(RealizationType type, String realizationName) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            ArrayList<HybridInstance> result = Lists.newArrayList();
            for (HybridInstance hybridInstance : this.hybridMap.values()) {
                for (RealizationEntry realizationEntry : hybridInstance.getRealizationEntries()) {
                    if (realizationEntry.getType() != type || !realizationEntry.getRealization().equalsIgnoreCase(realizationName)) continue;
                    result.add(hybridInstance);
                }
            }
            ArrayList<HybridInstance> arrayList = result;
            return arrayList;
        }
    }

    @Override
    public RealizationType getRealizationType() {
        return RealizationType.HYBRID;
    }

    @Override
    public IRealization getRealization(String name) {
        return this.getHybridInstance(name);
    }

    public Collection<HybridInstance> listHybridInstances() {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            Collection<HybridInstance> collection = this.hybridMap.values();
            return collection;
        }
    }

    public HybridInstance getHybridInstance(String name) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            HybridInstance hybridInstance = (HybridInstance)this.hybridMap.get(name);
            return hybridInstance;
        }
    }

    public HybridInstance reloadHybridInstance(String name) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            HybridInstance hybridInstance = this.crud.reload(name);
            return hybridInstance;
        }
    }

    public void reloadAllHybridInstance() throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            this.crud.reloadAll();
        }
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    private class HybridSyncListener
    extends Broadcaster.Listener {
        private HybridSyncListener() {
        }

        @Override
        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
            try (AutoReadWriteLock.AutoLock l = HybridManager.this.lock.lockForWrite();){
                for (IRealization real : ProjectManager.getInstance(HybridManager.this.config).listAllRealizations(project)) {
                    if (!(real instanceof HybridInstance)) continue;
                    HybridManager.this.crud.reloadQuietly(real.getName());
                }
            }
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            if ("hybrid".equals(entity)) {
                String hybridName = cacheKey;
                try (AutoReadWriteLock.AutoLock l = HybridManager.this.lock.lockForWrite();){
                    if (event == Broadcaster.Event.DROP) {
                        HybridManager.this.hybridMap.removeLocal(hybridName);
                    } else {
                        HybridManager.this.crud.reloadQuietly(hybridName);
                    }
                }
                for (ProjectInstance prj : ProjectManager.getInstance(HybridManager.this.config).findProjects(RealizationType.HYBRID, hybridName)) {
                    broadcaster.notifyProjectSchemaUpdate(prj.getName());
                }
            } else if ("cube".equals(entity)) {
                String cubeName = cacheKey;
                try (AutoReadWriteLock.AutoLock l = HybridManager.this.lock.lockForWrite();){
                    for (HybridInstance hybrid : HybridManager.this.getHybridInstancesByChild(RealizationType.CUBE, cubeName)) {
                        HybridManager.this.crud.reloadQuietly(hybrid.getName());
                    }
                }
            }
        }
    }
}

