/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.translate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class FuzzyValueCombination {
    private static final Set SINGLE_NULL_SET = Sets.newHashSet();

    public static <E> List<Map<TblColRef, E>> calculate(Map<TblColRef, Set<E>> fuzzyValues, long cap) {
        Dim[] dims = FuzzyValueCombination.toDims(fuzzyValues);
        if (FuzzyValueCombination.exceedCap(dims, cap)) {
            return Lists.newArrayList();
        }
        return FuzzyValueCombination.combination(dims);
    }

    private static <E> List<Map<TblColRef, E>> combination(Dim[] dims) {
        ArrayList result = Lists.newArrayList();
        int emptyDims = 0;
        for (Dim dim : dims) {
            if (!dim.values.isEmpty()) continue;
            dim.values = SINGLE_NULL_SET;
            ++emptyDims;
        }
        if (emptyDims == dims.length) {
            return result;
        }
        HashMap r = Maps.newHashMap();
        Iterator[] iters = new Iterator[dims.length];
        int level = 0;
        while (true) {
            Iterator it;
            Dim dim;
            dim = dims[level];
            if (iters[level] == null) {
                iters[level] = dim.values.iterator();
            }
            if (!(it = iters[level]).hasNext()) {
                if (level == 0) break;
                r.remove(dim.col);
                iters[level] = null;
                --level;
                continue;
            }
            r.put(dim.col, it.next());
            if (level == dims.length - 1) {
                result.add(new HashMap(r));
                continue;
            }
            ++level;
        }
        return result;
    }

    private static <E> Dim[] toDims(Map<TblColRef, Set<E>> fuzzyValues) {
        Dim[] dims = new Dim[fuzzyValues.size()];
        int i = 0;
        for (Map.Entry<TblColRef, Set<E>> entry : fuzzyValues.entrySet()) {
            dims[i] = new Dim();
            dims[i].col = entry.getKey();
            dims[i].values = entry.getValue();
            if (dims[i].values == null) {
                dims[i].values = Collections.emptySet();
            }
            ++i;
        }
        return dims;
    }

    private static boolean exceedCap(Dim[] dims, long cap) {
        return FuzzyValueCombination.combCount(dims) > cap;
    }

    private static long combCount(Dim[] dims) {
        long count = 1L;
        for (Dim dim : dims) {
            count *= (long)Math.max(dim.values.size(), 1);
        }
        return count;
    }

    static {
        SINGLE_NULL_SET.add(null);
    }

    private static class Dim<E> {
        TblColRef col;
        Set<E> values;

        private Dim() {
        }
    }
}

