/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.utils;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.kylin.engine.spark.utils.BuildUtils;

public class YarnInfoFetcherUtils {
    private YarnInfoFetcherUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTrackingUrl(String applicationId) throws IOException, YarnException {
        try (YarnClient yarnClient = YarnClient.createYarnClient();){
            yarnClient.init((Configuration)BuildUtils.getCurrentYarnConfiguration());
            yarnClient.start();
            String[] array = applicationId.split("_");
            if (array.length < 3) {
                String string = null;
                return string;
            }
            ApplicationId appId = ApplicationId.newInstance((long)Long.valueOf(array[1]), (int)Integer.valueOf(array[2]));
            ApplicationReport applicationReport = yarnClient.getApplicationReport(appId);
            String string = null == applicationReport ? null : applicationReport.getTrackingUrl();
            return string;
        }
    }
}

