<!--
 - Licensed to the Apache Software Foundation (ASF) under one or more
 - contributor license agreements.  See the NOTICE file distributed with
 - this work for additional information regarding copyright ownership.
 - The ASF licenses this file to You under the Apache License, Version 2.0
 - (the "License"); you may not use this file except in compliance with
 - the License.  You may obtain a copy of the License at
 -
 -   http://www.apache.org/licenses/LICENSE-2.0
 -
 - Unless required by applicable law or agreed to in writing, software
 - distributed under the License is distributed on an "AS IS" BASIS,
 - WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 - See the License for the specific language governing permissions and
 - limitations under the License.
 -->


# Kyuubi High Availability Guide

As an enterprise-class ad-hoc SQL query service built on top of [Apache Spark](https://spark.apache.org/), Kyuubi takes high availability (HA) as a major characteristic, aiming to ensure an agreed level of service availability, such as a higher than normal period of uptime.

Running Kyuubi in HA mode is to use groups of computers or containers that support SQL query service on Kyuubi that can be reliably utilized with a minimum amount of down-time. Kyuubi operates by using [Apache ZooKeeper](https://zookeeper.apache.org/) to harness redundant service instances in groups that provide continuous service when one or more components fail.

Without HA, if a server crashes, Kyuubi will be unavailable until the crashed server is fixed. With HA, this situation will be remedied by hardware/software faults auto-detecting, and immediately another Kyuubi service instance will be ready to serve without requiring human intervention. 

## HA Architecture

Currently, Kyuubi supports load balancing to make the whole system highly available.

Load balancing aims to optimize all Kyuubi service unit's usage, maximize throughput, minimize response time, and avoid overload of a single unit.
Using multiple Kyuubi service units with load balancing instead of a single unit may increase reliability and availability through redundancy. 

<body><div class="mxgraph" style="max-width:100%;border:1px solid transparent;" data-mxgraph="{&quot;lightbox&quot;:false,&quot;nav&quot;:true,&quot;resize&quot;:true,&quot;toolbar&quot;:&quot;zoom layers tags&quot;,&quot;edit&quot;:&quot;_blank&quot;,&quot;xml&quot;:&quot;&lt;mxfile host=\&quot;Electron\&quot; modified=\&quot;2021-12-08T07:03:35.897Z\&quot; agent=\&quot;5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) draw.io/15.8.7 Chrome/91.0.4472.164 Electron/13.6.2 Safari/537.36\&quot; etag=\&quot;8cAdunJBy_Xq8elTWNYF\&quot; version=\&quot;15.8.7\&quot; type=\&quot;device\&quot;&gt;&lt;diagram id=\&quot;wdwMXvCkZb4ckzJC0Zil\&quot; name=\&quot;第 1 页\&quot;&gt;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&lt;/diagram&gt;&lt;/mxfile&gt;&quot;}"></div>
<script type="text/javascript" src="https://viewer.diagrams.net/js/viewer-static.min.js"></script>
</body>


### Key Benefits

- High concurrency
  - By adding or removing Kyuubi server instances can easily scale up or down to meet the need of client requests.
- Upgrade smoothly
  - Kyuubi server supports stop gracefully. We could delete a `k.i.` but not stop it immediately.
    In this case, the `k.i.` will not take any new connection request but only operation requests from existing connections.
    After all connection are released, it stops then.
  - The dependencies of Kyuubi engines are free to change, such as bump up versions, modify configurations, add external jars, relocate to another engine home. Everything will be reloaded during start and stop.


## System-side Deployment

When applying HA to Kyuubi deployment, we need to be aware of the below two thing basically,

- `kyuubi.ha.zookeeper.quorum` - the external zookeeper cluster address for deploy a `k.i.`
- `kyuubi.ha.zookeeper.namespace` - the root directory, a.k.a. the ServerSpace for deploy a `k.i.`

For more configurations, please see the HA section of [Introduction to the Kyuubi Configurations System](./settings.html#ha)

### Pseudo mode

When `kyuubi.ha.zookeeper.quorum` is not configured, a `k.i.` will start an embedded zookeeper service and expose the address of itself there.
In this pseduo mode, the `k.i.` can be connected by clients through both raw ip address and zk quorum + namespace.
But it doesn't have any availability to being highly available.

### Production mode

For production deployment purpose, an external zookeeper cluster is required for `kyuubi.ha.zookeeper.quorum`.
In this mode, multiple `k.i.`s can be registered to the same ServerSpace configured by `kyuubi.ha.zookeeper.namespace` and serve together.


## Client-side Usage

With [Kyuubi Hive JDBC Driver](https://mvnrepository.com/artifact/org.apache.kyuubi/kyuubi-hive-jdbc) or vanilla Hive JDBC Driver, a client can specify service discovery mode in JDBC connection string, i.e. `serviceDiscoveryMode=zooKeeper;` and set `zooKeeperNamespace=kyuubi;`, then it can randomly pick one of the Kyuubi service uris from the specified ZooKeeper addresses in the `/kyuubi` path.

For example,

```shell
bin/beeline -u 'jdbc:hive2://10.242.189.214:2181/;serviceDiscoveryMode=zooKeeper;zooKeeperNamespace=kyuubi' -n kentyao
```

## How to Hot Upgrade Kyuubi Server

Kyuubi supports hot upgrade one of server in a HA cluster which is transparent to users.

- If you have specified a custom port for Kyuubi server 

  For example, the Kyuubi server started at host `kyuubi.host` with port `10009`, you can run the following cmd using `bin/kyuubi-ctl`:
  
  ```shell
  ./bin/kyuubi-ctl delete server --host "kyuubi.host" --port "10009"
  ```
  
  Kyuubi server will stop until all session closed, and then you can start a new Kyuubi server.

- If you use a random port for Kyuubi server

  You can just start the new Kyuubi Server, then runing cmd using `bin/kyuubi-ctl`:

  ```shell
  ./bin/kyuubi-ctl delete server --host "kyuubi.host" --port "${PORT_FPR_OLD_KYUUBI_SERVER}"
  ```

  The `${PORT_FPR_OLD_KYUUBI_SERVER}` can be found by:

  ```shell
  grep "server.KyuubiThriftBinaryFrontendService: Starting and exposing JDBC connection at" logs/kyuubi-*.out
  ```
  Note that, you do not need to care when the old Kyuubi server actually stopped since the new coming session are routed to the new Kyuubi server and others.
