/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.mysql.authentication;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kyuubi.server.mysql.MySQLErrPacket;
import org.apache.kyuubi.server.mysql.MySQLOKPacket;
import org.apache.kyuubi.server.mysql.MySQLOKPacket$;
import org.apache.kyuubi.server.mysql.SupportsEncode;
import org.apache.kyuubi.server.mysql.authentication.AuthenticationResult;
import org.apache.kyuubi.server.mysql.authentication.AuthenticationResult$;
import org.apache.kyuubi.server.mysql.authentication.MySQLAuthSwitchRequestPacket;
import org.apache.kyuubi.server.mysql.authentication.MySQLAuthSwitchResponsePacket;
import org.apache.kyuubi.server.mysql.authentication.MySQLAuthSwitchResponsePacket$;
import org.apache.kyuubi.server.mysql.authentication.MySQLAuthentication$;
import org.apache.kyuubi.server.mysql.authentication.MySQLAuthenticationMethod$NATIVE_PASSWORD$;
import org.apache.kyuubi.server.mysql.authentication.MySQLConnectionPhase$;
import org.apache.kyuubi.server.mysql.authentication.MySQLHandshakePacket;
import org.apache.kyuubi.server.mysql.authentication.MySQLHandshakeResponse41Packet;
import org.apache.kyuubi.server.mysql.authentication.MySQLHandshakeResponse41Packet$;
import org.apache.kyuubi.server.mysql.authentication.MySQLNativePassword;
import org.apache.kyuubi.server.mysql.constant.MySQLCapabilityFlag$CLIENT_PLUGIN_AUTH$;
import org.apache.kyuubi.server.mysql.constant.MySQLErrorCode;
import org.apache.kyuubi.server.mysql.constant.MySQLErrorCode$ER_ACCESS_DENIED_ERROR$;
import org.apache.kyuubi.server.mysql.constant.MySQLErrorCode$ER_DBACCESS_DENIED_ERROR$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\f\u0019\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u00135\u0011\u0007\u0003\u00046\u0001\u0001\u0006iA\r\u0005\bm\u0001\u0011\r\u0011\"\u00048\u0011\u0019!\u0005\u0001)A\u0007q!9Q\t\u0001a\u0001\n\u00131\u0005bB(\u0001\u0001\u0004%I\u0001\u0015\u0005\u0007-\u0002\u0001\u000b\u0015B$\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0013A\u0006\"C0\u0001\u0001\u0004\u0005\r\u0011\"\u0003a\u0011%\u0011\u0007\u00011A\u0001B\u0003&\u0011\fC\u0005d\u0001\u0001\u0007\t\u0019!C\u0005I\"I\u0001\u000e\u0001a\u0001\u0002\u0004%I!\u001b\u0005\nW\u0002\u0001\r\u0011!Q!\n\u0015DQ\u0001\u001c\u0001\u0005\u00025DQ! \u0001\u0005\u0002yDq!!\u0005\u0001\t\u0013\t\u0019\u0002C\u0004\u0002\u001a\u0001!I!a\u0007\t\u000f\u00055\u0002\u0001\"\u0003\u00020!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u0003K\u0002A\u0011BA4\u0005ei\u0015pU)M\u0003V$\b.\u001a8uS\u000e\fG/[8o\u000b:<\u0017N\\3\u000b\u0005eQ\u0012AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u00037q\tQ!\\=tc2T!!\b\u0010\u0002\rM,'O^3s\u0015\ty\u0002%\u0001\u0004lsV,(-\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u00021\u0005i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012A\r\t\u0003_MJ!\u0001\u000e\r\u0003'5K8+\u0015'OCRLg/\u001a)bgN<xN\u001d3\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005a1-\u001e:sK:$8+Z9JIV\t\u0001\b\u0005\u0002:\u00056\t!H\u0003\u0002<y\u00051\u0011\r^8nS\u000eT!!\u0010 \u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002@\u0001\u0006!Q\u000f^5m\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011\u001e\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u00035\u0019WO\u001d:f]R\u001cV-]%eA\u0005y1m\u001c8oK\u000e$\u0018n\u001c8QQ\u0006\u001cX-F\u0001H!\tA5J\u0004\u00020\u0013&\u0011!\nG\u0001\u0015\u001bf\u001c\u0016\u000bT\"p]:,7\r^5p]BC\u0017m]3\n\u00051k%!\u0002,bYV,\u0017B\u0001()\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002'\r|gN\\3di&|g\u000e\u00155bg\u0016|F%Z9\u0015\u0005E#\u0006CA\u0014S\u0013\t\u0019\u0006F\u0001\u0003V]&$\bbB+\b\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0014\u0001E2p]:,7\r^5p]BC\u0017m]3!\u00031\tW\u000f\u001e5SKN\u0004xN\\:f+\u0005I\u0006cA\u0014[9&\u00111\f\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003OuK!A\u0018\u0015\u0003\t\tKH/Z\u0001\u0011CV$\bNU3ta>t7/Z0%KF$\"!U1\t\u000fUS\u0011\u0011!a\u00013\u0006i\u0011-\u001e;i%\u0016\u001c\bo\u001c8tK\u0002\n!\"Y;uQJ+7/\u001e7u+\u0005)\u0007CA\u0018g\u0013\t9\u0007D\u0001\u000bBkRDWM\u001c;jG\u0006$\u0018n\u001c8SKN,H\u000e^\u0001\u000fCV$\bNU3tk2$x\fJ3r)\t\t&\u000eC\u0004V\u001b\u0005\u0005\t\u0019A3\u0002\u0017\u0005,H\u000f\u001b*fgVdG\u000fI\u0001\nQ\u0006tGm\u001d5bW\u0016$\"A\\9\u0011\u0005\u001dz\u0017B\u00019)\u0005\rIe\u000e\u001e\u0005\u0006e>\u0001\ra]\u0001\u0004GRD\bC\u0001;|\u001b\u0005)(B\u0001<x\u0003\u001d\u0019\u0007.\u00198oK2T!\u0001_=\u0002\u000b9,G\u000f^=\u000b\u0003i\f!![8\n\u0005q,(!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010^\u0001\rCV$\b.\u001a8uS\u000e\fG/\u001a\u000b\u0005K~\f\t\u0001C\u0003s!\u0001\u00071\u000fC\u0004\u0002\u0004A\u0001\r!!\u0002\u0002\u0007\t,h\r\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tYa^\u0001\u0007EV4g-\u001a:\n\t\u0005=\u0011\u0011\u0002\u0002\b\u0005f$XMQ;g\u0003E\tW\u000f\u001e5QQ\u0006\u001cXMR1tiB\u000bG\u000f\u001b\u000b\u0006K\u0006U\u0011q\u0003\u0005\u0006eF\u0001\ra\u001d\u0005\b\u0003\u0007\t\u0002\u0019AA\u0003\u0003II7o\u00117jK:$\b\u000b\\;hS:\fU\u000f\u001e5\u0015\t\u0005u\u00111\u0005\t\u0004O\u0005}\u0011bAA\u0011Q\t9!i\\8mK\u0006t\u0007bBA\u0013%\u0001\u0007\u0011qE\u0001\u0007a\u0006\u001c7.\u001a;\u0011\u0007=\nI#C\u0002\u0002,a\u0011a$T=T#2C\u0015M\u001c3tQ\u0006\\WMU3ta>t7/\u001a\u001b2!\u0006\u001c7.\u001a;\u00029\u0005,H\u000f[3oi&\u001c\u0017\r^5p]6+G\u000f[8e\u001b&\u001cX.\u0019;dQR\u0019\u0011+!\r\t\u000f\u0005\r1\u00031\u0001\u0002\u0006\u0005\t2M]3bi\u0016,%O]8s!\u0006\u001c7.\u001a;\u0015\u0011\u0005]\u0012qHA!\u0003#\u0002B!!\u000f\u0002<5\t!$C\u0002\u0002>i\u0011a\"T=T#2+%O\u001d)bG.,G\u000fC\u0003s)\u0001\u00071\u000fC\u0004\u0002DQ\u0001\r!!\u0012\u0002\u0013\u0015\u0014(o\u001c:D_\u0012,\u0007\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-#$\u0001\u0005d_:\u001cH/\u00198u\u0013\u0011\ty%!\u0013\u0003\u001d5K8+\u0015'FeJ|'oQ8eK\"1\u00111\u000b\u000bA\u00029\fQa]3r\u0013\u0012\fA\"\u001a:s_JlUm]:bO\u0016,\"!!\u0017\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018A\u0003\u0011a\u0017M\\4\n\t\u0005\r\u0014Q\f\u0002\u0007'R\u0014\u0018N\\4\u0002\u001bI,Wn\u001c;f\u0003\u0012$'/Z:t)\u0011\tI'! \u0011\t\u0005-\u0014\u0011\u0010\b\u0005\u0003[\n)\bE\u0002\u0002p!j!!!\u001d\u000b\u0007\u0005MD%\u0001\u0004=e>|GOP\u0005\u0004\u0003oB\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0005m$bAA<Q!)!O\u0006a\u0001g\u0002")
public class MySQLAuthenticationEngine {
    private final MySQLNativePassword authenticator = new MySQLNativePassword();
    private final AtomicInteger currentSeqId = new AtomicInteger();
    private Enumeration.Value connectionPhase = MySQLConnectionPhase$.MODULE$.INITIAL_HANDSHAKE();
    private byte[] authResponse;
    private AuthenticationResult authResult;

    private final MySQLNativePassword authenticator() {
        return this.authenticator;
    }

    private final AtomicInteger currentSeqId() {
        return this.currentSeqId;
    }

    private Enumeration.Value connectionPhase() {
        return this.connectionPhase;
    }

    private void connectionPhase_$eq(Enumeration.Value x$1) {
        this.connectionPhase = x$1;
    }

    private byte[] authResponse() {
        return this.authResponse;
    }

    private void authResponse_$eq(byte[] x$1) {
        this.authResponse = x$1;
    }

    private AuthenticationResult authResult() {
        return this.authResult;
    }

    private void authResult_$eq(AuthenticationResult x$1) {
        this.authResult = x$1;
    }

    public int handshake(ChannelHandlerContext ctx) {
        int connectionId = MySQLAuthentication$.MODULE$.connIdCounter().getAndIncrement();
        this.connectionPhase_$eq(MySQLConnectionPhase$.MODULE$.AUTH_PHASE_FAST_PATH());
        ctx.writeAndFlush((Object)new MySQLHandshakePacket(connectionId, this.authenticator().pluginData()));
        return connectionId;
    }

    public AuthenticationResult authenticate(ChannelHandlerContext ctx, ByteBuf buf) {
        Enumeration.Value value = this.connectionPhase();
        Enumeration.Value value2 = MySQLConnectionPhase$.MODULE$.AUTHENTICATION_METHOD_MISMATCH();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.authenticationMethodMismatch(buf);
        } else {
            Enumeration.Value value4 = MySQLConnectionPhase$.MODULE$.AUTH_PHASE_FAST_PATH();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                this.authResult_$eq(this.authPhaseFastPath(ctx, buf));
                if (!this.authResult().finished()) {
                    return this.authResult();
                }
            }
        }
        int seqId = this.currentSeqId().incrementAndGet();
        SupportsEncode responsePacket = (SupportsEncode)this.authenticator().login(this.authResult().user(), this.remoteAddress(ctx), this.authResponse(), this.authResult().database()).map((Function1 & Serializable & scala.Serializable)x$1 -> this.createErrorPacket(ctx, (MySQLErrorCode)x$1, seqId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new MySQLOKPacket(seqId, MySQLOKPacket$.MODULE$.apply$default$2(), MySQLOKPacket$.MODULE$.apply$default$3()));
        ctx.writeAndFlush((Object)responsePacket);
        return AuthenticationResult$.MODULE$.finished(this.authResult().user(), this.remoteAddress(ctx), this.authResult().database());
    }

    private AuthenticationResult authPhaseFastPath(ChannelHandlerContext ctx, ByteBuf buf) {
        MySQLHandshakeResponse41Packet packet = MySQLHandshakeResponse41Packet$.MODULE$.decode(buf);
        this.authResponse_$eq(packet.authResponse());
        this.currentSeqId().set(packet.sequenceId());
        if (this.isClientPluginAuth(packet)) {
            String string = packet.authPluginName();
            String string2 = MySQLAuthenticationMethod$NATIVE_PASSWORD$.MODULE$.method();
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.connectionPhase_$eq(MySQLConnectionPhase$.MODULE$.AUTHENTICATION_METHOD_MISMATCH());
                ctx.writeAndFlush((Object)new MySQLAuthSwitchRequestPacket(this.currentSeqId().incrementAndGet(), MySQLAuthenticationMethod$NATIVE_PASSWORD$.MODULE$.method(), this.authenticator().pluginData()));
                return AuthenticationResult$.MODULE$.continued(packet.username(), this.remoteAddress(ctx), packet.database());
            }
        }
        return AuthenticationResult$.MODULE$.finished(packet.username(), this.remoteAddress(ctx), packet.database());
    }

    private boolean isClientPluginAuth(MySQLHandshakeResponse41Packet packet) {
        return (packet.capabilityFlags() & MySQLCapabilityFlag$CLIENT_PLUGIN_AUTH$.MODULE$.value()) != 0;
    }

    private void authenticationMethodMismatch(ByteBuf buf) {
        MySQLAuthSwitchResponsePacket packet = MySQLAuthSwitchResponsePacket$.MODULE$.decode(buf);
        this.currentSeqId().set(packet.sequenceId());
        this.authResponse_$eq(packet.authPluginResponse());
    }

    private MySQLErrPacket createErrorPacket(ChannelHandlerContext ctx, MySQLErrorCode errorCode, int seqId) {
        MySQLErrorCode mySQLErrorCode = errorCode;
        if (((Object)MySQLErrorCode$ER_DBACCESS_DENIED_ERROR$.MODULE$).equals(mySQLErrorCode)) {
            return new MySQLErrPacket(seqId, MySQLErrorCode$ER_DBACCESS_DENIED_ERROR$.MODULE$, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.authResult().user(), this.remoteAddress(ctx), this.authResult().database()}));
        }
        return new MySQLErrPacket(seqId, MySQLErrorCode$ER_ACCESS_DENIED_ERROR$.MODULE$, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.authResult().user(), this.remoteAddress(ctx), this.errorMessage()}));
    }

    private String errorMessage() {
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.authResponse())).nonEmpty()) {
            return "YES";
        }
        return "NO";
    }

    private String remoteAddress(ChannelHandlerContext ctx) {
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getAddress().getHostAddress();
        }
        return socketAddress.toString();
    }
}

