/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.fliptables;

import com.jakewharton.fliptables.FlipTable;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FlipTableConverters {
    private static final Pattern METHOD = Pattern.compile("^(?:get|is|has)([A-Z][a-zA-Z0-9]*)+$");
    private static final Comparator<Method> METHOD_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public static String fromObjects(String[] headers, Object[][] data) {
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        ArrayList<String[]> stringData = new ArrayList<String[]>();
        for (Object[] row : data) {
            String[] stringRow = new String[row.length];
            for (int column = 0; column < row.length; ++column) {
                stringRow[column] = String.valueOf(row[column]);
            }
            stringData.add(stringRow);
        }
        String[][] dataArray = (String[][])stringData.toArray((T[])new String[stringData.size()][]);
        return FlipTable.of(headers, dataArray);
    }

    public static <T> String fromIterable(Iterable<T> rows, Class<T> rowType) {
        if (rows == null) {
            throw new NullPointerException("rows == null");
        }
        if (rowType == null) {
            throw new NullPointerException("rowType == null");
        }
        Method[] declaredMethods = rowType.getDeclaredMethods();
        Arrays.sort(declaredMethods, METHOD_COMPARATOR);
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<String> headers = new ArrayList<String>();
        for (Method declaratedMethod : declaredMethods) {
            Matcher matcher;
            if (declaratedMethod.getParameterTypes().length > 0 || declaratedMethod.getReturnType() == Void.TYPE || !(matcher = METHOD.matcher(declaratedMethod.getName())).matches()) continue;
            declaratedMethod.setAccessible(true);
            methods.add(declaratedMethod);
            headers.add(matcher.group(1));
        }
        int columnCount = methods.size();
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (T row : rows) {
            String[] rowData = new String[columnCount];
            for (int column = 0; column < columnCount; ++column) {
                try {
                    rowData[column] = String.valueOf(((Method)methods.get(column)).invoke(row, new Object[0]));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            data.add(rowData);
        }
        String[] headerArray = headers.toArray(new String[headers.size()]);
        String[][] dataArray = (String[][])data.toArray((T[])new String[data.size()][]);
        return FlipTable.of(headerArray, dataArray);
    }

    static String fromResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new NullPointerException("resultSet == null");
        }
        if (!resultSet.isBeforeFirst()) {
            throw new IllegalStateException("Result set not at first.");
        }
        ArrayList<String> headers = new ArrayList<String>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int column = 0; column < columnCount; ++column) {
            headers.add(resultSetMetaData.getColumnName(column + 1));
        }
        ArrayList<String[]> data = new ArrayList<String[]>();
        while (resultSet.next()) {
            String[] rowData = new String[columnCount];
            for (int column = 0; column < columnCount; ++column) {
                rowData[column] = resultSet.getString(column + 1);
            }
            data.add(rowData);
        }
        String[] headerArray = headers.toArray(new String[headers.size()]);
        String[][] dataArray = (String[][])data.toArray((T[])new String[data.size()][]);
        return FlipTable.of(headerArray, dataArray);
    }

    private FlipTableConverters() {
        throw new AssertionError((Object)"No instances.");
    }
}

