/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import javax.security.sasl.AuthenticationException;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.AnonymousAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.AuthMethods$;
import org.apache.kyuubi.service.authentication.EngineSecureAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.JdbcAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.LdapAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.LdapAuthenticationProviderImpl$;
import org.apache.kyuubi.service.authentication.PasswdAuthenticationProvider;
import org.apache.kyuubi.util.ClassUtils$;
import scala.Enumeration;
import scala.Option;
import scala.runtime.BoxesRunTime;

public final class AuthenticationProviderFactory$ {
    public static final AuthenticationProviderFactory$ MODULE$ = new AuthenticationProviderFactory$();

    public PasswdAuthenticationProvider getAuthenticationProvider(Enumeration.Value method, KyuubiConf conf, boolean isServer) throws AuthenticationException {
        return isServer ? this.getAuthenticationProviderForServer(method, conf) : this.getAuthenticationProviderForEngine(conf);
    }

    public boolean getAuthenticationProvider$default$3() {
        return true;
    }

    private PasswdAuthenticationProvider getAuthenticationProviderForServer(Enumeration.Value method, KyuubiConf conf) {
        PasswdAuthenticationProvider passwdAuthenticationProvider;
        Enumeration.Value value = method;
        Enumeration.Value value2 = AuthMethods$.MODULE$.NONE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            passwdAuthenticationProvider = new AnonymousAuthenticationProviderImpl();
        } else {
            Enumeration.Value value4 = AuthMethods$.MODULE$.LDAP();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                passwdAuthenticationProvider = new LdapAuthenticationProviderImpl(conf, LdapAuthenticationProviderImpl$.MODULE$.$lessinit$greater$default$2());
            } else {
                Enumeration.Value value6 = AuthMethods$.MODULE$.JDBC();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    passwdAuthenticationProvider = new JdbcAuthenticationProviderImpl(conf);
                } else {
                    Enumeration.Value value8 = AuthMethods$.MODULE$.CUSTOM();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        Option className = (Option)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_CUSTOM_CLASS());
                        if (className.isEmpty()) {
                            throw new AuthenticationException("authentication.custom.class must be set when auth method was CUSTOM.");
                        }
                        passwdAuthenticationProvider = ClassUtils$.MODULE$.createInstance((String)className.get(), PasswdAuthenticationProvider.class, conf);
                    } else {
                        throw new AuthenticationException("Not a valid authentication method");
                    }
                }
            }
        }
        return passwdAuthenticationProvider;
    }

    private PasswdAuthenticationProvider getAuthenticationProviderForEngine(KyuubiConf conf) {
        return BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED())) ? new EngineSecureAuthenticationProviderImpl() : new AnonymousAuthenticationProviderImpl();
    }

    private AuthenticationProviderFactory$() {
    }
}

