/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.ExpressionRuleContext;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.LogPanel;
import org.apache.log4j.chainsaw.LogPanelLoggerTreeModel;
import org.apache.log4j.chainsaw.LogPanelPreferenceModel;
import org.apache.log4j.chainsaw.LoggerNameListener;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.ColorRule;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

final class LoggerNameTreePanel
extends JPanel
implements LoggerNameListener {
    private static final int WARN_DEPTH = 4;
    private LoggerNameTreeCellRenderer cellRenderer = new LoggerNameTreeCellRenderer();
    private final Action clearIgnoreListAction;
    private final Action closeAction;
    private final JButton closeButton = new SmallButton();
    private final Action collapseAction;
    private final JButton collapseButton = new SmallButton();
    private final Action editLoggerAction;
    private final JButton editLoggerButton = new SmallButton();
    private final Action expandAction;
    private final Action findAction;
    private final Action clearFindNextAction;
    private final Action defineColorRuleForLoggerAction;
    private final Action setRefineFocusAction;
    private final Action updateRefineFocusAction;
    private final Action updateFindAction;
    private final JButton expandButton = new SmallButton();
    private final Action focusOnAction;
    private final Action clearRefineFocusAction;
    private final SmallToggleButton focusOnLoggerButton = new SmallToggleButton();
    private final Set hiddenSet = new HashSet();
    private final Action hideAction;
    private final Action hideSubLoggersAction;
    private final LogPanelPreferenceModel preferenceModel;
    private final JList ignoreList = new JList();
    private final JEditorPane ignoreExpressionEntryField = new JEditorPane();
    private final JEditorPane alwaysDisplayExpressionEntryField = new JEditorPane();
    private final JScrollPane ignoreListScroll = new JScrollPane(this.ignoreList);
    private final JDialog ignoreDialog = new JDialog();
    private final JDialog ignoreExpressionDialog = new JDialog();
    private final JDialog alwaysDisplayExpressionDialog = new JDialog();
    private final JLabel ignoreSummary = new JLabel("0 hidden loggers");
    private final JLabel ignoreExpressionSummary = new JLabel("Ignore expression");
    private final JLabel alwaysDisplayExpressionSummary = new JLabel("Always displayed expression");
    private final SmallToggleButton ignoreLoggerButton = new SmallToggleButton();
    private final EventListenerList listenerList = new EventListenerList();
    private final JTree logTree;
    private final Logger logger = LogManager.getLogger(LoggerNameTreePanel.class);
    private final LogPanelLoggerTreeModel logTreeModel;
    private final PopupListener popupListener;
    private final LoggerTreePopupMenu popupMenu;
    private final VisibilityRuleDelegate visibilityRuleDelegate;
    private Rule colorRuleDelegate;
    private final JScrollPane scrollTree;
    private final JToolBar toolbar = new JToolBar();
    private final LogPanel logPanel;
    private final RuleColorizer colorizer;
    private Rule ignoreExpressionRule;
    private Rule alwaysDisplayExpressionRule;
    private boolean expandRootLatch = false;
    private String currentlySelectedLoggerName;

    LoggerNameTreePanel(LogPanelLoggerTreeModel logTreeModel, LogPanelPreferenceModel preferenceModel, LogPanel logPanel, RuleColorizer colorizer, FilterModel filterModel) {
        this.logTreeModel = logTreeModel;
        this.preferenceModel = preferenceModel;
        this.logPanel = logPanel;
        this.colorizer = colorizer;
        this.setLayout(new BorderLayout());
        this.ignoreExpressionEntryField.setPreferredSize(new Dimension(300, 150));
        this.alwaysDisplayExpressionEntryField.setPreferredSize(new Dimension(300, 150));
        this.alwaysDisplayExpressionSummary.setMinimumSize(new Dimension(10, this.alwaysDisplayExpressionSummary.getHeight()));
        this.ignoreExpressionSummary.setMinimumSize(new Dimension(10, this.ignoreExpressionSummary.getHeight()));
        this.ignoreSummary.setMinimumSize(new Dimension(10, this.ignoreSummary.getHeight()));
        JTextComponentFormatter.applySystemFontAndSize(this.ignoreExpressionEntryField);
        JTextComponentFormatter.applySystemFontAndSize(this.alwaysDisplayExpressionEntryField);
        this.visibilityRuleDelegate = new VisibilityRuleDelegate();
        this.colorRuleDelegate = new AbstractRule(){

            public boolean evaluate(LoggingEvent e, Map matches) {
                boolean hiddenLogger = e.getLoggerName() != null && LoggerNameTreePanel.this.isHiddenLogger(e.getLoggerName());
                boolean hiddenExpression = LoggerNameTreePanel.this.ignoreExpressionRule != null && LoggerNameTreePanel.this.ignoreExpressionRule.evaluate(e, null);
                boolean alwaysDisplayExpression = LoggerNameTreePanel.this.alwaysDisplayExpressionRule != null && LoggerNameTreePanel.this.alwaysDisplayExpressionRule.evaluate(e, null);
                boolean hidden = !alwaysDisplayExpression && (hiddenLogger || hiddenExpression);
                String currentlySelectedLoggerName = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                if (!(LoggerNameTreePanel.this.isFocusOnSelected() || hidden || currentlySelectedLoggerName == null || "".equals(currentlySelectedLoggerName))) {
                    return e.getLoggerName().startsWith(currentlySelectedLoggerName + ".") || e.getLoggerName().endsWith(currentlySelectedLoggerName);
                }
                return false;
            }
        };
        this.logTree = new JTree(logTreeModel){

            @Override
            public String getToolTipText(MouseEvent ev) {
                if (ev == null) {
                    return null;
                }
                TreePath path = LoggerNameTreePanel.this.logTree.getPathForLocation(ev.getX(), ev.getY());
                String loggerName = LoggerNameTreePanel.this.getLoggerName(path);
                if (LoggerNameTreePanel.this.hiddenSet.contains(loggerName)) {
                    loggerName = loggerName + " (you are ignoring this logger)";
                }
                return loggerName;
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.logTree);
        this.logTree.setCellRenderer(this.cellRenderer);
        logTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                if (!LoggerNameTreePanel.this.expandRootLatch) {
                    LoggerNameTreePanel.this.ensureRootExpanded();
                    LoggerNameTreePanel.this.expandRootLatch = true;
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        this.logTree.setEditable(false);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.logTree.setSelectionModel(selectionModel);
        this.logTree.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.scrollTree = new JScrollPane(this.logTree);
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 0));
        this.expandAction = this.createExpandAction();
        this.findAction = this.createFindNextAction();
        this.clearFindNextAction = this.createClearFindNextAction();
        this.defineColorRuleForLoggerAction = this.createDefineColorRuleForLoggerAction();
        this.clearRefineFocusAction = this.createClearRefineFocusAction();
        this.setRefineFocusAction = this.createSetRefineFocusAction();
        this.updateRefineFocusAction = this.createUpdateRefineFocusAction();
        this.updateFindAction = this.createUpdateFindAction();
        this.editLoggerAction = this.createEditLoggerAction();
        this.closeAction = this.createCloseAction();
        this.collapseAction = this.createCollapseAction();
        this.focusOnAction = this.createFocusOnAction();
        this.hideAction = this.createIgnoreAction();
        this.hideSubLoggersAction = this.createIgnoreAllAction();
        this.clearIgnoreListAction = this.createClearIgnoreListAction();
        this.popupMenu = new LoggerTreePopupMenu();
        this.popupListener = new PopupListener(this.popupMenu);
        this.setupListeners();
        this.configureToolbarPanel();
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.scrollTree, "Center");
        this.ignoreDialog.setTitle("Hidden/Ignored Loggers");
        this.ignoreDialog.setModal(true);
        this.ignoreExpressionDialog.setTitle("Hidden/Ignored Expression");
        this.ignoreExpressionDialog.setModal(true);
        this.alwaysDisplayExpressionDialog.setTitle("Always displayed Expression");
        this.alwaysDisplayExpressionDialog.setModal(true);
        JPanel ignorePanel = new JPanel();
        ignorePanel.setLayout(new BoxLayout(ignorePanel, 1));
        JPanel ignoreSummaryPanel = new JPanel();
        ignoreSummaryPanel.setLayout(new BoxLayout(ignoreSummaryPanel, 0));
        ignoreSummaryPanel.add(this.ignoreSummary);
        AbstractAction showIgnoreDialogAction = new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.centerAndSetVisible(LoggerNameTreePanel.this.ignoreDialog);
            }
        };
        AbstractAction showIgnoreExpressionDialogAction = new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.centerAndSetVisible(LoggerNameTreePanel.this.ignoreExpressionDialog);
            }
        };
        AbstractAction showAlwaysDisplayExpressionDialogAction = new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel.centerAndSetVisible(LoggerNameTreePanel.this.alwaysDisplayExpressionDialog);
            }
        };
        showIgnoreDialogAction.putValue("ShortDescription", "Click to view and manage your hidden/ignored loggers");
        SmallButton btnShowIgnoreDialog = new SmallButton(showIgnoreDialogAction);
        ignoreSummaryPanel.add(btnShowIgnoreDialog);
        ignorePanel.add(ignoreSummaryPanel);
        JPanel ignoreExpressionPanel = new JPanel();
        ignoreExpressionPanel.setLayout(new BoxLayout(ignoreExpressionPanel, 0));
        ignoreExpressionPanel.add(this.ignoreExpressionSummary);
        showIgnoreExpressionDialogAction.putValue("ShortDescription", "Click to view and manage your hidden/ignored expression");
        SmallButton btnShowIgnoreExpressionDialog = new SmallButton(showIgnoreExpressionDialogAction);
        ignoreExpressionPanel.add(btnShowIgnoreExpressionDialog);
        ignorePanel.add(ignoreExpressionPanel);
        JPanel alwaysDisplayExpressionPanel = new JPanel();
        alwaysDisplayExpressionPanel.setLayout(new BoxLayout(alwaysDisplayExpressionPanel, 0));
        alwaysDisplayExpressionPanel.add(this.alwaysDisplayExpressionSummary);
        showAlwaysDisplayExpressionDialogAction.putValue("ShortDescription", "Click to view and manage your always-displayed expression");
        SmallButton btnShowAlwaysDisplayExpressionDialog = new SmallButton(showAlwaysDisplayExpressionDialogAction);
        alwaysDisplayExpressionPanel.add(btnShowAlwaysDisplayExpressionDialog);
        ignorePanel.add(alwaysDisplayExpressionPanel);
        this.add((Component)ignorePanel, "South");
        this.ignoreList.setModel(new DefaultListModel());
        this.ignoreList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() > 1 && (e.getModifiers() & 0x10) > 0 && (index = LoggerNameTreePanel.this.ignoreList.locationToIndex(e.getPoint())) >= 0) {
                    String string = LoggerNameTreePanel.this.ignoreList.getModel().getElementAt(index).toString();
                    LoggerNameTreePanel.this.toggleHiddenLogger(string);
                    LoggerNameTreePanel.this.fireChangeEvent();
                    LoggerNameTreePanel.this.logTreeModel.nodeStructureChanged((TreeNode)LoggerNameTreePanel.this.logTreeModel.getRoot());
                }
            }
        });
        JPanel ignoreListPanel = new JPanel(new BorderLayout());
        this.ignoreListScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Double click an entry to unhide it"));
        ignoreListPanel.add((Component)this.ignoreListScroll, "Center");
        JPanel ignoreExpressionDialogPanel = new JPanel(new BorderLayout());
        this.ignoreExpressionEntryField.addKeyListener(new ExpressionRuleContext(filterModel, this.ignoreExpressionEntryField));
        ignoreExpressionDialogPanel.add((Component)new JScrollPane(this.ignoreExpressionEntryField), "Center");
        JButton ignoreExpressionCloseButton = new JButton(new AbstractAction(" Close "){

            @Override
            public void actionPerformed(ActionEvent e) {
                String ignoreText = LoggerNameTreePanel.this.ignoreExpressionEntryField.getText();
                if (LoggerNameTreePanel.this.updateIgnoreExpression(ignoreText)) {
                    LoggerNameTreePanel.this.ignoreExpressionDialog.setVisible(false);
                }
            }
        });
        JPanel alwaysDisplayExpressionDialogPanel = new JPanel(new BorderLayout());
        this.alwaysDisplayExpressionEntryField.addKeyListener(new ExpressionRuleContext(filterModel, this.alwaysDisplayExpressionEntryField));
        alwaysDisplayExpressionDialogPanel.add((Component)new JScrollPane(this.alwaysDisplayExpressionEntryField), "Center");
        JButton alwaysDisplayExpressionCloseButton = new JButton(new AbstractAction(" Close "){

            @Override
            public void actionPerformed(ActionEvent e) {
                String alwaysDisplayText = LoggerNameTreePanel.this.alwaysDisplayExpressionEntryField.getText();
                if (LoggerNameTreePanel.this.updateAlwaysDisplayExpression(alwaysDisplayText)) {
                    LoggerNameTreePanel.this.alwaysDisplayExpressionDialog.setVisible(false);
                }
            }
        });
        JPanel closeAlwaysDisplayExpressionPanel = new JPanel();
        closeAlwaysDisplayExpressionPanel.add(alwaysDisplayExpressionCloseButton);
        alwaysDisplayExpressionDialogPanel.add((Component)closeAlwaysDisplayExpressionPanel, "South");
        JPanel closeIgnoreExpressionPanel = new JPanel();
        closeIgnoreExpressionPanel.add(ignoreExpressionCloseButton);
        ignoreExpressionDialogPanel.add((Component)closeIgnoreExpressionPanel, "South");
        Box ignoreListButtonPanel = Box.createHorizontalBox();
        JButton unhideAll = new JButton(new AbstractAction(" Unhide All "){

            @Override
            public void actionPerformed(final ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoggerNameTreePanel.this.clearIgnoreListAction.actionPerformed(e);
                    }
                });
            }
        });
        ignoreListButtonPanel.add(unhideAll);
        ignoreListButtonPanel.add(Box.createHorizontalGlue());
        JButton ignoreCloseButton = new JButton(new AbstractAction(" Close "){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.ignoreDialog.setVisible(false);
            }
        });
        ignoreListButtonPanel.add(ignoreCloseButton);
        ignoreListPanel.add((Component)ignoreListButtonPanel, "South");
        this.ignoreDialog.getContentPane().add(ignoreListPanel);
        this.ignoreDialog.pack();
        this.ignoreExpressionDialog.getContentPane().add(ignoreExpressionDialogPanel);
        this.ignoreExpressionDialog.pack();
        this.alwaysDisplayExpressionDialog.getContentPane().add(alwaysDisplayExpressionDialogPanel);
        this.alwaysDisplayExpressionDialog.pack();
    }

    private boolean updateIgnoreExpression(String ignoreText) {
        try {
            this.ignoreExpressionRule = ignoreText != null && !ignoreText.trim().equals("") ? ExpressionRule.getRule((String)ignoreText) : null;
            this.visibilityRuleDelegate.firePropertyChange("hiddenSet", null, null);
            this.updateDisplay();
            this.ignoreExpressionEntryField.setBackground(UIManager.getColor("TextField.background"));
            return true;
        }
        catch (IllegalArgumentException iae) {
            this.ignoreExpressionEntryField.setToolTipText(iae.getMessage());
            this.ignoreExpressionEntryField.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
            return false;
        }
    }

    private boolean updateAlwaysDisplayExpression(String alwaysDisplayText) {
        try {
            this.alwaysDisplayExpressionRule = alwaysDisplayText != null && !alwaysDisplayText.trim().equals("") ? ExpressionRule.getRule((String)alwaysDisplayText) : null;
            this.visibilityRuleDelegate.firePropertyChange("alwaysDisplayedSet", null, null);
            this.updateDisplay();
            this.alwaysDisplayExpressionEntryField.setBackground(UIManager.getColor("TextField.background"));
            return true;
        }
        catch (IllegalArgumentException iae) {
            this.alwaysDisplayExpressionEntryField.setToolTipText(iae.getMessage());
            this.alwaysDisplayExpressionEntryField.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
            return false;
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public Rule getLoggerColorRule() {
        return this.colorRuleDelegate;
    }

    public Rule getLoggerVisibilityRule() {
        return this.visibilityRuleDelegate;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public void setFocusOn(String newLogger) {
        LogPanelLoggerTreeModel.LogPanelTreeNode node = this.logTreeModel.lookupLogger(newLogger);
        if (node != null) {
            Object[] nodes = node.getPath();
            TreePath treePath = new TreePath(nodes);
            this.logTree.setSelectionPath(treePath);
            if (!this.focusOnLoggerButton.isSelected()) {
                this.focusOnLoggerButton.doClick();
            }
        } else {
            this.logger.error((Object)("failed to lookup logger " + newLogger));
        }
    }

    private boolean isHiddenLogger(String loggerName) {
        Iterator iter = this.hiddenSet.iterator();
        while (iter.hasNext()) {
            String hiddenLoggerEntry = iter.next().toString();
            if (!loggerName.startsWith(hiddenLoggerEntry + ".") && !loggerName.endsWith(hiddenLoggerEntry)) continue;
            return true;
        }
        return false;
    }

    protected void toggleHiddenLogger(String logger) {
        if (!this.hiddenSet.contains(logger)) {
            this.hiddenSet.add(logger);
        } else {
            this.hiddenSet.remove(logger);
        }
        this.visibilityRuleDelegate.firePropertyChange("hiddenSet", null, null);
    }

    String getCurrentlySelectedLoggerName() {
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        TreePath firstPath = paths[0];
        return this.getLoggerName(firstPath);
    }

    String getLoggerName(TreePath path) {
        if (path != null) {
            Object[] objects = path.getPath();
            StringBuffer buf = new StringBuffer();
            for (int i = 1; i < objects.length; ++i) {
                buf.append(objects[i].toString());
                if (i >= objects.length - 1) continue;
                buf.append(".");
            }
            return buf.toString();
        }
        return null;
    }

    void ignore(Collection fqnLoggersToIgnore) {
        this.hiddenSet.addAll(fqnLoggersToIgnore);
        this.visibilityRuleDelegate.firePropertyChange("hiddenSet", null, null);
        this.fireChangeEvent();
    }

    boolean isFocusOnSelected() {
        return this.focusOnAction.getValue("checked") != null;
    }

    void setFocusOnSelected(boolean selected) {
        if (selected) {
            this.focusOnAction.putValue("checked", Boolean.TRUE);
        } else {
            this.focusOnAction.putValue("checked", null);
        }
    }

    private void collapseCurrentlySelectedNode() {
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        this.logger.debug((Object)"Collapsing all children of selected node");
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> enumeration = node.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
                if (child.getParent() == null || child == node) continue;
                Object[] nodes = ((DefaultMutableTreeNode)child.getParent()).getPath();
                TreePath treePath = new TreePath(nodes);
                this.logTree.collapsePath(treePath);
            }
        }
        this.ensureRootExpanded();
    }

    private void configureToolbarPanel() {
        this.toolbar.setFloatable(false);
        this.expandButton.setAction(this.expandAction);
        this.expandButton.setText(null);
        this.collapseButton.setAction(this.collapseAction);
        this.collapseButton.setText(null);
        this.focusOnLoggerButton.setAction(this.focusOnAction);
        this.focusOnLoggerButton.setText(null);
        this.ignoreLoggerButton.setAction(this.hideAction);
        this.ignoreLoggerButton.setText(null);
        this.expandButton.setFont(this.expandButton.getFont().deriveFont(1));
        this.collapseButton.setFont(this.collapseButton.getFont().deriveFont(1));
        this.editLoggerButton.setAction(this.editLoggerAction);
        this.editLoggerButton.setText(null);
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.toolbar.add(this.expandButton);
        this.toolbar.add(this.collapseButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.focusOnLoggerButton);
        this.toolbar.add(this.ignoreLoggerButton);
        this.toolbar.addSeparator();
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(this.closeButton);
        this.toolbar.add(Box.createHorizontalStrut(5));
    }

    private Action createClearIgnoreListAction() {
        AbstractAction action = new AbstractAction("Clear Ignore list", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(false);
                LoggerNameTreePanel.this.logTreeModel.reload();
                LoggerNameTreePanel.this.hiddenSet.clear();
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        };
        action.putValue("ShortDescription", "Removes all entries from the Ignore list so you can see their events in the view");
        return action;
    }

    private Action createCloseAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.preferenceModel.setLogTreePanelVisible(false);
            }
        };
        action.putValue("Name", "Close");
        action.putValue("ShortDescription", "Closes the Logger panel");
        action.putValue("SmallIcon", LineIconFactory.createCloseIcon());
        return action;
    }

    private Action createCollapseAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.collapseCurrentlySelectedNode();
            }
        };
        action.putValue("SmallIcon", LineIconFactory.createCollapseIcon());
        action.putValue("Name", "Collapse Branch");
        action.putValue("ShortDescription", "Collapses all the children of the currently selected node");
        action.setEnabled(false);
        return action;
    }

    private Action createEditLoggerAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        action.putValue("enabled", Boolean.FALSE);
        action.putValue("Name", "Edit filters/colors");
        action.putValue("ShortDescription", "Allows you to specify filters and coloring for this Logger");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_EDIT_RECEIVER));
        action.setEnabled(false);
        return action;
    }

    private Action createExpandAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.expandCurrentlySelectedNode();
            }
        };
        action.putValue("SmallIcon", LineIconFactory.createExpandIcon());
        action.putValue("Name", "Expand branch");
        action.putValue("ShortDescription", "Expands all the child nodes of the currently selected node, recursively");
        action.setEnabled(false);
        return action;
    }

    private Action createFindNextAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.findNextUsingCurrentlySelectedNode();
            }
        };
        action.putValue("Name", "Find next");
        action.putValue("ShortDescription", "Find using the selected node");
        action.setEnabled(false);
        return action;
    }

    private Action createSetRefineFocusAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.setRefineFocusUsingCurrentlySelectedNode();
            }
        };
        action.putValue("Name", "Set 'refine focus' to selected logger");
        action.putValue("ShortDescription", "Refine focus on the selected node");
        action.setEnabled(false);
        return action;
    }

    private Action createUpdateRefineFocusAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.updateRefineFocusUsingCurrentlySelectedNode();
            }
        };
        action.putValue("Name", "Update 'refine focus' to include selected logger");
        action.putValue("ShortDescription", "Add selected node to 'refine focus' field");
        action.setEnabled(false);
        return action;
    }

    private Action createUpdateFindAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.updateFindUsingCurrentlySelectedNode();
            }
        };
        action.putValue("Name", "Update 'find' to include selected logger");
        action.putValue("ShortDescription", "Add selected node to 'find' field");
        action.setEnabled(false);
        return action;
    }

    private void updateFindUsingCurrentlySelectedNode() {
        String selectedLogger = this.getCurrentlySelectedLoggerName();
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        String currentFindText = this.logPanel.getFindText();
        this.logPanel.setFindText(currentFindText + " || logger ~= " + selectedLogger);
    }

    private void updateRefineFocusUsingCurrentlySelectedNode() {
        String selectedLogger = this.getCurrentlySelectedLoggerName();
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        String currentFilterText = this.logPanel.getRefineFocusText();
        this.logPanel.setRefineFocusText(currentFilterText + " || logger ~= " + selectedLogger);
    }

    private void setRefineFocusUsingCurrentlySelectedNode() {
        String selectedLogger = this.getCurrentlySelectedLoggerName();
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        this.logPanel.setRefineFocusText("logger ~= " + selectedLogger);
    }

    private Action createDefineColorRuleForLoggerAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedLogger = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                TreePath[] paths = LoggerNameTreePanel.this.logTree.getSelectionPaths();
                if (paths == null) {
                    return;
                }
                Color c = JColorChooser.showDialog(LoggerNameTreePanel.this.getRootPane(), "Choose a color", Color.red);
                if (c != null) {
                    String expression = "logger like '^" + selectedLogger + ".*'";
                    LoggerNameTreePanel.this.colorizer.addRule("Default", new ColorRule(expression, ExpressionRule.getRule((String)expression), c, ChainsawConstants.COLOR_DEFAULT_FOREGROUND));
                }
            }
        };
        action.putValue("Name", "Define color rule for selected logger");
        action.putValue("ShortDescription", "Define color rule for logger");
        action.setEnabled(false);
        return action;
    }

    private Action createClearFindNextAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.clearFindNext();
            }
        };
        action.putValue("Name", "Clear find field");
        action.putValue("ShortDescription", "Clear the find field");
        action.setEnabled(false);
        return action;
    }

    private Action createClearRefineFocusAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.clearRefineFocus();
            }
        };
        action.putValue("Name", "Clear 'refine focus' field");
        action.putValue("ShortDescription", "Clear the refine focus field");
        action.setEnabled(false);
        return action;
    }

    private Action createFocusOnAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.toggleFocusOnState();
            }
        };
        action.putValue("Name", "Focus");
        action.putValue("ShortDescription", "Allows you to Focus on the selected logger by setting a filter that discards all but this Logger");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.WINDOW_ICON));
        action.setEnabled(false);
        return action;
    }

    private Action createIgnoreAllAction() {
        AbstractAction action = new AbstractAction("Ignore loggers below selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode root;
                TreePath[] paths = LoggerNameTreePanel.this.logTree.getSelectionPaths();
                String parentPathString = "";
                if (paths == null || paths.length == 0) {
                    root = (DefaultMutableTreeNode)LoggerNameTreePanel.this.logTreeModel.getRoot();
                } else {
                    root = (DefaultMutableTreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent();
                    TreeNode[] path = root.getPath();
                    for (int i = 1; i < path.length; ++i) {
                        if (i > 1) {
                            parentPathString = parentPathString + ".";
                        }
                        parentPathString = parentPathString + path[i].toString();
                    }
                    if (!parentPathString.equals("")) {
                        parentPathString = parentPathString + ".";
                    }
                }
                Enumeration<TreeNode> topLevelLoggersEnumeration = root.children();
                HashSet<String> topLevelLoggersSet = new HashSet<String>();
                while (topLevelLoggersEnumeration.hasMoreElements()) {
                    String thisLogger = topLevelLoggersEnumeration.nextElement().toString();
                    topLevelLoggersSet.add(parentPathString + thisLogger);
                }
                if (topLevelLoggersSet.size() > 0) {
                    LoggerNameTreePanel.this.ignore(topLevelLoggersSet);
                }
                LoggerNameTreePanel.this.logTreeModel.nodeChanged(root);
                LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(false);
                LoggerNameTreePanel.this.focusOnAction.setEnabled(false);
                ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.hideCheck.setSelected(false);
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        };
        action.putValue("ShortDescription", "Adds all loggers to your Ignore list (unhide loggers you want to see in the view)");
        return action;
    }

    private Action createIgnoreAction() {
        AbstractAction action = new AbstractAction("Ignore this Logger", new ImageIcon(ChainsawIcons.ICON_COLLAPSE)){

            @Override
            public void actionPerformed(ActionEvent e) {
                String logger = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                if (logger != null) {
                    LoggerNameTreePanel.this.toggleHiddenLogger(logger);
                    LoggerNameTreePanel.this.logTreeModel.nodeChanged((TreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent());
                    LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(LoggerNameTreePanel.this.hiddenSet.contains(logger));
                    LoggerNameTreePanel.this.focusOnAction.setEnabled(!LoggerNameTreePanel.this.hiddenSet.contains(logger));
                    ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.hideCheck.setSelected(LoggerNameTreePanel.this.hiddenSet.contains(logger));
                }
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        };
        action.putValue("ShortDescription", "Adds the selected Logger to your Ignore list, filtering those events from view");
        return action;
    }

    private void ensureRootExpanded() {
        this.logger.debug((Object)"Ensuring Root node is expanded.");
        final DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.logTreeModel.getRoot();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoggerNameTreePanel.this.logTree.expandPath(new TreePath(root));
            }
        });
    }

    private void findNextUsingCurrentlySelectedNode() {
        String selectedLogger = this.getCurrentlySelectedLoggerName();
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        this.logPanel.setFindText("logger like '^" + selectedLogger + ".*'");
    }

    private void clearFindNext() {
        this.logPanel.setFindText("");
    }

    private void clearRefineFocus() {
        this.logPanel.setRefineFocusText("");
    }

    private void expandCurrentlySelectedNode() {
        TreePath path;
        DefaultMutableTreeNode treeNode;
        Enumeration<TreeNode> depthEnum;
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        this.logger.debug((Object)"Expanding all children of selected node");
        for (int i = 0; i < paths.length && (depthEnum = (treeNode = (DefaultMutableTreeNode)(path = paths[i]).getLastPathComponent()).depthFirstEnumeration()).hasMoreElements(); ++i) {
            ArrayList<Integer> depths = new ArrayList<Integer>();
            while (depthEnum.hasMoreElements()) {
                depths.add(new Integer(((DefaultMutableTreeNode)depthEnum.nextElement()).getDepth()));
            }
            Collections.sort(depths);
            Collections.reverse(depths);
            int maxDepth = (Integer)depths.get(0);
            if (maxDepth > 4) {
                this.logger.warn((Object)("Should warn user, depth=" + maxDepth));
            }
            depthEnum = treeNode.depthFirstEnumeration();
            while (depthEnum.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)depthEnum.nextElement();
                if (!node.isLeaf() || node.getParent() == null) continue;
                Object[] nodes = ((DefaultMutableTreeNode)node.getParent()).getPath();
                TreePath treePath = new TreePath(nodes);
                this.logger.debug((Object)("Expanding path:" + treePath));
                this.logTree.expandPath(treePath);
            }
        }
    }

    private void fireChangeEvent() {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        ChangeEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ChangeEvent(this);
            }
            listeners[i].stateChanged(e);
        }
    }

    private void reconfigureMenuText() {
        String logger = this.getCurrentlySelectedLoggerName();
        if (logger == null || logger.length() == 0) {
            this.focusOnAction.putValue("Name", "Focus On...");
            this.hideAction.putValue("Name", "Ignore...");
            this.findAction.putValue("Name", "Find...");
            this.setRefineFocusAction.putValue("Name", "Set refine focus field");
            this.updateRefineFocusAction.putValue("Name", "Add to refine focus field");
            this.updateFindAction.putValue("Name", "Add to find field");
            this.defineColorRuleForLoggerAction.putValue("Name", "Define color rule");
        } else {
            this.focusOnAction.putValue("Name", "Focus On '" + logger + "'");
            this.hideAction.putValue("Name", "Ignore '" + logger + "'");
            this.findAction.putValue("Name", "Find '" + logger + "'");
            this.setRefineFocusAction.putValue("Name", "Set refine focus field to '" + logger + "'");
            this.updateRefineFocusAction.putValue("Name", "Add '" + logger + "' to 'refine focus' field");
            this.updateFindAction.putValue("Name", "Add '" + logger + "' to 'find' field");
            this.defineColorRuleForLoggerAction.putValue("Name", "Define color rule for '" + logger + "'");
        }
        this.hideSubLoggersAction.putValue("Name", "Ignore loggers below selection");
        this.focusOnLoggerButton.setText(null);
        this.ignoreLoggerButton.setText(null);
    }

    private void setupListeners() {
        this.logTree.addMouseMotionListener(new MouseKeyIconListener());
        this.logTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                TreeNode node = null;
                if (path != null) {
                    node = (TreeNode)path.getLastPathComponent();
                }
                boolean focusOnSelected = LoggerNameTreePanel.this.isFocusOnSelected();
                LoggerNameTreePanel.this.currentlySelectedLoggerName = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                LoggerNameTreePanel.this.focusOnAction.setEnabled(path != null && node != null && node.getParent() != null && !LoggerNameTreePanel.this.hiddenSet.contains(LoggerNameTreePanel.this.currentlySelectedLoggerName));
                LoggerNameTreePanel.this.hideAction.setEnabled(path != null && node != null && node.getParent() != null);
                if (!LoggerNameTreePanel.this.focusOnAction.isEnabled()) {
                    LoggerNameTreePanel.this.setFocusOnSelected(false);
                }
                LoggerNameTreePanel.this.expandAction.setEnabled(path != null);
                LoggerNameTreePanel.this.findAction.setEnabled(path != null);
                LoggerNameTreePanel.this.clearFindNextAction.setEnabled(true);
                LoggerNameTreePanel.this.defineColorRuleForLoggerAction.setEnabled(path != null);
                LoggerNameTreePanel.this.setRefineFocusAction.setEnabled(path != null);
                LoggerNameTreePanel.this.updateRefineFocusAction.setEnabled(path != null);
                LoggerNameTreePanel.this.updateFindAction.setEnabled(path != null);
                LoggerNameTreePanel.this.clearRefineFocusAction.setEnabled(true);
                if (LoggerNameTreePanel.this.currentlySelectedLoggerName != null) {
                    boolean isHidden = LoggerNameTreePanel.this.hiddenSet.contains(LoggerNameTreePanel.this.currentlySelectedLoggerName);
                    ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.hideCheck.setSelected(isHidden);
                    LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(isHidden);
                }
                LoggerNameTreePanel.this.collapseAction.setEnabled(path != null);
                LoggerNameTreePanel.this.reconfigureMenuText();
                if (LoggerNameTreePanel.this.isFocusOnSelected()) {
                    LoggerNameTreePanel.this.fireChangeEvent();
                }
                if (focusOnSelected && !LoggerNameTreePanel.this.isFocusOnSelected()) {
                    LoggerNameTreePanel.this.fireChangeEvent();
                }
                LoggerNameTreePanel.this.logPanel.repaint();
            }
        });
        this.logTree.addMouseListener(this.popupListener);
        this.focusOnAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.focusOnCheck.setSelected(LoggerNameTreePanel.this.isFocusOnSelected());
                LoggerNameTreePanel.this.focusOnLoggerButton.setSelected(LoggerNameTreePanel.this.isFocusOnSelected());
                if (LoggerNameTreePanel.this.logTree.getSelectionPath() != null) {
                    LoggerNameTreePanel.this.logTreeModel.nodeChanged((TreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent());
                }
            }
        });
        this.hideAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (LoggerNameTreePanel.this.logTree.getSelectionPath() != null) {
                    LoggerNameTreePanel.this.logTreeModel.nodeChanged((TreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent());
                }
            }
        });
        this.logTree.addMouseListener(new MouseFocusOnListener());
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LoggerNameTreePanel.this.visibilityRuleDelegate.firePropertyChange("rule", null, null);
                LoggerNameTreePanel.this.updateDisplay();
            }
        });
        this.visibilityRuleDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("hiddenSet")) {
                    LoggerNameTreePanel.this.updateDisplay();
                }
            }
        });
    }

    private void updateDisplay() {
        this.updateHiddenSetModels();
        this.updateIgnoreSummary();
        this.updateIgnoreExpressionSummary();
        this.updateAlwaysDisplayExpressionSummary();
    }

    private void updateHiddenSetModels() {
        DefaultListModel model = (DefaultListModel)this.ignoreList.getModel();
        model.clear();
        ArrayList sortedIgnoreList = new ArrayList(this.hiddenSet);
        Collections.sort(sortedIgnoreList);
        for (String string : sortedIgnoreList) {
            model.addElement(string);
        }
    }

    private void updateIgnoreSummary() {
        this.ignoreSummary.setText(this.ignoreList.getModel().getSize() + " hidden loggers");
    }

    private void updateIgnoreExpressionSummary() {
        this.ignoreExpressionSummary.setText(this.ignoreExpressionRule != null ? "Ignore (set)" : "Ignore (unset)");
    }

    private void updateAlwaysDisplayExpressionSummary() {
        this.alwaysDisplayExpressionSummary.setText(this.alwaysDisplayExpressionRule != null ? "Always displayed (set)" : "Always displayed (unset)");
    }

    private void toggleFocusOnState() {
        this.setFocusOnSelected(!this.isFocusOnSelected());
        this.fireChangeEvent();
    }

    public Collection getHiddenSet() {
        return Collections.unmodifiableSet(this.hiddenSet);
    }

    public String getHiddenExpression() {
        String text = this.ignoreExpressionEntryField.getText();
        if (text == null || text.trim().equals("")) {
            return null;
        }
        return text.trim();
    }

    public void setHiddenExpression(String hiddenExpression) {
        this.ignoreExpressionEntryField.setText(hiddenExpression);
        this.updateIgnoreExpression(hiddenExpression);
    }

    public String getAlwaysDisplayExpression() {
        String text = this.alwaysDisplayExpressionEntryField.getText();
        if (text == null || text.trim().equals("")) {
            return null;
        }
        return text.trim();
    }

    public void setAlwaysDisplayExpression(String alwaysDisplayExpression) {
        this.alwaysDisplayExpressionEntryField.setText(alwaysDisplayExpression);
        this.updateAlwaysDisplayExpression(alwaysDisplayExpression);
    }

    @Override
    public void loggerNameAdded(String loggerName) {
    }

    @Override
    public void reset() {
        this.expandRootLatch = false;
        final String logger = this.currentlySelectedLoggerName;
        boolean focusOnSelected = this.isFocusOnSelected();
        if (logger == null || !focusOnSelected) {
            return;
        }
        this.logTreeModel.loggerNameAdded(logger);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoggerNameTreePanel.this.setFocusOn(logger);
            }
        });
    }

    class VisibilityRuleDelegate
    extends AbstractRule {
        VisibilityRuleDelegate() {
        }

        public boolean evaluate(LoggingEvent e, Map matches) {
            boolean result;
            boolean hidden;
            String currentlySelectedLoggerName = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
            boolean hiddenLogger = e.getLoggerName() != null && LoggerNameTreePanel.this.isHiddenLogger(e.getLoggerName());
            boolean hiddenExpression = LoggerNameTreePanel.this.ignoreExpressionRule != null && LoggerNameTreePanel.this.ignoreExpressionRule.evaluate(e, null);
            boolean alwaysDisplayExpression = LoggerNameTreePanel.this.alwaysDisplayExpressionRule != null && LoggerNameTreePanel.this.alwaysDisplayExpressionRule.evaluate(e, null);
            boolean bl = hidden = !alwaysDisplayExpression && (hiddenLogger || hiddenExpression);
            if (currentlySelectedLoggerName == null) {
                return !hidden;
            }
            boolean bl2 = result = e.getLoggerName() != null && !hidden;
            if (result && LoggerNameTreePanel.this.isFocusOnSelected()) {
                result = e.getLoggerName() != null && (e.getLoggerName().startsWith(currentlySelectedLoggerName + ".") || e.getLoggerName().endsWith(currentlySelectedLoggerName));
            }
            return result;
        }

        public void firePropertyChange(String propertyName, Object oldVal, Object newVal) {
            super.firePropertyChange(propertyName, oldVal, newVal);
        }
    }

    private final class MouseKeyIconListener
    extends MouseMotionAdapter
    implements MouseMotionListener {
        Cursor focusOnCursor = Toolkit.getDefaultToolkit().createCustomCursor(ChainsawIcons.FOCUS_ON_ICON.getImage(), new Point(10, 10), "");
        Cursor ignoreCursor = Toolkit.getDefaultToolkit().createCustomCursor(ChainsawIcons.IGNORE_ICON.getImage(), new Point(10, 10), "");

        private MouseKeyIconListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if ((e.getModifiers() & 2) > 0 && (e.getModifiers() & 1) > 0) {
                LoggerNameTreePanel.this.logTree.setCursor(this.ignoreCursor);
            } else if ((e.getModifiers() & 2) > 0) {
                LoggerNameTreePanel.this.logTree.setCursor(this.focusOnCursor);
            } else {
                LoggerNameTreePanel.this.logTree.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private final class MouseFocusOnListener
    extends MouseAdapter {
        private MouseFocusOnListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && (e.getModifiers() & 2) > 0 && (e.getModifiers() & 1) > 0) {
                this.ignoreLoggerAtPoint(e.getPoint());
                e.consume();
                LoggerNameTreePanel.this.fireChangeEvent();
            } else if (e.getClickCount() > 1 && (e.getModifiers() & 2) > 0) {
                this.focusAnLoggerAtPoint(e.getPoint());
                e.consume();
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        }

        private void focusAnLoggerAtPoint(Point point) {
            String logger = this.getLoggerAtPoint(point);
            if (logger != null) {
                LoggerNameTreePanel.this.toggleFocusOnState();
            }
        }

        private String getLoggerAtPoint(Point point) {
            TreePath path = LoggerNameTreePanel.this.logTree.getPathForLocation(point.x, point.y);
            if (path != null) {
                return LoggerNameTreePanel.this.getLoggerName(path);
            }
            return null;
        }

        private void ignoreLoggerAtPoint(Point point) {
            String logger = this.getLoggerAtPoint(point);
            if (logger != null) {
                LoggerNameTreePanel.this.toggleHiddenLogger(logger);
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        }
    }

    private class LoggerTreePopupMenu
    extends JPopupMenu {
        JCheckBoxMenuItem focusOnCheck = new JCheckBoxMenuItem();
        JCheckBoxMenuItem hideCheck = new JCheckBoxMenuItem();

        private LoggerTreePopupMenu() {
            this.initMenu();
        }

        @Override
        public void show(Component invoker, int x, int y) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)LoggerNameTreePanel.this.logTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            super.show(invoker, x, y);
        }

        private void initMenu() {
            this.focusOnCheck.setAction(LoggerNameTreePanel.this.focusOnAction);
            this.hideCheck.setAction(LoggerNameTreePanel.this.hideAction);
            this.add(LoggerNameTreePanel.this.expandAction);
            this.add(LoggerNameTreePanel.this.collapseAction);
            this.addSeparator();
            this.add(this.focusOnCheck);
            this.add(this.hideCheck);
            this.addSeparator();
            this.add(LoggerNameTreePanel.this.setRefineFocusAction);
            this.add(LoggerNameTreePanel.this.updateRefineFocusAction);
            this.add(LoggerNameTreePanel.this.clearRefineFocusAction);
            this.addSeparator();
            this.add(LoggerNameTreePanel.this.findAction);
            this.add(LoggerNameTreePanel.this.updateFindAction);
            this.add(LoggerNameTreePanel.this.clearFindNextAction);
            this.addSeparator();
            this.add(LoggerNameTreePanel.this.defineColorRuleForLoggerAction);
            this.addSeparator();
            this.add(LoggerNameTreePanel.this.hideSubLoggersAction);
            this.add(LoggerNameTreePanel.this.clearIgnoreListAction);
        }
    }

    private class LoggerNameTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private LoggerNameTreeCellRenderer() {
            this.setLeafIcon(null);
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            Font font2;
            JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            Font originalFont = new Font(component.getFont().getName(), component.getFont().getStyle(), component.getFont().getSize());
            int style = 0;
            if (sel && LoggerNameTreePanel.this.focusOnLoggerButton.isSelected()) {
                style |= 1;
            }
            String logger = LoggerNameTreePanel.this.getLoggerName(new TreePath(((DefaultMutableTreeNode)value).getPath()));
            if (LoggerNameTreePanel.this.hiddenSet.contains(logger)) {
                style |= 2;
            }
            if (originalFont != null && (font2 = originalFont.deriveFont(style)) != null) {
                component.setFont(font2);
            }
            return component;
        }
    }
}

