/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.UIManager;
import org.apache.log4j.chainsaw.ChainsawConstants;

public class ApplicationPreferenceModel {
    private boolean showNoReceiverWarning = true;
    private boolean statusBar = true;
    private boolean toolbar = true;
    private boolean receivers = false;
    private boolean confirmExit = true;
    private boolean showSplash = true;
    private String lookAndFeelClassName = "";
    private int toolTipDisplayMillis = 4000;
    private int cyclicBufferSize = 50000;
    private String lastUsedVersion = "";
    private int responsiveness = 3;
    private Color searchBackgroundColor = ChainsawConstants.FIND_LOGGER_BACKGROUND;
    private Color searchForegroundColor = ChainsawConstants.FIND_LOGGER_FOREGROUND;
    private Color alternatingColorForegroundColor = ChainsawConstants.COLOR_ODD_ROW_FOREGROUND;
    private Color alternatingColorBackgroundColor = ChainsawConstants.COLOR_ODD_ROW_BACKGROUND;
    private String identifierExpression = "PROP.hostname - PROP.application";
    private final transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private int tabPlacement = 3;
    private Vector<String> configurationURLs = new Vector();
    private String configurationURL = "";
    private transient String bypassConfigurationURL = null;
    private boolean okToRemoveSecurityManager = false;
    private static final int CONFIGURATION_URL_ENTRY_COUNT = 10;
    private List defaultColumnNames = new ArrayList();
    private boolean defaultColumnsSet;
    private boolean bypassSearchColors = false;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    private void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean hasListeners(String propertyName) {
        return this.propertySupport.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public final boolean isShowNoReceiverWarning() {
        return this.showNoReceiverWarning;
    }

    public final String getIdentifierExpression() {
        return this.identifierExpression;
    }

    public final void setCyclicBufferSize(int newCyclicBufferSize) {
        int oldCyclicBufferSize = this.cyclicBufferSize;
        this.cyclicBufferSize = newCyclicBufferSize;
        this.firePropertyChange("cyclicBufferSize", oldCyclicBufferSize, newCyclicBufferSize);
    }

    public final int getCyclicBufferSize() {
        return this.cyclicBufferSize;
    }

    public final void setToolTipDisplayMillis(int newToolTipDisplayMillis) {
        int oldToolTipDisplayMillis = this.toolTipDisplayMillis;
        this.toolTipDisplayMillis = newToolTipDisplayMillis;
        this.firePropertyChange("toolTipDisplayMillis", oldToolTipDisplayMillis, newToolTipDisplayMillis);
    }

    public final int getToolTipDisplayMillis() {
        return this.toolTipDisplayMillis;
    }

    public final void setIdentifierExpression(String newIdentifierExpression) {
        String oldIdentifierExpression = this.identifierExpression;
        this.identifierExpression = newIdentifierExpression;
        this.firePropertyChange("identifierExpression", oldIdentifierExpression, newIdentifierExpression);
    }

    public final void setShowNoReceiverWarning(boolean newShowNoReceiverWarning) {
        boolean oldShowNoReceiverWarning = this.showNoReceiverWarning;
        this.showNoReceiverWarning = newShowNoReceiverWarning;
        this.firePropertyChange("showNoReceiverWarning", oldShowNoReceiverWarning, newShowNoReceiverWarning);
    }

    public void apply(ApplicationPreferenceModel model) {
        this.setIdentifierExpression(model.getIdentifierExpression());
        this.setShowNoReceiverWarning(model.isShowNoReceiverWarning() || model.getConfigurationURL() == null || model.getConfigurationURL().trim().equals(""));
        this.setResponsiveness(model.getResponsiveness());
        this.setTabPlacement(model.getTabPlacement());
        this.setStatusBar(model.isStatusBar());
        this.setToolbar(model.isToolbar());
        this.setReceivers(model.isReceivers());
        if (model.getLookAndFeelClassName() != null && !model.getLookAndFeelClassName().trim().equals("")) {
            this.setLookAndFeelClassName(model.getLookAndFeelClassName());
        } else {
            this.setLookAndFeelClassName(UIManager.getLookAndFeel().getClass().getName());
        }
        this.setConfirmExit(model.isConfirmExit());
        this.setShowSplash(model.isShowSplash());
        this.setToolTipDisplayMillis(model.getToolTipDisplayMillis());
        this.setCyclicBufferSize(model.getCyclicBufferSize());
        Vector<String> configurationURLs = model.getConfigurationURLs();
        if (configurationURLs != null) {
            this.setConfigurationURLs(configurationURLs);
        }
        if (model.getBypassConfigurationURL() == null) {
            this.setConfigurationURL(model.getConfigurationURL());
        }
        this.setLastUsedVersion(model.getLastUsedVersion());
        this.setOkToRemoveSecurityManager(model.isOkToRemoveSecurityManager());
        Color searchForeground = model.getSearchForegroundColor();
        Color searchBackground = model.getSearchBackgroundColor();
        if (searchForeground != null && searchBackground != null) {
            this.setSearchBackgroundColor(searchBackground);
            this.setSearchForegroundColor(searchForeground);
        }
        Color alternatingForeground = model.getAlternatingColorForegroundColor();
        Color alternatingBackground = model.getAlternatingColorBackgroundColor();
        if (alternatingForeground != null && alternatingBackground != null) {
            this.setAlternatingBackgroundColor(alternatingBackground);
            this.setAlternatingForegroundColor(alternatingForeground);
        }
        if (model.isDefaultColumnsSet()) {
            this.setDefaultColumnNames(model.getDefaultColumnNames());
        }
        this.setBypassSearchColors(model.isBypassSearchColors());
    }

    public Color getDeltaColor() {
        float factor = 1.3f;
        Color search = this.getSearchBackgroundColor();
        return new Color(this.boundColorValue((int)((float)search.getRed() * factor)), this.boundColorValue((int)((float)search.getGreen() * factor)), this.boundColorValue((int)((float)search.getBlue() * factor)));
    }

    private int boundColorValue(int colorValue) {
        return Math.min(Math.max(0, colorValue), 255);
    }

    public final int getResponsiveness() {
        return this.responsiveness;
    }

    public final void setResponsiveness(int newValue) {
        int oldvalue = this.responsiveness;
        this.responsiveness = newValue >= 1000 ? (newValue - 750) / 1000 : newValue;
        this.firePropertyChange("responsiveness", oldvalue, this.responsiveness);
    }

    public void setTabPlacement(int i) {
        int oldValue = this.tabPlacement;
        this.tabPlacement = i;
        this.firePropertyChange("tabPlacement", oldValue, this.tabPlacement);
    }

    public final int getTabPlacement() {
        return this.tabPlacement;
    }

    public final boolean isStatusBar() {
        return this.statusBar;
    }

    public Vector<String> getConfigurationURLs() {
        return this.configurationURLs;
    }

    public void setConfigurationURLs(Vector<String> urls) {
        if (urls != null) {
            this.configurationURLs = urls;
        }
    }

    public final void setStatusBar(boolean statusBar) {
        boolean oldValue = this.statusBar;
        this.statusBar = statusBar;
        this.firePropertyChange("statusBar", oldValue, this.statusBar);
    }

    public void setAlternatingForegroundColor(Color alternatingColorForegroundColor) {
        this.alternatingColorForegroundColor = alternatingColorForegroundColor;
        this.firePropertyChange("alternatingColor", true, false);
    }

    public void setAlternatingBackgroundColor(Color alternatingColorBackgroundColor) {
        this.alternatingColorBackgroundColor = alternatingColorBackgroundColor;
        this.firePropertyChange("alternatingColor", true, false);
    }

    public void setSearchForegroundColor(Color searchForegroundColor) {
        this.searchForegroundColor = searchForegroundColor;
        this.firePropertyChange("searchColor", true, false);
    }

    public void setSearchBackgroundColor(Color searchBackgroundColor) {
        this.searchBackgroundColor = searchBackgroundColor;
        this.firePropertyChange("searchColor", true, false);
    }

    public Color getAlternatingColorBackgroundColor() {
        return this.alternatingColorBackgroundColor;
    }

    public Color getAlternatingColorForegroundColor() {
        return this.alternatingColorForegroundColor;
    }

    public Color getSearchBackgroundColor() {
        return this.searchBackgroundColor;
    }

    public Color getSearchForegroundColor() {
        return this.searchForegroundColor;
    }

    public final boolean isReceivers() {
        return this.receivers;
    }

    public final void setReceivers(boolean receivers) {
        boolean oldValue = this.receivers;
        this.receivers = receivers;
        this.firePropertyChange("receivers", oldValue, this.receivers);
    }

    public final boolean isToolbar() {
        return this.toolbar;
    }

    public final void setToolbar(boolean toolbar) {
        boolean oldValue = this.toolbar;
        this.toolbar = toolbar;
        this.firePropertyChange("toolbar", oldValue, this.toolbar);
    }

    public final String getLookAndFeelClassName() {
        return this.lookAndFeelClassName;
    }

    public final void setLookAndFeelClassName(String lookAndFeelClassName) {
        String oldValue = this.lookAndFeelClassName;
        this.lookAndFeelClassName = lookAndFeelClassName;
        this.firePropertyChange("lookAndFeelClassName", oldValue, this.lookAndFeelClassName);
    }

    public final boolean isConfirmExit() {
        return this.confirmExit;
    }

    public final void setConfirmExit(boolean confirmExit) {
        boolean oldValue = this.confirmExit;
        this.confirmExit = confirmExit;
        this.firePropertyChange("confirmExit", oldValue, this.confirmExit);
    }

    public final boolean isShowSplash() {
        return this.showSplash;
    }

    public final void setShowSplash(boolean showSplash) {
        boolean oldValue = this.showSplash;
        this.showSplash = showSplash;
        this.firePropertyChange("showSplash", oldValue, this.showSplash);
    }

    public final String getConfigurationURL() {
        return this.configurationURL;
    }

    public final String getBypassConfigurationURL() {
        return this.bypassConfigurationURL;
    }

    public void setBypassConfigurationURL(String bypassConfigurationURL) {
        if (bypassConfigurationURL != null && bypassConfigurationURL.trim().equals("")) {
            this.bypassConfigurationURL = null;
        }
        this.bypassConfigurationURL = bypassConfigurationURL;
    }

    public final void setConfigurationURL(String configurationURL) {
        String oldValue = this.bypassConfigurationURL != null ? this.bypassConfigurationURL : this.configurationURL;
        this.bypassConfigurationURL = null;
        if (configurationURL == null || configurationURL.trim().equals("")) {
            this.configurationURL = "";
            this.firePropertyChange("configurationURL", oldValue, this.configurationURL);
            return;
        }
        if (!this.configurationURLs.contains(configurationURL)) {
            if (this.configurationURLs.size() == 10) {
                this.configurationURLs.remove(9);
            }
            this.configurationURLs.add(0, configurationURL);
        }
        this.configurationURL = configurationURL;
        this.firePropertyChange("configurationURL", oldValue, this.configurationURL);
    }

    public final String getLastUsedVersion() {
        return this.lastUsedVersion;
    }

    public final void setLastUsedVersion(String lastUsedVersion) {
        String oldValue = this.lastUsedVersion;
        this.lastUsedVersion = lastUsedVersion;
        this.firePropertyChange("lastUsedVersion", oldValue, this.lastUsedVersion);
    }

    public final boolean isOkToRemoveSecurityManager() {
        return this.okToRemoveSecurityManager;
    }

    public final void setOkToRemoveSecurityManager(boolean okToRemoveSecurityManager) {
        boolean oldValue = this.okToRemoveSecurityManager;
        this.okToRemoveSecurityManager = okToRemoveSecurityManager;
        this.firePropertyChange("okToRemoveSecurityManager", oldValue, this.okToRemoveSecurityManager);
    }

    public void setDefaultColumnNames(List defaultColumnNames) {
        this.defaultColumnsSet = true;
        this.defaultColumnNames.clear();
        this.defaultColumnNames.addAll(defaultColumnNames);
    }

    public boolean isDefaultColumnsSet() {
        return this.defaultColumnsSet;
    }

    public List getDefaultColumnNames() {
        return this.defaultColumnNames;
    }

    public void setBypassSearchColors(boolean bypassSearchColors) {
        this.bypassSearchColors = bypassSearchColors;
    }

    public boolean isBypassSearchColors() {
        return this.bypassSearchColors;
    }
}

