/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.apache.log4j.chainsaw.LoggerNameListener;
import org.apache.log4j.chainsaw.LoggerNameModel;

public class LoggerNameModelSupport
implements LoggerNameModel {
    private Set<String> loggerNameSet = new HashSet<String>();
    private EventListenerList listenerList = new EventListenerList();

    @Override
    public Collection getLoggerNames() {
        return Collections.unmodifiableSet(this.loggerNameSet);
    }

    @Override
    public boolean addLoggerName(String loggerName) {
        boolean isNew = this.loggerNameSet.add(loggerName);
        if (isNew) {
            this.notifyListeners(loggerName);
        }
        return isNew;
    }

    @Override
    public void reset() {
        LoggerNameListener[] eventListeners;
        this.loggerNameSet.clear();
        for (LoggerNameListener listener : eventListeners = (LoggerNameListener[])this.listenerList.getListeners(LoggerNameListener.class)) {
            listener.reset();
        }
    }

    private void notifyListeners(String loggerName) {
        LoggerNameListener[] eventListeners;
        for (LoggerNameListener listener : eventListeners = (LoggerNameListener[])this.listenerList.getListeners(LoggerNameListener.class)) {
            listener.loggerNameAdded(loggerName);
        }
    }

    @Override
    public void addLoggerNameListener(LoggerNameListener l) {
        this.listenerList.add(LoggerNameListener.class, l);
    }

    @Override
    public void removeLoggerNameListener(LoggerNameListener l) {
        this.listenerList.remove(LoggerNameListener.class, l);
    }
}

