/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.service;

import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.jpa.dao.AttributeRepository;
import org.apache.logging.log4j.catalog.jpa.model.AttributeModel;
import org.apache.logging.log4j.catalog.jpa.service.AbstractPagingAndSortingService;
import org.apache.logging.log4j.catalog.jpa.service.AttributeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Repository
@Transactional
public class AttributeServiceImpl
extends AbstractPagingAndSortingService
implements AttributeService {
    private static final Logger LOGGER = LogManager.getLogger();
    @Autowired
    private AttributeRepository attributeRepository;

    @Override
    public List<AttributeModel> getAttributes() {
        return this.attributeRepository.findAll();
    }

    @Override
    public List<AttributeModel> getAttributes(String catalogId) {
        return this.attributeRepository.findByCatalogId(catalogId);
    }

    @Override
    public List<AttributeModel> getAttributes(int startPage, int itemsPerPage, String sortColumn, String direction) {
        Pageable pageable = this.createPageRequest(startPage, itemsPerPage, sortColumn, direction);
        Page page = this.attributeRepository.findAll(pageable);
        return page.getContent();
    }

    @Override
    public List<AttributeModel> getAttributes(String catalogId, int startPage, int itemsPerPage, String sortColumn, String direction) {
        Pageable pageable = this.createPageRequest(startPage, itemsPerPage, sortColumn, direction);
        Page page = this.attributeRepository.findByCatalogId(catalogId, pageable);
        return page.getContent();
    }

    @Override
    public Optional<AttributeModel> getAttribute(String catalogId, String attributeName) {
        return this.attributeRepository.findByCatalogIdAndName(catalogId, attributeName);
    }

    @Override
    public Optional<AttributeModel> getAttribute(Long attributeId) {
        return this.attributeRepository.findOne(attributeId);
    }

    @Override
    public AttributeModel saveAttribute(AttributeModel attribute) {
        return this.attributeRepository.save(attribute);
    }

    @Override
    public void deleteAttribute(Long attributeId) {
        this.attributeRepository.deleteById(attributeId);
    }
}

