/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.async.logger.AsyncLoggerDisruptor;
import org.apache.logging.log4j.async.logger.RingBufferLogEventTranslator;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.ReusableLogEvent;
import org.apache.logging.log4j.core.async.AsyncQueueFullMessageUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.time.Clock;
import org.apache.logging.log4j.core.time.NanoClock;
import org.apache.logging.log4j.kit.logger.AbstractLogger;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.kit.recycler.RecyclerFactory;
import org.apache.logging.log4j.message.FlowMessageFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Named;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class AsyncLogger
extends org.apache.logging.log4j.core.Logger {
    private final Clock clock;
    private final ContextDataInjector contextDataInjector;
    private final Recycler<RingBufferLogEventTranslator> translatorRecycler;
    private final AsyncLoggerDisruptor loggerDisruptor;
    private volatile boolean includeLocation;
    private volatile NanoClock nanoClock;

    AsyncLogger(LoggerContext context, String name, MessageFactory messageFactory, FlowMessageFactory flowMessageFactory, RecyclerFactory recyclerFactory, Logger statusLogger, AsyncLoggerDisruptor loggerDisruptor) {
        super(context, name, messageFactory, flowMessageFactory, recyclerFactory, statusLogger);
        Configuration configuration = context.getConfiguration();
        this.translatorRecycler = configuration.getRecyclerFactory().create(RingBufferLogEventTranslator::new, RingBufferLogEventTranslator::clear);
        this.loggerDisruptor = loggerDisruptor;
        this.includeLocation = this.privateConfig.loggerConfig.isIncludeLocation();
        this.nanoClock = configuration.getNanoClock();
        this.clock = (Clock)configuration.getComponent(Clock.KEY);
        this.contextDataInjector = (ContextDataInjector)configuration.getComponent(ContextDataInjector.KEY);
    }

    protected void updateConfiguration(Configuration newConfig) {
        this.nanoClock = newConfig.getNanoClock();
        this.includeLocation = newConfig.getLoggerConfig(this.getName()).isIncludeLocation();
        super.updateConfiguration(newConfig);
    }

    NanoClock getNanoClock() {
        return this.nanoClock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLog(String fqcn, @Nullable StackTraceElement location, Level level, @Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        RingBufferLogEventTranslator translator = (RingBufferLogEventTranslator)this.translatorRecycler.acquire();
        try {
            this.initTranslator(translator, fqcn, location, level, marker, message, throwable);
            translator.updateThreadValues();
            this.publish(translator);
        }
        finally {
            this.translatorRecycler.release((Object)translator);
        }
    }

    private void publish(RingBufferLogEventTranslator translator) {
        if (!this.loggerDisruptor.tryPublish(translator)) {
            this.handleRingBufferFull(translator);
        }
    }

    private void handleRingBufferFull(RingBufferLogEventTranslator translator) {
        if (AbstractLogger.getRecursionDepth() > 1) {
            AsyncQueueFullMessageUtil.logWarningToStatusLogger();
            this.logMessageInCurrentThread(translator.fqcn, translator.level, translator.marker, translator.message, translator.thrown);
            translator.clear();
            return;
        }
        EventRoute eventRoute = this.loggerDisruptor.getEventRoute(translator.level);
        switch (eventRoute) {
            case ENQUEUE: {
                this.loggerDisruptor.enqueueLogMessageWhenQueueFull(translator);
                break;
            }
            case SYNCHRONOUS: {
                this.logMessageInCurrentThread(translator.fqcn, translator.level, translator.marker, translator.message, translator.thrown);
                translator.clear();
                break;
            }
            case DISCARD: {
                translator.clear();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown EventRoute " + eventRoute);
            }
        }
    }

    private void initTranslator(RingBufferLogEventTranslator translator, String fqcn, @Nullable StackTraceElement location, Level level, @Nullable Marker marker, @Nullable Message message, @Nullable Throwable thrown) {
        translator.setBasicValues(this, this.getName(), marker, fqcn, level, message, thrown, ThreadContext.getImmutableStack(), location, this.clock, this.nanoClock, this.contextDataInjector, this.requiresLocation());
    }

    void logMessageInCurrentThread(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        ReliabilityStrategy strategy = this.privateConfig.loggerConfig.getReliabilityStrategy();
        strategy.log((Supplier)this, this.getName(), fqcn, marker, level, message, thrown);
    }

    public void actualAsyncLog(ReusableLogEvent event) {
        LoggerConfig privateConfigLoggerConfig = this.privateConfig.loggerConfig;
        List properties = privateConfigLoggerConfig.getPropertyList();
        if (properties != null) {
            this.onPropertiesPresent(event, properties);
        }
        privateConfigLoggerConfig.getReliabilityStrategy().log((Supplier)this, (LogEvent)event);
    }

    private void onPropertiesPresent(ReusableLogEvent event, List<Property> properties) {
        StringMap contextData = AsyncLogger.getContextData(event);
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            Property prop = properties.get(i);
            if (contextData.getValue(prop.getName()) != null) continue;
            String value = prop.isValueNeedsLookup() ? this.privateConfig.config.getStrSubstitutor().replace((LogEvent)event, prop.getValue()) : prop.getValue();
            contextData.putValue(prop.getName(), (Object)value);
        }
        event.setContextData(contextData);
    }

    private static StringMap getContextData(ReusableLogEvent event) {
        StringMap contextData = event.getContextData();
        if (contextData.isFrozen()) {
            StringMap temp = ContextDataFactory.createContextData();
            temp.putAll((ReadOnlyStringMap)contextData);
            return temp;
        }
        return contextData;
    }

    AsyncLoggerDisruptor getAsyncLoggerDisruptor() {
        return this.loggerDisruptor;
    }

    public static class Builder
    extends Logger.Builder {
        private final AsyncLoggerDisruptor disruptor;

        @Inject
        public Builder(LoggerContext context, MessageFactory messageFactory, FlowMessageFactory flowMessageFactory, RecyclerFactory recyclerFactory, @Named(value={"StatusLogger"}) @Named(value={"StatusLogger"}) Logger statusLogger, AsyncLoggerDisruptor disruptor) {
            super(context, messageFactory, flowMessageFactory, recyclerFactory, statusLogger);
            this.disruptor = disruptor;
        }

        public org.apache.logging.log4j.core.Logger build() {
            return new AsyncLogger(this.getContext(), this.getName(), this.getActualMessageFactory(), this.getFlowMessageFactory(), this.getRecyclerFactory(), this.getStatusLogger(), this.disruptor);
        }
    }
}

