/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.util.CloseShieldOutputStream;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="Console")
public final class ConsoleAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    public static final String PLUGIN_NAME = "Console";
    private static final ConsoleManagerFactory factory = new ConsoleManagerFactory();
    private static final Target DEFAULT_TARGET = Target.SYSTEM_OUT;
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final Target target;

    private static Charset getCharset(String property) {
        String charsetName = null;
        try {
            charsetName = System.getProperty(property);
            if (charsetName != null) {
                return Charset.forName(charsetName);
            }
        }
        catch (SecurityException e) {
            LOGGER.warn("{} lacks permissions to access system property {}.", (Object)ConsoleAppender.class.getName(), (Object)property, (Object)e);
        }
        catch (UnsupportedCharsetException e) {
            LOGGER.warn("The requested charset '{}' is not available.", (Object)charsetName, (Object)e);
        }
        return Charset.defaultCharset();
    }

    private ConsoleAppender(String name, Layout layout, Filter filter, OutputStreamManager manager, boolean ignoreExceptions, Target target, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, true, properties, manager);
        this.target = target;
    }

    public static ConsoleAppender createDefaultAppenderForLayout(Layout layout) {
        return new ConsoleAppender("DefaultConsole-" + COUNT.incrementAndGet(), layout, null, ConsoleAppender.getDefaultManager(layout), true, DEFAULT_TARGET, null);
    }

    @PluginFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private static OutputStreamManager getDefaultManager(Layout layout) {
        CloseShieldOutputStream os = new CloseShieldOutputStream(DEFAULT_TARGET == Target.SYSTEM_ERR ? System.err : System.out);
        String managerName = DEFAULT_TARGET.name() + ".false.false-" + COUNT.get();
        return OutputStreamManager.getManager(managerName, new FactoryData(os, managerName, layout), factory);
    }

    private static OutputStream getDefaultOutputStream(Target target) {
        return new CloseShieldOutputStream(target == Target.SYSTEM_OUT ? System.out : System.err);
    }

    private static OutputStream getDirectOutputStream(Target target) {
        return new CloseShieldOutputStream(new FileOutputStream(target == Target.SYSTEM_OUT ? FileDescriptor.out : FileDescriptor.err));
    }

    private static OutputStream getFollowOutputStream(Target target) {
        return target == Target.SYSTEM_OUT ? new SystemOutStream() : new SystemErrStream();
    }

    public Target getTarget() {
        return this.target;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Target {
        SYSTEM_OUT{

            @Override
            public Charset getDefaultCharset() {
                return ConsoleAppender.getCharset("sun.stdout.encoding");
            }
        }
        ,
        SYSTEM_ERR{

            @Override
            public Charset getDefaultCharset() {
                return ConsoleAppender.getCharset("sun.stderr.encoding");
            }
        };


        public abstract Charset getDefaultCharset();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<ConsoleAppender> {
        @PluginBuilderAttribute
        @Required
        private Target target = DEFAULT_TARGET;
        @PluginBuilderAttribute
        private boolean follow;
        @PluginBuilderAttribute
        private boolean direct;

        public B setTarget(Target aTarget) {
            this.target = aTarget;
            return (B)((Builder)this.asBuilder());
        }

        public B setFollow(boolean shouldFollow) {
            this.follow = shouldFollow;
            return (B)((Builder)this.asBuilder());
        }

        public B setDirect(boolean shouldDirect) {
            this.direct = shouldDirect;
            return (B)((Builder)this.asBuilder());
        }

        public ConsoleAppender build() {
            if (this.direct && this.follow) {
                LOGGER.error("Cannot use both `direct` and `follow` on ConsoleAppender.");
                return null;
            }
            Layout layout = this.getOrCreateLayout(this.target.getDefaultCharset());
            OutputStream stream = this.direct ? ConsoleAppender.getDirectOutputStream(this.target) : (this.follow ? ConsoleAppender.getFollowOutputStream(this.target) : ConsoleAppender.getDefaultOutputStream(this.target));
            String managerName = this.target.name() + "." + this.follow + "." + this.direct;
            OutputStreamManager manager = OutputStreamManager.getManager(managerName, new FactoryData(stream, managerName, layout), factory);
            return new ConsoleAppender(this.getName(), layout, this.getFilter(), manager, this.isIgnoreExceptions(), this.target, this.getPropertyArray());
        }
    }

    private static class FactoryData {
        private final OutputStream os;
        private final String name;
        private final Layout layout;

        public FactoryData(OutputStream os, String type, Layout layout) {
            this.os = os;
            this.name = type;
            this.layout = layout;
        }
    }

    private static class ConsoleManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private ConsoleManagerFactory() {
        }

        @Override
        public OutputStreamManager createManager(String name, FactoryData data) {
            return new OutputStreamManager(data.os, data.name, data.layout, true);
        }
    }

    private static class SystemOutStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.out.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            System.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            System.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            System.out.write(b);
        }
    }

    private static class SystemErrStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.err.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            System.err.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            System.err.write(b, off, len);
        }

        @Override
        public void write(int b) {
            System.err.write(b);
        }
    }
}

