/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ConfigurationSource {
    private static final Logger LOGGER = StatusLogger.getLogger();
    public static final ConfigurationSource NULL_SOURCE = new ConfigurationSource(new byte[0], null, 0L);
    public static final ConfigurationSource COMPOSITE_SOURCE = new ConfigurationSource(new byte[0], null, 0L);
    private static final String HTTPS = "https";
    private final InputStream stream;
    private volatile byte @Nullable [] data;
    private final @Nullable Source source;
    private final long initialLastModified;
    private volatile long currentLastModified;

    public ConfigurationSource(InputStream stream, File file) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.data = null;
        this.source = new Source(file);
        long modified = 0L;
        try {
            modified = file.lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentLastModified = this.initialLastModified = modified;
    }

    public ConfigurationSource(InputStream stream, Path path) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.data = null;
        this.source = new Source(path);
        long modified = 0L;
        try {
            modified = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentLastModified = this.initialLastModified = modified;
    }

    public ConfigurationSource(InputStream stream, URL url) {
        this(stream, url, 0L);
    }

    public ConfigurationSource(InputStream stream, URL url, long lastModified) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.data = null;
        this.currentLastModified = this.initialLastModified = lastModified;
        this.source = new Source(url);
    }

    public ConfigurationSource(InputStream stream) throws IOException {
        this(stream.readAllBytes(), null, 0L);
    }

    public ConfigurationSource(Source source, byte[] data, long lastModified) {
        Objects.requireNonNull(source, "source is null");
        this.data = Objects.requireNonNull(data, "data is null");
        this.stream = new ByteArrayInputStream(data);
        this.currentLastModified = this.initialLastModified = lastModified;
        this.source = source;
    }

    private ConfigurationSource(byte[] data, @Nullable Source source, long lastModified) {
        this(data, source, new ByteArrayInputStream(data), lastModified);
    }

    private ConfigurationSource(byte @Nullable [] data, @Nullable Source source, InputStream stream, long lastModified) {
        if (data == null && source == null) {
            throw new NullPointerException("both `data` and `source` are null");
        }
        this.stream = stream;
        this.data = data;
        this.source = source;
        this.currentLastModified = this.initialLastModified = lastModified;
    }

    public @Nullable File getFile() {
        return this.source == null ? null : this.source.getFile();
    }

    public @Nullable URL getURL() {
        return this.source == null ? null : this.source.getURL();
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setModifiedMillis(long currentLastModified) {
        this.currentLastModified = currentLastModified;
    }

    public @Nullable URI getURI() {
        return this.source == null ? null : this.source.getURI();
    }

    public long getLastModified() {
        return this.initialLastModified;
    }

    public @Nullable String getLocation() {
        return this.source == null ? null : this.source.getLocation();
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public @Nullable ConfigurationSource resetInputStream() throws IOException {
        byte[] data = this.data;
        if (this.source != null && data != null) {
            return new ConfigurationSource(this.source, data, this.currentLastModified);
        }
        File file = this.getFile();
        if (file != null) {
            return new ConfigurationSource(Files.newInputStream(file.toPath(), new OpenOption[0]), this.getFile());
        }
        URL url = this.getURL();
        if (url != null && data != null) {
            return new ConfigurationSource(data, new Source(url), this.currentLastModified);
        }
        URI uri = this.getURI();
        if (uri != null) {
            return ConfigurationSource.fromUri(uri);
        }
        return data == null ? null : new ConfigurationSource(data, null, this.currentLastModified);
    }

    public String toString() {
        if (this.source != null) {
            return this.source.getLocation();
        }
        if (this == NULL_SOURCE) {
            return "NULL_SOURCE";
        }
        if (this == COMPOSITE_SOURCE) {
            return "COMPOSITE_SOURCE";
        }
        byte[] data = this.data;
        int length = data == null ? -1 : data.length;
        return "stream (" + length + " bytes, unknown location)";
    }

    public static @Nullable ConfigurationSource fromUri(URI configLocation) {
        File configFile = FileUtils.fileFromUri(configLocation);
        if (configFile != null && configFile.exists() && configFile.canRead()) {
            try {
                return new ConfigurationSource((InputStream)new FileInputStream(configFile), configFile);
            }
            catch (FileNotFoundException ex) {
                ConfigurationFactory.LOGGER.error("Cannot locate file {}", (Object)configLocation.getPath(), (Object)ex);
            }
        }
        if (ConfigurationFactory.isClassLoaderUri(configLocation)) {
            ClassLoader loader = LoaderUtil.getThreadContextClassLoader();
            String path = ConfigurationFactory.extractClassLoaderUriPath(configLocation);
            return ConfigurationSource.fromResource(path, loader);
        }
        if (!configLocation.isAbsolute()) {
            ConfigurationFactory.LOGGER.error("File not found in file system or classpath: {}", (Object)configLocation.toString());
            return null;
        }
        try {
            return ConfigurationSource.getConfigurationSource(configLocation.toURL());
        }
        catch (MalformedURLException ex) {
            ConfigurationFactory.LOGGER.error("Invalid URL {}", (Object)configLocation.toString(), (Object)ex);
            return null;
        }
    }

    public static @Nullable ConfigurationSource fromResource(String resource, @Nullable ClassLoader loader) {
        URL url = Loader.getResource(resource, loader);
        return url == null ? null : ConfigurationSource.getConfigurationSource(url);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The name of the accessed files is based on a configuration value.")
    private static @Nullable ConfigurationSource getConfigurationSource(URL url) {
        try {
            SslConfiguration sslConfiguration;
            URLConnection urlConnection = url.openConnection();
            urlConnection.setUseCaches(false);
            PropertyEnvironment env = PropertyEnvironment.getGlobal();
            AuthorizationProvider provider = AuthorizationProvider.getAuthorizationProvider((CoreProperties.AuthenticationProperties)env.getProperty(CoreProperties.AuthenticationProperties.class));
            provider.addAuthorization(urlConnection);
            if (url.getProtocol().equals(HTTPS) && (sslConfiguration = SslConfigurationFactory.getSslConfiguration(env)) != null) {
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslConfiguration.getSslContext().getSocketFactory());
                if (!sslConfiguration.isVerifyHostName()) {
                    ((HttpsURLConnection)urlConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
                }
            }
            File file = FileUtils.fileFromUri(url.toURI());
            try {
                if (file != null) {
                    return new ConfigurationSource(urlConnection.getInputStream(), FileUtils.fileFromUri(url.toURI()));
                }
                if (urlConnection instanceof JarURLConnection) {
                    URL jarFileUrl = ((JarURLConnection)urlConnection).getJarFileURL();
                    File jarFile = new File(jarFileUrl.getFile());
                    long lastModified = jarFile.lastModified();
                    return new ConfigurationSource(urlConnection.getInputStream(), url, lastModified);
                }
                return new ConfigurationSource(urlConnection.getInputStream(), url, urlConnection.getLastModified());
            }
            catch (FileNotFoundException ex) {
                ConfigurationFactory.LOGGER.info("Unable to locate file {}, ignoring.", (Object)url.toString());
                return null;
            }
        }
        catch (IOException | URISyntaxException ex) {
            ConfigurationFactory.LOGGER.warn("Error accessing {} due to {}, ignoring.", (Object)url.toString(), (Object)ex.getMessage());
            return null;
        }
    }
}

