/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;

public final class ContextDataFactory {
    private static final Class<? extends StringMap> CACHED_CLASS = ((CoreProperties.LogEventProperties)PropertyEnvironment.getGlobal().getProperty(CoreProperties.LogEventProperties.class)).contextData().type();
    private static final Constructor<? extends StringMap> DEFAULT_CONSTRUCTOR = ContextDataFactory.createDefaultConstructor();
    private static final Constructor<? extends StringMap> INITIAL_CAPACITY_CONSTRUCTOR = ContextDataFactory.createInitialCapacityConstructor();
    private static final StringMap EMPTY_STRING_MAP = ContextDataFactory.createContextData(0);

    private ContextDataFactory() {
    }

    private static Constructor<? extends StringMap> createDefaultConstructor() {
        if (CACHED_CLASS == null) {
            return null;
        }
        try {
            return CACHED_CLASS.getConstructor(new Class[0]);
        }
        catch (IllegalAccessError | NoSuchMethodException ignored) {
            return null;
        }
    }

    private static Constructor<? extends StringMap> createInitialCapacityConstructor() {
        if (CACHED_CLASS == null) {
            return null;
        }
        try {
            return CACHED_CLASS.getConstructor(Integer.TYPE);
        }
        catch (IllegalAccessError | NoSuchMethodException ignored) {
            return null;
        }
    }

    public static StringMap createContextData() {
        if (DEFAULT_CONSTRUCTOR == null) {
            return new SortedArrayStringMap();
        }
        try {
            return DEFAULT_CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (Throwable ignored) {
            return new SortedArrayStringMap();
        }
    }

    public static StringMap createContextData(int initialCapacity) {
        if (INITIAL_CAPACITY_CONSTRUCTOR == null) {
            return new SortedArrayStringMap(initialCapacity);
        }
        try {
            return INITIAL_CAPACITY_CONSTRUCTOR.newInstance(initialCapacity);
        }
        catch (Throwable ignored) {
            return new SortedArrayStringMap(initialCapacity);
        }
    }

    public static StringMap createContextData(Map<String, String> context) {
        StringMap contextData = ContextDataFactory.createContextData(context.size());
        for (Map.Entry<String, String> entry : context.entrySet()) {
            contextData.putValue(entry.getKey(), (Object)entry.getValue());
        }
        return contextData;
    }

    public static StringMap createContextData(ReadOnlyStringMap readOnlyStringMap) {
        StringMap contextData = ContextDataFactory.createContextData(readOnlyStringMap.size());
        contextData.putAll(readOnlyStringMap);
        return contextData;
    }

    public static StringMap emptyFrozenContextData() {
        return EMPTY_STRING_MAP;
    }

    static {
        EMPTY_STRING_MAP.freeze();
    }
}

