/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.internal.tests.IndexWriterAccess;
import org.apache.lucene.internal.tests.SegmentReaderAccess;
import org.apache.lucene.internal.tests.TestSecrets;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.index.MockRandomMergePolicy;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.FailOnNonBulkMergesInfoStream;
import org.apache.lucene.tests.util.LineFileDocs;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util.PrintStreamInfoStream;
import org.apache.lucene.util.SuppressForbidden;
import org.junit.Assert;

public abstract class ThreadedIndexingAndSearchingTestCase
extends LuceneTestCase {
    private static final IndexWriterAccess INDEX_WRITER_ACCESS = TestSecrets.getIndexWriterAccess();
    private static final SegmentReaderAccess SEGMENT_READER_ACCESS = TestSecrets.getSegmentReaderAccess();
    protected final AtomicBoolean failed = new AtomicBoolean();
    protected final AtomicInteger addCount = new AtomicInteger();
    protected final AtomicInteger delCount = new AtomicInteger();
    protected final AtomicInteger packCount = new AtomicInteger();
    protected Directory dir;
    protected IndexWriter writer;
    protected boolean assertMergedSegmentsWarmed = true;
    private final Map<Object, Boolean> warmed = Collections.synchronizedMap(new WeakHashMap());

    protected abstract IndexSearcher getCurrentSearcher() throws Exception;

    protected abstract IndexSearcher getFinalSearcher() throws Exception;

    protected void releaseSearcher(IndexSearcher s) throws Exception {
    }

    protected abstract void doSearching(ExecutorService var1, int var2) throws Exception;

    protected Directory getDirectory(Directory in) {
        return in;
    }

    protected void updateDocuments(Term id, List<? extends Iterable<? extends IndexableField>> docs) throws Exception {
        this.writer.updateDocuments(id, docs);
    }

    protected void addDocuments(Term id, List<? extends Iterable<? extends IndexableField>> docs) throws Exception {
        this.writer.addDocuments(docs);
    }

    protected void addDocument(Term id, Iterable<? extends IndexableField> doc) throws Exception {
        this.writer.addDocument(doc);
    }

    protected void updateDocument(Term term, Iterable<? extends IndexableField> doc) throws Exception {
        this.writer.updateDocument(term, doc);
    }

    protected void deleteDocuments(Term term) throws Exception {
        this.writer.deleteDocuments(new Term[]{term});
    }

    protected void doAfterIndexingThreadDone() {
    }

    private Thread[] launchIndexingThreads(final LineFileDocs docs, int numThreads, final int maxIterations, final Set<String> delIDs, final Set<String> delPackIDs, final List<SubDocs> allSubDocs) {
        Thread[] threads = new Thread[numThreads];
        for (int thread = 0; thread < numThreads; ++thread) {
            threads[thread] = new Thread(){

                @Override
                @SuppressForbidden(reason="Thread sleep")
                public void run() {
                    ArrayList<String> toDeleteIDs = new ArrayList<String>();
                    ArrayList<SubDocs> toDeleteSubDocs = new ArrayList<SubDocs>();
                    int iterations = 0;
                    while (++iterations < maxIterations && !ThreadedIndexingAndSearchingTestCase.this.failed.get()) {
                        try {
                            String addedField;
                            Document doc;
                            if (LuceneTestCase.TEST_NIGHTLY && LuceneTestCase.random().nextInt(6) == 3) {
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println(Thread.currentThread().getName() + ": now long sleep");
                                }
                                Thread.sleep(TestUtil.nextInt(LuceneTestCase.random(), 50, 500));
                            }
                            if (LuceneTestCase.random().nextInt(7) == 5) {
                                Thread.sleep(TestUtil.nextInt(LuceneTestCase.random(), 1, 10));
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println(Thread.currentThread().getName() + ": done sleep");
                                }
                            }
                            if ((doc = docs.nextDoc()) == null) break;
                            if (LuceneTestCase.random().nextBoolean()) {
                                addedField = "extra" + LuceneTestCase.random().nextInt(40);
                                doc.add((IndexableField)LuceneTestCase.newTextField(addedField, "a random field", Field.Store.YES));
                            } else {
                                addedField = null;
                            }
                            if (LuceneTestCase.random().nextBoolean()) {
                                if (LuceneTestCase.random().nextBoolean()) {
                                    Object packID;
                                    SubDocs delSubDocs;
                                    if (toDeleteSubDocs.size() > 0 && LuceneTestCase.random().nextBoolean()) {
                                        delSubDocs = (SubDocs)toDeleteSubDocs.get(LuceneTestCase.random().nextInt(toDeleteSubDocs.size()));
                                        assert (!delSubDocs.deleted);
                                        toDeleteSubDocs.remove(delSubDocs);
                                        packID = delSubDocs.packID;
                                    } else {
                                        delSubDocs = null;
                                        packID = "" + ThreadedIndexingAndSearchingTestCase.this.packCount.getAndIncrement();
                                    }
                                    Field packIDField = LuceneTestCase.newStringField("packID", (String)packID, Field.Store.YES);
                                    ArrayList<String> docIDs = new ArrayList<String>();
                                    SubDocs subDocs = new SubDocs((String)packID, docIDs);
                                    ArrayList<Document> docsList = new ArrayList<Document>();
                                    allSubDocs.add(subDocs);
                                    doc.add((IndexableField)packIDField);
                                    docsList.add(TestUtil.cloneDocument(doc));
                                    docIDs.add(doc.get("docid"));
                                    int maxDocCount = TestUtil.nextInt(LuceneTestCase.random(), 1, 10);
                                    while (docsList.size() < maxDocCount && (doc = docs.nextDoc()) != null) {
                                        docsList.add(TestUtil.cloneDocument(doc));
                                        docIDs.add(doc.get("docid"));
                                    }
                                    ThreadedIndexingAndSearchingTestCase.this.addCount.addAndGet(docsList.size());
                                    Term packIDTerm = new Term("packID", (String)packID);
                                    if (delSubDocs != null) {
                                        delSubDocs.deleted = true;
                                        delIDs.addAll(delSubDocs.subIDs);
                                        ThreadedIndexingAndSearchingTestCase.this.delCount.addAndGet(delSubDocs.subIDs.size());
                                        if (LuceneTestCase.VERBOSE) {
                                            System.out.println(Thread.currentThread().getName() + ": update pack packID=" + delSubDocs.packID + " count=" + docsList.size() + " docs=" + String.valueOf(docIDs));
                                        }
                                        ThreadedIndexingAndSearchingTestCase.this.updateDocuments(packIDTerm, docsList);
                                    } else {
                                        if (LuceneTestCase.VERBOSE) {
                                            System.out.println(Thread.currentThread().getName() + ": add pack packID=" + (String)packID + " count=" + docsList.size() + " docs=" + String.valueOf(docIDs));
                                        }
                                        ThreadedIndexingAndSearchingTestCase.this.addDocuments(packIDTerm, docsList);
                                    }
                                    doc.removeField("packID");
                                    if (LuceneTestCase.random().nextInt(5) == 2) {
                                        if (LuceneTestCase.VERBOSE) {
                                            System.out.println(Thread.currentThread().getName() + ": buffer del id:" + (String)packID);
                                        }
                                        toDeleteSubDocs.add(subDocs);
                                    }
                                } else {
                                    docid = doc.get("docid");
                                    if (LuceneTestCase.VERBOSE) {
                                        System.out.println(Thread.currentThread().getName() + ": add doc docid:" + (String)docid);
                                    }
                                    ThreadedIndexingAndSearchingTestCase.this.addDocument(new Term("docid", (String)docid), (Iterable<? extends IndexableField>)doc);
                                    ThreadedIndexingAndSearchingTestCase.this.addCount.getAndIncrement();
                                    if (LuceneTestCase.random().nextInt(5) == 3) {
                                        if (LuceneTestCase.VERBOSE) {
                                            System.out.println(Thread.currentThread().getName() + ": buffer del id:" + doc.get("docid"));
                                        }
                                        toDeleteIDs.add((String)docid);
                                    }
                                }
                            } else {
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println(Thread.currentThread().getName() + ": update doc id:" + doc.get("docid"));
                                }
                                docid = doc.get("docid");
                                ThreadedIndexingAndSearchingTestCase.this.updateDocument(new Term("docid", (String)docid), (Iterable<? extends IndexableField>)doc);
                                ThreadedIndexingAndSearchingTestCase.this.addCount.getAndIncrement();
                                if (LuceneTestCase.random().nextInt(5) == 3) {
                                    if (LuceneTestCase.VERBOSE) {
                                        System.out.println(Thread.currentThread().getName() + ": buffer del id:" + doc.get("docid"));
                                    }
                                    toDeleteIDs.add((String)docid);
                                }
                            }
                            if (LuceneTestCase.random().nextInt(30) == 17) {
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println(Thread.currentThread().getName() + ": apply " + toDeleteIDs.size() + " deletes");
                                }
                                for (String id : toDeleteIDs) {
                                    if (LuceneTestCase.VERBOSE) {
                                        System.out.println(Thread.currentThread().getName() + ": del term=id:" + id);
                                    }
                                    ThreadedIndexingAndSearchingTestCase.this.deleteDocuments(new Term("docid", id));
                                }
                                int count = ThreadedIndexingAndSearchingTestCase.this.delCount.addAndGet(toDeleteIDs.size());
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println(Thread.currentThread().getName() + ": tot " + count + " deletes");
                                }
                                delIDs.addAll(toDeleteIDs);
                                toDeleteIDs.clear();
                                for (SubDocs subDocs : toDeleteSubDocs) {
                                    assert (!subDocs.deleted);
                                    delPackIDs.add(subDocs.packID);
                                    ThreadedIndexingAndSearchingTestCase.this.deleteDocuments(new Term("packID", subDocs.packID));
                                    subDocs.deleted = true;
                                    if (LuceneTestCase.VERBOSE) {
                                        System.out.println(Thread.currentThread().getName() + ": del subs: " + String.valueOf(subDocs.subIDs) + " packID=" + subDocs.packID);
                                    }
                                    delIDs.addAll(subDocs.subIDs);
                                    ThreadedIndexingAndSearchingTestCase.this.delCount.addAndGet(subDocs.subIDs.size());
                                }
                                toDeleteSubDocs.clear();
                            }
                            if (addedField == null) continue;
                            doc.removeField(addedField);
                        }
                        catch (Throwable t) {
                            System.out.println(Thread.currentThread().getName() + ": hit exc");
                            t.printStackTrace();
                            ThreadedIndexingAndSearchingTestCase.this.failed.set(true);
                            throw new RuntimeException(t);
                        }
                    }
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println(Thread.currentThread().getName() + ": indexing done");
                    }
                    ThreadedIndexingAndSearchingTestCase.this.doAfterIndexingThreadDone();
                }
            };
            threads[thread].start();
        }
        return threads;
    }

    protected void runSearchThreads(final int maxIterations) throws Exception {
        int numThreads = TEST_NIGHTLY ? TestUtil.nextInt(ThreadedIndexingAndSearchingTestCase.random(), 1, 5) : 2;
        Thread[] searchThreads = new Thread[numThreads];
        final AtomicLong totHits = new AtomicLong();
        final AtomicInteger totTermCount = new AtomicInteger(100);
        for (int thread = 0; thread < searchThreads.length; ++thread) {
            searchThreads[thread] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println(Thread.currentThread().getName() + ": launch search thread");
                    }
                    int iterations = 0;
                    block6: while (++iterations < maxIterations && !ThreadedIndexingAndSearchingTestCase.this.failed.get()) {
                        try {
                            IndexSearcher s = ThreadedIndexingAndSearchingTestCase.this.getCurrentSearcher();
                            try {
                                int trigger;
                                int shift;
                                for (LeafReaderContext sub : s.getIndexReader().leaves()) {
                                    SegmentReader segReader = (SegmentReader)sub.reader();
                                    Map diagnostics = segReader.getSegmentInfo().info.getDiagnostics();
                                    Assert.assertNotNull((Object)diagnostics);
                                    String source = (String)diagnostics.get("source");
                                    Assert.assertNotNull((Object)source);
                                    if (!source.equals("merge")) continue;
                                    Assert.assertTrue((String)("sub reader " + String.valueOf(sub) + " wasn't warmed: warmed=" + String.valueOf(ThreadedIndexingAndSearchingTestCase.this.warmed) + " diagnostics=" + String.valueOf(diagnostics) + " si=" + String.valueOf(segReader.getSegmentInfo())), (!ThreadedIndexingAndSearchingTestCase.this.assertMergedSegmentsWarmed || ThreadedIndexingAndSearchingTestCase.this.warmed.containsKey(SEGMENT_READER_ACCESS.getCore(segReader)) ? 1 : 0) != 0);
                                }
                                if (s.getIndexReader().numDocs() <= 0) continue;
                                ThreadedIndexingAndSearchingTestCase.this.smokeTestSearcher(s);
                                Terms terms = MultiTerms.getTerms((IndexReader)s.getIndexReader(), (String)"body");
                                if (terms == null) continue;
                                TermsEnum termsEnum = terms.iterator();
                                int seenTermCount = 0;
                                if (totTermCount.get() < 30) {
                                    shift = 0;
                                    trigger = 1;
                                } else {
                                    trigger = totTermCount.get() / 30;
                                    shift = LuceneTestCase.random().nextInt(trigger);
                                }
                                int iters = 0;
                                while (++iters < maxIterations) {
                                    BytesRef term = termsEnum.next();
                                    if (term == null) {
                                        totTermCount.set(seenTermCount);
                                        continue block6;
                                    }
                                    if ((++seenTermCount + shift) % trigger != 0) continue;
                                    totHits.addAndGet(ThreadedIndexingAndSearchingTestCase.this.runQuery(s, (Query)new TermQuery(new Term("body", term))));
                                }
                            }
                            finally {
                                ThreadedIndexingAndSearchingTestCase.this.releaseSearcher(s);
                            }
                        }
                        catch (Throwable t) {
                            System.out.println(Thread.currentThread().getName() + ": hit exc");
                            ThreadedIndexingAndSearchingTestCase.this.failed.set(true);
                            t.printStackTrace(System.out);
                            throw new RuntimeException(t);
                        }
                    }
                }
            };
            searchThreads[thread].start();
        }
        for (Thread thread : searchThreads) {
            thread.join();
        }
        if (VERBOSE) {
            System.out.println("TEST: DONE search: totHits=" + String.valueOf(totHits));
        }
    }

    protected void doAfterWriter(ExecutorService es) throws Exception {
    }

    protected void doClose() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="Thread sleep")
    public void runTest(String testName) throws Exception {
        TopDocs hits;
        this.failed.set(false);
        this.addCount.set(0);
        this.delCount.set(0);
        this.packCount.set(0);
        long t0 = System.nanoTime();
        Random random = new Random(ThreadedIndexingAndSearchingTestCase.random().nextLong());
        LineFileDocs docs = new LineFileDocs(random);
        Path tempDir = ThreadedIndexingAndSearchingTestCase.createTempDir(testName);
        this.dir = this.getDirectory((Directory)ThreadedIndexingAndSearchingTestCase.newMockFSDirectory(tempDir));
        if (this.dir instanceof BaseDirectoryWrapper) {
            ((BaseDirectoryWrapper)this.dir).setCheckIndexOnClose(false);
        }
        MockAnalyzer analyzer = new MockAnalyzer(ThreadedIndexingAndSearchingTestCase.random());
        analyzer.setMaxTokenLength(TestUtil.nextInt(ThreadedIndexingAndSearchingTestCase.random(), 1, 32766));
        IndexWriterConfig conf = ThreadedIndexingAndSearchingTestCase.newIndexWriterConfig(analyzer).setCommitOnClose(false);
        conf.setInfoStream((InfoStream)new FailOnNonBulkMergesInfoStream());
        if (conf.getMergePolicy() instanceof MockRandomMergePolicy) {
            ((MockRandomMergePolicy)conf.getMergePolicy()).setDoNonBulkMerges(false);
        }
        ThreadedIndexingAndSearchingTestCase.ensureSaneIWCOnNightly(conf);
        conf.setMergedSegmentWarmer(reader -> {
            if (VERBOSE) {
                System.out.println("TEST: now warm merged reader=" + String.valueOf(reader));
            }
            Object core = SEGMENT_READER_ACCESS.getCore((SegmentReader)reader);
            this.warmed.put(core, Boolean.TRUE);
            int maxDoc = reader.maxDoc();
            Bits liveDocs = reader.getLiveDocs();
            int sum = 0;
            int inc = Math.max(1, maxDoc / 50);
            StoredFields storedFields = reader.storedFields();
            for (int docID = 0; docID < maxDoc; docID += inc) {
                if (liveDocs != null && !liveDocs.get(docID)) continue;
                Document doc = storedFields.document(docID);
                sum += doc.getFields().size();
            }
            IndexSearcher searcher = ThreadedIndexingAndSearchingTestCase.newSearcher((IndexReader)reader, false);
            sum = (int)((long)sum + searcher.search((Query)new TermQuery((Term)new Term((String)"body", (String)"united")), (int)10).totalHits.value());
            if (VERBOSE) {
                System.out.println("TEST: warm visited " + sum + " fields");
            }
        });
        if (VERBOSE) {
            conf.setInfoStream((InfoStream)new PrintStreamInfoStream(this, System.out){

                public void message(String component, String message) {
                    if ("TP".equals(component)) {
                        return;
                    }
                    super.message(component, message);
                }
            });
        }
        this.writer = new IndexWriter(this.dir, conf);
        TestUtil.reduceOpenFiles(this.writer);
        ExecutorService es = ThreadedIndexingAndSearchingTestCase.random().nextBoolean() ? null : Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(testName));
        this.doAfterWriter(es);
        int NUM_INDEX_THREADS = TestUtil.nextInt(ThreadedIndexingAndSearchingTestCase.random(), 2, 4);
        int MAX_ITERATIONS = LuceneTestCase.TEST_NIGHTLY ? 200 : 10 * RANDOM_MULTIPLIER;
        Set<String> delIDs = Collections.synchronizedSet(new HashSet());
        Set<String> delPackIDs = Collections.synchronizedSet(new HashSet());
        List<SubDocs> allSubDocs = Collections.synchronizedList(new ArrayList());
        Thread[] indexThreads = this.launchIndexingThreads(docs, NUM_INDEX_THREADS, MAX_ITERATIONS, delIDs, delPackIDs, allSubDocs);
        if (VERBOSE) {
            System.out.println("TEST: DONE start " + NUM_INDEX_THREADS + " indexing threads [" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms]");
        }
        Thread.sleep(100L);
        this.doSearching(es, MAX_ITERATIONS);
        if (VERBOSE) {
            System.out.println("TEST: all searching done [" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms]");
        }
        for (Thread thread : indexThreads) {
            thread.join();
        }
        if (VERBOSE) {
            System.out.println("TEST: done join indexing threads [" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms]; addCount=" + String.valueOf(this.addCount) + " delCount=" + String.valueOf(this.delCount));
        }
        IndexSearcher s = this.getFinalSearcher();
        if (VERBOSE) {
            System.out.println("TEST: finalSearcher=" + String.valueOf(s));
        }
        ThreadedIndexingAndSearchingTestCase.assertFalse((boolean)this.failed.get());
        boolean doFail = false;
        for (String id : delIDs) {
            hits = s.search((Query)new TermQuery(new Term("docid", id)), 1);
            if (hits.totalHits.value() == 0L) continue;
            System.out.println("doc id=" + id + " is supposed to be deleted, but got " + hits.totalHits.value() + " hits; first docID=" + hits.scoreDocs[0].doc);
            doFail = true;
        }
        for (String id : delPackIDs) {
            hits = s.search((Query)new TermQuery(new Term("packID", id)), 1);
            if (hits.totalHits.value() == 0L) continue;
            System.out.println("packID=" + id + " is supposed to be deleted, but got " + hits.totalHits.value() + " matches");
            doFail = true;
        }
        for (SubDocs subDocs : allSubDocs) {
            hits = s.search((Query)new TermQuery(new Term("packID", subDocs.packID)), 20);
            StoredFields storedFields = s.storedFields();
            if (!subDocs.deleted) {
                if (hits.totalHits.value() != (long)subDocs.subIDs.size()) {
                    System.out.println("packID=" + subDocs.packID + ": expected " + subDocs.subIDs.size() + " hits but got " + hits.totalHits.value());
                    doFail = true;
                    continue;
                }
                int lastDocID = -1;
                int startDocID = -1;
                for (ScoreDoc scoreDoc : hits.scoreDocs) {
                    int docID = scoreDoc.doc;
                    if (lastDocID != -1) {
                        ThreadedIndexingAndSearchingTestCase.assertEquals((long)(1 + lastDocID), (long)docID);
                    } else {
                        startDocID = docID;
                    }
                    lastDocID = docID;
                    Document doc = storedFields.document(docID);
                    ThreadedIndexingAndSearchingTestCase.assertEquals((Object)subDocs.packID, (Object)doc.get("packID"));
                }
                lastDocID = startDocID - 1;
                for (String subID : subDocs.subIDs) {
                    hits = s.search((Query)new TermQuery(new Term("docid", subID)), 1);
                    ThreadedIndexingAndSearchingTestCase.assertEquals((long)1L, (long)hits.totalHits.value());
                    int docID = hits.scoreDocs[0].doc;
                    if (lastDocID != -1) {
                        ThreadedIndexingAndSearchingTestCase.assertEquals((long)(1 + lastDocID), (long)docID);
                    }
                    lastDocID = docID;
                }
                continue;
            }
            for (String subID : subDocs.subIDs) {
                ThreadedIndexingAndSearchingTestCase.assertEquals((long)0L, (long)s.search((Query)new TermQuery((Term)new Term((String)"docid", (String)subID)), (int)1).totalHits.value());
            }
        }
        int endID = Integer.parseInt(docs.nextDoc().get("docid"));
        docs.close();
        for (int id = 0; id < endID; ++id) {
            String stringID = "" + id;
            if (delIDs.contains(stringID)) continue;
            TopDocs hits2 = s.search((Query)new TermQuery(new Term("docid", stringID)), 1);
            if (hits2.totalHits.value() == 1L) continue;
            System.out.println("doc id=" + stringID + " is not supposed to be deleted, but got hitCount=" + hits2.totalHits.value() + "; delIDs=" + String.valueOf(delIDs));
            doFail = true;
        }
        ThreadedIndexingAndSearchingTestCase.assertFalse((boolean)doFail);
        ThreadedIndexingAndSearchingTestCase.assertEquals((String)("index=" + INDEX_WRITER_ACCESS.segString(this.writer) + " addCount=" + String.valueOf(this.addCount) + " delCount=" + String.valueOf(this.delCount)), (long)(this.addCount.get() - this.delCount.get()), (long)s.getIndexReader().numDocs());
        this.releaseSearcher(s);
        this.writer.commit();
        ThreadedIndexingAndSearchingTestCase.assertEquals((String)("index=" + INDEX_WRITER_ACCESS.segString(this.writer) + " addCount=" + String.valueOf(this.addCount) + " delCount=" + String.valueOf(this.delCount)), (long)(this.addCount.get() - this.delCount.get()), (long)this.writer.getDocStats().numDocs);
        this.doClose();
        try {
            this.writer.commit();
        }
        finally {
            this.writer.close();
        }
        if (es != null) {
            es.shutdown();
            es.awaitTermination(1L, TimeUnit.SECONDS);
        }
        TestUtil.checkIndex(this.dir);
        this.dir.close();
        if (VERBOSE) {
            System.out.println("TEST: done [" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms]");
        }
    }

    private long runQuery(IndexSearcher s, Query q) throws Exception {
        s.search(q, 10);
        long hitCount = s.search((Query)q, (int)10, (Sort)new Sort((SortField[])new SortField[]{new SortField((String)"titleDV", (SortField.Type)SortField.Type.STRING)})).totalHits.value();
        Sort dvSort = new Sort(new SortField[]{new SortField("titleDV", SortField.Type.STRING)});
        long hitCount2 = s.search((Query)q, (int)10, (Sort)dvSort).totalHits.value();
        ThreadedIndexingAndSearchingTestCase.assertEquals((long)hitCount, (long)hitCount2);
        return hitCount;
    }

    protected void smokeTestSearcher(IndexSearcher s) throws Exception {
        this.runQuery(s, (Query)new TermQuery(new Term("body", "united")));
        this.runQuery(s, (Query)new TermQuery(new Term("titleTokenized", "states")));
        PhraseQuery pq = new PhraseQuery("body", new String[]{"united", "states"});
        this.runQuery(s, (Query)pq);
    }

    private static class SubDocs {
        public final String packID;
        public final List<String> subIDs;
        public boolean deleted;

        public SubDocs(String packID, List<String> subIDs) {
            this.packID = packID;
            this.subIDs = subIDs;
        }
    }
}

