/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.odf.NSNormalizerContentHandler;
import org.apache.tika.sax.ElementMappingContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class OpenDocumentContentParser
extends AbstractParser {
    public static final String TEXT_NS = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    public static final String TABLE_NS = "urn:oasis:names:tc:opendocument:xmlns:table:1.0";
    public static final String OFFICE_NS = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
    public static final String SVG_NS = "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0";
    public static final String PRESENTATION_NS = "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0";
    public static final String DRAW_NS = "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0";
    public static final String XLINK_NS = "http://www.w3.org/1999/xlink";
    protected static final char[] TAB = new char[]{'\t'};
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private static final HashMap<QName, ElementMappingContentHandler.TargetElement> MAPPINGS = new HashMap();

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Collections.emptySet();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.parseInternal(stream, (ContentHandler)new XHTMLContentHandler(handler, metadata), metadata, context);
    }

    void parseInternal(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        OpenDocumentElementMappingContentHandler dh = new OpenDocumentElementMappingContentHandler(handler, MAPPINGS);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (SAXNotRecognizedException e) {
                // empty catch block
            }
            SAXParser parser = factory.newSAXParser();
            parser.parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)((Object)new NSNormalizerContentHandler((ContentHandler)((Object)dh)))));
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser configuration error", (Throwable)e);
        }
    }

    static {
        MAPPINGS.put(new QName(TEXT_NS, "p"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "p"));
        MAPPINGS.put(new QName(TEXT_NS, "line-break"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "br"));
        MAPPINGS.put(new QName(TEXT_NS, "list"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "ul"));
        MAPPINGS.put(new QName(TEXT_NS, "list-item"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "li"));
        MAPPINGS.put(new QName(TEXT_NS, "note"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(OFFICE_NS, "annotation"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(PRESENTATION_NS, "notes"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(DRAW_NS, "object"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "object"));
        MAPPINGS.put(new QName(DRAW_NS, "text-box"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(SVG_NS, "title"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "span"));
        MAPPINGS.put(new QName(SVG_NS, "desc"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "span"));
        MAPPINGS.put(new QName(TEXT_NS, "span"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "span"));
        HashMap<QName, QName> aAttsMapping = new HashMap<QName, QName>();
        aAttsMapping.put(new QName(XLINK_NS, "href"), new QName("href"));
        aAttsMapping.put(new QName(XLINK_NS, "title"), new QName("title"));
        MAPPINGS.put(new QName(TEXT_NS, "a"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "a", aAttsMapping));
        MAPPINGS.put(new QName(TABLE_NS, "table"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "table"));
        MAPPINGS.put(new QName(TABLE_NS, "table-row"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "tr"));
        HashMap<QName, QName> tableCellAttsMapping = new HashMap<QName, QName>();
        tableCellAttsMapping.put(new QName(TABLE_NS, "number-columns-spanned"), new QName("colspan"));
        tableCellAttsMapping.put(new QName(TABLE_NS, "number-rows-spanned"), new QName("rowspan"));
        tableCellAttsMapping.put(new QName(TABLE_NS, "number-columns-repeated"), new QName("colspan"));
        MAPPINGS.put(new QName(TABLE_NS, "table-cell"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "td", tableCellAttsMapping));
    }

    private static final class OpenDocumentElementMappingContentHandler
    extends ElementMappingContentHandler {
        private final ContentHandler handler;
        private final BitSet textNodeStack = new BitSet();
        private int nodeDepth = 0;
        private int completelyFiltered = 0;
        private Stack<String> headingStack = new Stack();

        private OpenDocumentElementMappingContentHandler(ContentHandler handler, Map<QName, ElementMappingContentHandler.TargetElement> mappings) {
            super(handler, mappings);
            this.handler = handler;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.completelyFiltered == 0 && this.nodeDepth > 0 && this.textNodeStack.get(this.nodeDepth - 1)) {
                super.characters(ch, start, length);
            }
        }

        private boolean needsCompleteFiltering(String namespaceURI, String localName) {
            if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI)) {
                return localName.endsWith("-template") || localName.endsWith("-style");
            }
            if (OpenDocumentContentParser.TABLE_NS.equals(namespaceURI)) {
                return "covered-table-cell".equals(localName);
            }
            return false;
        }

        private String getXHTMLHeaderTagName(Attributes atts) {
            String depthStr = atts.getValue(OpenDocumentContentParser.TEXT_NS, "outline-level");
            if (depthStr == null) {
                return "h1";
            }
            int depth = Integer.parseInt(depthStr);
            if (depth >= 6) {
                return "h6";
            }
            if (depth <= 1) {
                return "h1";
            }
            return "h" + depth;
        }

        private boolean isTextNode(String namespaceURI, String localName) {
            if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && !localName.equals("page-number") && !localName.equals("page-count")) {
                return true;
            }
            if (OpenDocumentContentParser.SVG_NS.equals(namespaceURI)) {
                return "title".equals(localName) || "desc".equals(localName);
            }
            return false;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            assert (this.nodeDepth >= 0);
            this.textNodeStack.set(this.nodeDepth++, this.isTextNode(namespaceURI, localName));
            assert (this.completelyFiltered >= 0);
            if (this.needsCompleteFiltering(namespaceURI, localName)) {
                ++this.completelyFiltered;
            }
            if (this.completelyFiltered == 0) {
                if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "h".equals(localName)) {
                    String el = this.headingStack.push(this.getXHTMLHeaderTagName(atts));
                    this.handler.startElement("http://www.w3.org/1999/xhtml", el, el, EMPTY_ATTRIBUTES);
                } else {
                    super.startElement(namespaceURI, localName, qName, atts);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.completelyFiltered == 0) {
                if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "h".equals(localName)) {
                    String el = this.headingStack.pop();
                    this.handler.endElement("http://www.w3.org/1999/xhtml", el, el);
                } else {
                    super.endElement(namespaceURI, localName, qName);
                }
                if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && ("tab-stop".equals(localName) || "tab".equals(localName))) {
                    this.characters(TAB, 0, TAB.length);
                }
            }
            if (this.needsCompleteFiltering(namespaceURI, localName)) {
                --this.completelyFiltered;
            }
            assert (this.completelyFiltered >= 0);
            --this.nodeDepth;
            assert (this.nodeDepth >= 0);
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }
    }
}

