/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorityconnectorpool;

import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnector;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorPool;
import org.apache.manifoldcf.core.connectorpool.ConnectorPool;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class AuthorityConnectorPool
implements IAuthorityConnectorPool {
    public static final String _rcsid = "@(#)$Id: AuthorityConnectorPool.java 1549105 2013-12-08 18:54:09Z kwright $";
    protected static final LocalPool localPool = new LocalPool();
    protected final IThreadContext threadContext;

    public AuthorityConnectorPool(IThreadContext threadContext) throws ManifoldCFException {
        this.threadContext = threadContext;
    }

    @Override
    public IAuthorityConnector[] grabMultiple(String[] orderingKeys, IAuthorityConnection[] authorityConnections) throws ManifoldCFException {
        String[] connectionNames = new String[authorityConnections.length];
        String[] classNames = new String[authorityConnections.length];
        ConfigParams[] configInfos = new ConfigParams[authorityConnections.length];
        int[] maxPoolSizes = new int[authorityConnections.length];
        for (int i = 0; i < authorityConnections.length; ++i) {
            connectionNames[i] = authorityConnections[i].getName();
            classNames[i] = authorityConnections[i].getClassName();
            configInfos[i] = authorityConnections[i].getConfigParams();
            maxPoolSizes[i] = authorityConnections[i].getMaxConnections();
        }
        return localPool.grabMultiple(this.threadContext, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
    }

    @Override
    public IAuthorityConnector grab(IAuthorityConnection authorityConnection) throws ManifoldCFException {
        return (IAuthorityConnector)localPool.grab(this.threadContext, authorityConnection.getName(), authorityConnection.getClassName(), authorityConnection.getConfigParams(), authorityConnection.getMaxConnections());
    }

    @Override
    public void releaseMultiple(IAuthorityConnection[] connections, IAuthorityConnector[] connectors) throws ManifoldCFException {
        String[] connectionNames = new String[connections.length];
        for (int i = 0; i < connections.length; ++i) {
            connectionNames[i] = connections[i].getName();
        }
        localPool.releaseMultiple(this.threadContext, connectionNames, connectors);
    }

    @Override
    public void release(IAuthorityConnection connection, IAuthorityConnector connector) throws ManifoldCFException {
        localPool.release(this.threadContext, connection.getName(), connector);
    }

    @Override
    public void pollAllConnectors() throws ManifoldCFException {
        localPool.pollAllConnectors(this.threadContext);
    }

    @Override
    public void flushUnusedConnectors() throws ManifoldCFException {
        localPool.flushUnusedConnectors(this.threadContext);
    }

    @Override
    public void closeAllConnectors() throws ManifoldCFException {
        localPool.closeAllConnectors(this.threadContext);
    }

    protected static class LocalPool
    extends ConnectorPool<IAuthorityConnector> {
        public LocalPool() {
            super("_AUTHORITYCONNECTORPOOL_");
        }

        protected boolean isInstalled(IThreadContext tc, String className) throws ManifoldCFException {
            IAuthorityConnectorManager connectorManager = AuthorityConnectorManagerFactory.make(tc);
            return connectorManager.isInstalled(className);
        }

        protected boolean isConnectionNameValid(IThreadContext tc, String connectionName) throws ManifoldCFException {
            IAuthorityConnectionManager connectionManager = AuthorityConnectionManagerFactory.make(tc);
            return connectionManager.load(connectionName) != null;
        }

        public IAuthorityConnector[] grabMultiple(IThreadContext tc, String[] orderingKeys, String[] connectionNames, String[] classNames, ConfigParams[] configInfos, int[] maxPoolSizes) throws ManifoldCFException {
            return (IAuthorityConnector[])this.grabMultiple(tc, IAuthorityConnector.class, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
        }
    }
}

