/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.internal.storage.AbstractGridResource;
import org.apache.sis.internal.storage.TiledGridCoverage;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakValueHashMap;

public abstract class TiledGridResource
extends AbstractGridResource {
    private final WeakValueHashMap<CacheKey, WritableRaster> rasters = new WeakValueHashMap(CacheKey.class);
    private RasterLoadingStrategy loadingStrategy;

    protected TiledGridResource(StoreListeners storeListeners) {
        super(storeListeners);
    }

    protected abstract DataStore getSynchronizationLock();

    protected abstract int[] getTileSize();

    protected int getAtomSize(boolean bl) throws DataStoreException {
        return bl ? TiledGridCoverage.getPixelsPerElement(this.getSampleModel()) : 1;
    }

    protected boolean getDissociableBands() throws DataStoreException {
        return this.getSampleModel() instanceof ComponentSampleModel;
    }

    protected abstract SampleModel getSampleModel() throws DataStoreException;

    protected abstract ColorModel getColorModel() throws DataStoreException;

    protected abstract Number getFillValue() throws DataStoreException;

    protected final GridCoverage preload(GridCoverage gridCoverage) throws DataStoreException {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        if (this.loadingStrategy != RasterLoadingStrategy.AT_RENDER_TIME && gridCoverage.getGridGeometry().getDimension() == 2) {
            try {
                RenderedImage renderedImage = gridCoverage.render(null);
                return new GridCoverage2D(gridCoverage.getGridGeometry(), gridCoverage.getSampleDimensions(), renderedImage);
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable = runtimeException.getCause();
                if (throwable instanceof DataStoreException) {
                    throw (DataStoreException)throwable;
                }
                if (throwable == null || !(runtimeException instanceof CannotEvaluateException)) {
                    throwable = runtimeException;
                }
                throw new DataStoreException(runtimeException.getLocalizedMessage(), throwable);
            }
        }
        return gridCoverage;
    }

    private boolean supportImmediateLoading() {
        return this.getTileSize().length == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RasterLoadingStrategy getLoadingStrategy() {
        DataStore dataStore = this.getSynchronizationLock();
        synchronized (dataStore) {
            if (this.loadingStrategy == null) {
                this.setLoadingStrategy(this.supportImmediateLoading());
            }
            return this.loadingStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setLoadingStrategy(RasterLoadingStrategy rasterLoadingStrategy) {
        DataStore dataStore = this.getSynchronizationLock();
        synchronized (dataStore) {
            if (rasterLoadingStrategy != null) {
                this.setLoadingStrategy(rasterLoadingStrategy == RasterLoadingStrategy.AT_READ_TIME && this.supportImmediateLoading());
            }
            return super.setLoadingStrategy(rasterLoadingStrategy);
        }
    }

    private void setLoadingStrategy(boolean bl) {
        this.loadingStrategy = bl ? RasterLoadingStrategy.AT_READ_TIME : RasterLoadingStrategy.AT_RENDER_TIME;
    }

    static final class CacheKey {
        private final int indexInTileVector;
        private final int[] includedBands;
        private final int[] subsampling;
        private final int[] subsamplingOffsets;

        CacheKey(int n, int[] nArray, int[] nArray2, int[] nArray3) {
            this.indexInTileVector = n;
            this.includedBands = nArray;
            this.subsampling = nArray2;
            this.subsamplingOffsets = nArray3;
        }

        public int hashCode() {
            return this.indexInTileVector + 73 * Arrays.hashCode(this.includedBands) + 1063 * Arrays.hashCode(this.subsampling) + 7919 * Arrays.hashCode(this.subsamplingOffsets);
        }

        public boolean equals(Object object) {
            if (object instanceof CacheKey) {
                CacheKey cacheKey = (CacheKey)object;
                return this.indexInTileVector == cacheKey.indexInTileVector && Arrays.equals(this.includedBands, cacheKey.includedBands) && Arrays.equals(this.subsampling, cacheKey.subsampling) && Arrays.equals(this.subsamplingOffsets, cacheKey.subsamplingOffsets);
            }
            return false;
        }
    }

    public final class Subset {
        final GridExtent sourceExtent;
        final GridExtent readExtent;
        final GridGeometry domain;
        final List<? extends SampleDimension> ranges;
        final int[] includedBands;
        final int[] subsampling;
        final int[] subsamplingOffsets;
        final int[] tileSize;
        final SampleModel modelForBandSubset;
        final ColorModel colorsForBandSubset;
        final Number fillValue;
        final WeakValueHashMap<CacheKey, WritableRaster> cache;

        public Subset(GridGeometry gridGeometry, int[] nArray) throws DataStoreException {
            boolean bl;
            int n;
            List<SampleDimension> list = TiledGridResource.this.getSampleDimensions();
            AbstractGridResource.RangeArgument rangeArgument = TiledGridResource.this.validateRangeArgument(list.size(), nArray);
            GridGeometry gridGeometry2 = TiledGridResource.this.getGridGeometry();
            this.sourceExtent = gridGeometry2.getExtent();
            this.tileSize = TiledGridResource.this.getTileSize();
            boolean bl2 = true;
            if (gridGeometry == null) {
                gridGeometry = gridGeometry2;
                this.readExtent = this.sourceExtent;
                this.subsamplingOffsets = new int[gridGeometry2.getDimension()];
                this.subsampling = new int[this.subsamplingOffsets.length];
                Arrays.fill(this.subsampling, 1);
            } else {
                int n2;
                int n22 = TiledGridResource.this.getAtomSize(true);
                int bl3 = TiledGridResource.this.getAtomSize(false);
                n = this.tileSize[0];
                int n3 = this.tileSize[1];
                if ((long)n >= this.sourceExtent.getSize(0)) {
                    n = n22;
                    bl2 = false;
                }
                if ((long)n3 >= this.sourceExtent.getSize(1)) {
                    n2 = bl3;
                    bl2 = false;
                }
                int[] nArray2 = new int[]{n, n2};
                int[] nArray3 = new int[nArray2.length];
                Arrays.fill(nArray3, Integer.MAX_VALUE);
                if (n22 != 1) {
                    nArray3[0] = 1;
                }
                if (bl3 != 1) {
                    nArray3[1] = 1;
                }
                GridDerivation gridDerivation = gridGeometry2.derive().chunkSize(nArray2).maximumSubsampling(nArray3).rounding(GridRoundingMode.ENCLOSING).subgrid(gridGeometry);
                gridGeometry = gridDerivation.build();
                this.readExtent = gridDerivation.getIntersection();
                this.subsampling = gridDerivation.getSubsampling();
                this.subsamplingOffsets = gridDerivation.getSubsamplingOffsets();
            }
            int[] nArray4 = null;
            boolean bl4 = rangeArgument.isIdentity();
            if (!bl4) {
                list = Arrays.asList(rangeArgument.select(list));
                boolean bl5 = bl = !TiledGridResource.this.getDissociableBands();
                if (!bl) {
                    nArray4 = new int[rangeArgument.getNumBands()];
                    for (n = 0; n < nArray4.length; ++n) {
                        nArray4[n] = rangeArgument.getSourceIndex(n);
                    }
                    assert (ArraysExt.isSorted(nArray4, true));
                    if (rangeArgument.hasAllBands) {
                        assert (ArraysExt.isRange(0, nArray4));
                        nArray4 = null;
                    }
                }
            }
            this.domain = gridGeometry;
            this.ranges = list;
            this.includedBands = nArray4;
            this.modelForBandSubset = rangeArgument.select(TiledGridResource.this.getSampleModel(), bl);
            this.colorsForBandSubset = rangeArgument.select(TiledGridResource.this.getColorModel());
            this.fillValue = TiledGridResource.this.getFillValue();
            this.cache = bl2 ? TiledGridResource.this.rasters : new WeakValueHashMap(CacheKey.class);
        }

        public boolean isXContiguous() {
            return this.includedBands == null && this.subsampling[0] == 1;
        }
    }
}

